/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.helper;

import com.perforce.p4java.impl.generic.core.License;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapUnmapper {
    public static void unmapChangelistMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String fileStr;
            Object stream;
            Object date;
            Object status;
            Object type;
            Object user;
            strBuf.append("Change: " + inMap.get("Change") + "\n\n");
            Object client = inMap.get("Client");
            if (client != null) {
                strBuf.append("Client: " + client + "\n\n");
            }
            if ((user = inMap.get("User")) != null) {
                strBuf.append("User: " + user + "\n\n");
            }
            if ((type = inMap.get("Type")) != null) {
                strBuf.append("Type: " + type + "\n\n");
            }
            if ((status = inMap.get("Status")) != null) {
                strBuf.append("Status: " + status + "\n\n");
            }
            if ((date = inMap.get("Date")) != null) {
                strBuf.append("Date: " + date + "\n\n");
            }
            if ((stream = inMap.get("Stream")) != null) {
                strBuf.append("Stream: " + stream + "\n\n");
            }
            String descr = MapUnmapper.replaceNewlines((String)inMap.get("Description"));
            strBuf.append("Description:\n" + (descr == null ? "" : descr) + "\n");
            strBuf.append("Files:\n");
            int i = 0;
            while ((fileStr = (String)inMap.get("Files" + i)) != null) {
                strBuf.append("\t" + inMap.get("Files" + i) + "\n");
                ++i;
            }
            strBuf.append("\n");
            i = 0;
            while ((fileStr = (String)inMap.get("Jobs" + i)) != null) {
                if (i == 0) {
                    strBuf.append("Jobs:\n");
                }
                strBuf.append("\t" + inMap.get("Jobs" + i) + "\n");
                ++i;
            }
            strBuf.append("\n");
        }
    }

    public static void unmapJobMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            for (Map.Entry<String, Object> entry : inMap.entrySet()) {
                strBuf.append(entry.getKey() + ": " + MapUnmapper.replaceNewlines((String)entry.getValue()) + "\n\n");
            }
        }
    }

    public static void unmapSpecMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            MapUnmapper.updateSpecSection(inMap, "Fields", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Values", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Presets", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Words", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Formats", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Openable", strBuf);
            MapUnmapper.updateSpecSection(inMap, "Comments", strBuf);
        }
    }

    public static void unmapLicenseMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            long users;
            long clients;
            Object platform;
            Object ipaddress;
            Object application;
            Object customer;
            Object supportExpires;
            strBuf.append("License: " + inMap.get("License") + "\n\n");
            Object licenseExpires = inMap.get("License-Expires");
            if (licenseExpires != null) {
                strBuf.append("License-Expires: " + licenseExpires + "\n\n");
            }
            if ((supportExpires = inMap.get("Support-Expires")) != null) {
                strBuf.append("Support-Expires: " + supportExpires + "\n\n");
            }
            if ((customer = inMap.get("Customer")) != null) {
                strBuf.append("Customer: " + customer + "\n\n");
            }
            if ((application = inMap.get("Application")) != null) {
                strBuf.append("Application: " + application + "\n\n");
            }
            if ((ipaddress = inMap.get("IPaddress")) != null) {
                strBuf.append("IPaddress: " + ipaddress + "\n\n");
            }
            if ((platform = inMap.get("Platform")) != null) {
                strBuf.append("Platform: " + platform + "\n\n");
            }
            if ((clients = License.readValues(inMap, "Clients")) > 0L) {
                strBuf.append("Clients: " + clients + "\n\n");
            }
            if ((users = License.readValues(inMap, "Users")) > 0L) {
                strBuf.append("Users: " + users + "\n\n");
            }
            if (inMap.get("ExtraCapabilities0") != null) {
                String capability;
                strBuf.append("ExtraCapabilities: \n");
                int i = 0;
                while ((capability = (String)inMap.get("ExtraCapabilities" + i)) != null) {
                    strBuf.append("\t" + inMap.get("ExtraCapabilities" + i) + "\n");
                    ++i;
                }
            }
        }
    }

    public static void unmapExtensionMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            Object extDebug;
            Object extP4USER;
            Object extAllowedGroups;
            Object extConfig;
            Object description;
            Object update;
            Object owner;
            Object name;
            Object extEnabled;
            Object extMaxScriptMem;
            Object extMaxScriptTime;
            Object extRev;
            Object extUUID;
            Object extVersion;
            Object extDescription;
            Object extName = inMap.get("ExtName");
            if (extName != null) {
                strBuf.append("ExtName: " + extName + "\n\n");
            }
            if ((extDescription = inMap.get("ExtDescription")) != null) {
                strBuf.append("ExtDescription: " + extDescription + "\n\n");
            }
            if ((extVersion = inMap.get("ExtVersion")) != null) {
                strBuf.append("ExtVersion: " + extVersion + "\n\n");
            }
            if ((extUUID = inMap.get("ExtUUID")) != null) {
                strBuf.append("ExtUUID: " + extUUID + "\n\n");
            }
            if ((extRev = inMap.get("ExtRev")) != null) {
                strBuf.append("ExtRev: " + extRev + "\n\n");
            }
            if ((extMaxScriptTime = inMap.get("ExtMaxScriptTime")) != null) {
                strBuf.append("ExtMaxScriptTime: " + extMaxScriptTime + "\n\n");
            }
            if ((extMaxScriptMem = inMap.get("ExtMaxScriptMem")) != null) {
                strBuf.append("ExtMaxScriptMem: " + extMaxScriptMem + "\n\n");
            }
            if ((extEnabled = inMap.get("ExtEnabled")) != null) {
                strBuf.append("ExtEnabled: " + extEnabled + "\n\n");
            }
            if ((name = inMap.get("Name")) != null) {
                strBuf.append("Name: " + name + "\n\n");
            }
            if ((owner = inMap.get("Owner")) != null) {
                strBuf.append("Owner: " + owner + "\n\n");
            }
            if ((update = inMap.get("Update")) != null) {
                strBuf.append("Update: " + update + "\n\n");
            }
            if ((description = inMap.get("Description")) != null) {
                strBuf.append("Description: " + description + "\n\n");
            }
            if ((extConfig = inMap.get("ExtConfig")) != null) {
                Map extConfigMap = (Map)extConfig;
                strBuf.append("ExtConfig:\n");
                for (String key : extConfigMap.keySet()) {
                    strBuf.append("\t" + key + ": " + (String)extConfigMap.get(key) + "\n");
                }
            }
            if ((extAllowedGroups = inMap.get("ExtAllowedGroups")) != null) {
                strBuf.append("ExtAllowedGroups: " + extAllowedGroups + "\n\n");
            }
            if ((extP4USER = inMap.get("ExtP4USER")) != null) {
                strBuf.append("ExtP4USER: " + extP4USER + "\n\n");
            }
            if ((extDebug = inMap.get("ExtDebug")) != null) {
                strBuf.append("ExtDebug: " + extDebug + "\n\n");
            }
        }
    }

    private static void updateSpecSection(Map<String, Object> inMap, String section, StringBuffer strBuf) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : inMap.keySet()) {
            if (!key.startsWith(section)) continue;
            keyList.add(key);
        }
        if (keyList.size() > 0) {
            strBuf.append(section + ":\n");
            for (String key : keyList) {
                Object value = inMap.get(key);
                strBuf.append("\t" + value + "\n");
            }
        }
    }

    public static void unmapClientMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String fileStr;
            Object host;
            strBuf.append("Client: " + inMap.get("Client") + "\n\n");
            Object owner = inMap.get("Owner");
            if (owner != null) {
                strBuf.append("Owner: " + owner + "\n\n");
            }
            if ((host = inMap.get("Host")) != null) {
                strBuf.append("Host: " + host.toString() + "\n\n");
            }
            if (inMap.containsKey("Update")) {
                strBuf.append("Update: " + inMap.get("Update") + "\n\n");
            }
            if (inMap.containsKey("Access")) {
                strBuf.append("Access: " + inMap.get("Access") + "\n\n");
            }
            if (inMap.containsKey("Options")) {
                strBuf.append("Options: " + inMap.get("Options") + "\n\n");
            }
            if (inMap.containsKey("SubmitOptions")) {
                strBuf.append("SubmitOptions: " + inMap.get("SubmitOptions") + "\n\n");
            }
            strBuf.append("Root: " + inMap.get("Root") + "\n\n");
            if (inMap.containsKey("LineEnd")) {
                strBuf.append("LineEnd: " + inMap.get("LineEnd") + "\n\n");
            }
            String descr = MapUnmapper.replaceNewlines((String)inMap.get("Description"));
            strBuf.append("Description:\n" + (descr == null ? "" : descr) + "\n");
            strBuf.append("View:\n");
            int i = 0;
            while ((fileStr = (String)inMap.get("View" + i)) != null) {
                strBuf.append("\t" + inMap.get("View" + i) + "\n");
                ++i;
            }
            strBuf.append("\n");
            i = 0;
            while ((fileStr = (String)inMap.get("AltRoots" + i)) != null) {
                if (i == 0) {
                    strBuf.append("AltRoots:\n");
                }
                strBuf.append("\t" + inMap.get("AltRoots" + i) + "\n");
                ++i;
            }
            strBuf.append("\n");
            if (inMap.containsKey("Stream")) {
                strBuf.append("Stream: " + inMap.get("Stream") + "\n\n");
            }
            if (inMap.containsKey("ServerID")) {
                strBuf.append("ServerID: " + inMap.get("ServerID") + "\n\n");
            }
            if (inMap.containsKey("StreamAtChange")) {
                strBuf.append("StreamAtChange: " + inMap.get("StreamAtChange") + "\n\n");
            }
            if (inMap.containsKey("Type")) {
                strBuf.append("Type: " + inMap.get("Type") + "\n\n");
            }
            i = 0;
            while ((fileStr = (String)inMap.get("ChangeView" + i)) != null) {
                if (i == 0) {
                    strBuf.append("ChangeView:\n");
                }
                strBuf.append("\t" + inMap.get("ChangeView" + i) + "\n");
                ++i;
            }
            strBuf.append("\n");
            if (inMap.containsKey("Backup")) {
                strBuf.append("Backup: " + inMap.get("Backup") + "\n\n");
            }
        }
    }

    public static void unmapUserMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("User: " + inMap.get("User") + "\n\n");
            if (inMap.containsKey("Email")) {
                strBuf.append("Email: " + inMap.get("Email") + "\n\n");
            }
            if (inMap.containsKey("FullName")) {
                strBuf.append("FullName: " + inMap.get("FullName") + "\n\n");
            }
            if (inMap.containsKey("JobView")) {
                strBuf.append("JobView: " + inMap.get("JobView") + "\n\n");
            }
            if (inMap.containsKey("Password")) {
                strBuf.append("Password: " + inMap.get("Password") + "\n\n");
            }
            if (inMap.containsKey("Type")) {
                strBuf.append("Type: " + inMap.get("Type") + "\n\n");
            }
            int i = 0;
            while ((mapStr = (String)inMap.get("Reviews" + i)) != null) {
                if (i == 0) {
                    strBuf.append("Reviews:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapUserGroupMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Group: " + inMap.get("Group") + "\n\n");
            if (inMap.containsKey("MaxResults")) {
                strBuf.append("MaxResults: " + inMap.get("MaxResults") + "\n\n");
            }
            if (inMap.containsKey("MaxScanRows")) {
                strBuf.append("MaxScanRows: " + inMap.get("MaxScanRows") + "\n\n");
            }
            if (inMap.containsKey("MaxLockTime")) {
                strBuf.append("MaxLockTime: " + inMap.get("MaxLockTime") + "\n\n");
            }
            if (inMap.containsKey("Timeout")) {
                strBuf.append("Timeout: " + inMap.get("Timeout") + "\n\n");
            }
            if (inMap.containsKey("PasswordTimeout")) {
                strBuf.append("PasswordTimeout: " + inMap.get("PasswordTimeout") + "\n\n");
            }
            if (inMap.containsKey("MaxOpenFiles")) {
                strBuf.append("MaxOpenFiles: " + inMap.get("MaxOpenFiles") + "\n\n");
            }
            int i = 0;
            while ((mapStr = (String)inMap.get("Subgroups" + i)) != null) {
                if (i == 0) {
                    strBuf.append("Subgroups:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
            i = 0;
            while ((mapStr = (String)inMap.get("Owners" + i)) != null) {
                if (i == 0) {
                    strBuf.append("Owners:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
            i = 0;
            while ((mapStr = (String)inMap.get("Users" + i)) != null) {
                if (i == 0) {
                    strBuf.append("Users:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapLabelMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Label: " + inMap.get("Label") + "\n\n");
            strBuf.append("Owner: " + inMap.get("Owner") + "\n\n");
            if (inMap.containsKey("Update")) {
                strBuf.append("Update: " + inMap.get("Update") + "\n\n");
            }
            if (inMap.containsKey("Access")) {
                strBuf.append("Access: " + inMap.get("Access") + "\n\n");
            }
            if (inMap.containsKey("Revision")) {
                strBuf.append("Revision: " + inMap.get("Revision") + "\n\n");
            }
            String descr = MapUnmapper.replaceNewlines((String)inMap.get("Description"));
            strBuf.append("Description:\n" + (descr == null ? "" : descr) + "\n");
            if (inMap.containsKey("Options")) {
                strBuf.append("Options: " + inMap.get("Options") + "\n\n");
            }
            int i = 0;
            while ((mapStr = (String)inMap.get("View" + i)) != null) {
                if (i == 0) {
                    strBuf.append("View:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapBranchMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Branch: " + inMap.get("Branch") + "\n\n");
            if (inMap.containsKey("Owner")) {
                strBuf.append("Owner: " + inMap.get("Owner") + "\n\n");
            }
            if (inMap.containsKey("Update")) {
                strBuf.append("Update: " + inMap.get("Update") + "\n\n");
            }
            if (inMap.containsKey("Access")) {
                strBuf.append("Access: " + inMap.get("Access") + "\n\n");
            }
            String descr = MapUnmapper.replaceNewlines((String)inMap.get("Description"));
            strBuf.append("Description:\n" + (descr == null ? "" : descr) + "\n");
            if (inMap.containsKey("Options")) {
                strBuf.append("Options: " + inMap.get("Options") + "\n\n");
            }
            int i = 0;
            while ((mapStr = (String)inMap.get("View" + i)) != null) {
                if (i == 0) {
                    strBuf.append("View:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapDepotMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Depot: " + inMap.get("Depot") + "\n\n");
            if (inMap.containsKey("Owner")) {
                strBuf.append("Owner: " + inMap.get("Owner") + "\n\n");
            }
            if (inMap.containsKey("Date")) {
                strBuf.append("Date: " + inMap.get("Date") + "\n\n");
            }
            if (inMap.containsKey("Type")) {
                strBuf.append("Type: " + inMap.get("Type") + "\n\n");
            }
            String descr = MapUnmapper.replaceNewlines((String)inMap.get("Description"));
            strBuf.append("Description:\n" + (descr == null ? "" : descr) + "\n");
            if (inMap.containsKey("Address")) {
                strBuf.append("Address: " + inMap.get("Address") + "\n\n");
            }
            if (inMap.containsKey("Suffix")) {
                strBuf.append("Suffix: " + inMap.get("Suffix") + "\n\n");
            }
            if (inMap.containsKey("StreamDepth")) {
                strBuf.append("StreamDepth: " + inMap.get("StreamDepth") + "\n\n");
            }
            if (inMap.containsKey("Map")) {
                strBuf.append("Map: " + inMap.get("Map") + "\n\n");
            }
            int i = 0;
            while ((mapStr = (String)inMap.get("SpecMap" + i)) != null) {
                if (i == 0) {
                    strBuf.append("SpecMap:\n");
                }
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapProtectionEntriesMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Protections:\n");
            int i = 0;
            while ((mapStr = (String)inMap.get("Protections" + i)) != null) {
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static void unmapStreamMap(Map<String, Object> inMap, StringBuffer strBuf) {
        String[] viewKeys;
        String extraTag;
        if (inMap == null || strBuf == null) {
            return;
        }
        inMap.remove("altArg");
        inMap.remove("specFormatted");
        inMap.remove("Comments");
        int i = 0;
        while ((extraTag = (String)inMap.get("extraTag" + i)) != null) {
            inMap.remove(extraTag);
            ++i;
        }
        for (Map.Entry<String, Object> entry : inMap.entrySet()) {
            String key = entry.getKey();
            String value = (String)entry.getValue();
            Pattern pattern = Pattern.compile("([a-zA-Z]+)([0-9]+)");
            Matcher matcher = pattern.matcher(key);
            if (matcher.matches()) continue;
            value = value.contains("\n") ? MapUnmapper.replaceNewlines(value) : value;
            strBuf.append(key + ": " + (value == null ? "" : value) + "\n\n");
        }
        block2: for (String key : viewKeys = new String[]{"Paths", "Remapped", "Ignored"}) {
            int i2 = 0;
            while (true) {
                String mapStr = (String)inMap.get(key + i2);
                String mapStrComment = (String)inMap.get(key + "Comment" + i2);
                if (mapStrComment == null) {
                    mapStrComment = "";
                }
                if (mapStr == null && mapStrComment == "") continue block2;
                if (i2 == 0) {
                    strBuf.append(key + ":\n");
                }
                strBuf.append("\t" + mapStr + mapStrComment + "\n");
                ++i2;
            }
        }
    }

    public static void unmapTriggerEntriesMap(Map<String, Object> inMap, StringBuffer strBuf) {
        if (inMap != null && strBuf != null) {
            String mapStr;
            strBuf.append("Triggers:\n");
            int i = 0;
            while ((mapStr = (String)inMap.get("Triggers" + i)) != null) {
                strBuf.append("\t" + mapStr + "\n");
                ++i;
            }
        }
    }

    public static String replaceNewlines(String str) {
        if (str != null) {
            String[] strs = str.split("\n");
            if (strs.length == 1) {
                return "\t" + str + "\n";
            }
            StringBuilder retStr = new StringBuilder();
            for (String s : strs) {
                retStr.append("\t");
                retStr.append(s);
                retStr.append("\n");
            }
            return retStr.toString();
        }
        return null;
    }
}

