/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.ListData;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.IListDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.ListOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import java.util.List;
import java.util.Map;

public class ListDelegator
extends BaseDelegator
implements IListDelegator {
    public ListDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public ListData getListData(List<IFileSpec> fileSpecs, ListOptions options) throws P4JavaException {
        Map<String, Object>[] resultMap = this.server.execMapCmd(CmdSpec.LIST.toString(), Parameters.processParameters(options, fileSpecs, this.server), null);
        if (!ObjectUtils.nonNull(resultMap)) {
            return null;
        }
        String label = null;
        long fileCount = 0L;
        for (Map<String, Object> map : resultMap) {
            ResultMapParser.handleErrorStr(map);
            try {
                if (map.containsKey("label")) {
                    label = P4ResultMapUtils.parseString(map, "label");
                }
                if (!map.containsKey("totalFileCount")) continue;
                fileCount = P4ResultMapUtils.parseLong(map, "totalFileCount");
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
        }
        return new ListData(fileCount, label);
    }

    @Override
    public ListData getListData(List<IFileSpec> fileSpecs, ListOptions options, String clientName) throws P4JavaException {
        if (!this.server.getCurrentClient().getName().equals(clientName)) {
            this.server.setCurrentClient(this.server.getClient(clientName));
        }
        options.setLimitClient(true);
        return this.getListData(fileSpecs, options);
    }
}

