/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.Stream;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetStreamOptions;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IStreamDelegator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class StreamDelegator
extends BaseDelegator
implements IStreamDelegator {
    public StreamDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String createStream(@Nonnull IStream stream) throws P4JavaException {
        Validate.notNull((Object)stream);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, new String[]{"-i"}, InputMapper.map(stream, this.server));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public IStream getStream(@Nonnull String streamPath) throws P4JavaException {
        return this.getStream(streamPath, new GetStreamOptions());
    }

    @Override
    public IStream getStream(@Nonnull String streamPath, GetStreamOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)streamPath, (String)"Stream name shouldn't null or empty.", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, new String[]{"-o", streamPath}, (IServer)this.server), null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, new Function<Map, IStream>(){

            @Override
            public IStream apply(Map map) {
                return new Stream((Map<String, Object>)map, StreamDelegator.this.server);
            }
        });
    }

    @Override
    public String updateStream(@Nonnull IStream stream, StreamOptions opts) throws P4JavaException {
        Validate.notNull((Object)stream);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, "-i", (IServer)this.server), InputMapper.map(stream, this.server));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String deleteStream(@Nonnull String streamPath, StreamOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)streamPath, (String)"Stream name shouldn't null or empty.", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, new String[]{"-d", streamPath}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }
}

