/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.util.FilesHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAuthHelper {
    public static final int DEFAULT_LOCK_TRY = 100;
    public static final long DEFAULT_LOCK_DELAY = 300000L;
    public static final long DEFAULT_LOCK_WAIT = 1L;
    protected static final String SERVER_ADDRESS_MAP_KEY = "serverAddress";
    protected static final String USER_NAME_MAP_KEY = "userName";
    protected static final String AUTH_VALUE_MAP_KEY = "authValue";
    private static final Object lock = new Object();

    protected static Map<String, String> getMemoryEntry(String userName, String serverAddress, Map<String, String> authMap) {
        String p4Port = serverAddress;
        ConcurrentHashMap<String, String> entryMap = new ConcurrentHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)serverAddress) && ObjectUtils.nonNull(authMap)) {
            String prefix;
            if (serverAddress.lastIndexOf(58) == -1) {
                p4Port = "localhost:" + serverAddress;
            }
            if (authMap.containsKey(prefix = p4Port + "=" + userName)) {
                String authValue = authMap.get(prefix);
                entryMap.put(SERVER_ADDRESS_MAP_KEY, p4Port);
                entryMap.put(USER_NAME_MAP_KEY, userName);
                entryMap.put(AUTH_VALUE_MAP_KEY, authValue);
            }
        }
        return entryMap;
    }

    protected static List<Map<String, String>> getMemoryEntries(Map<String, String> authMap) {
        CopyOnWriteArrayList<Map<String, String>> authList = new CopyOnWriteArrayList<Map<String, String>>();
        if (ObjectUtils.nonNull(authMap)) {
            for (Map.Entry<String, String> entry : authMap.entrySet()) {
                String line = entry.getKey() + ":" + entry.getValue();
                int equals = line.indexOf(61);
                AbstractAuthHelper.popularAuthEntry(equals, line, authList);
            }
        }
        return authList;
    }

    private static void popularAuthEntry(int equals, String line, List<Map<String, String>> authList) {
        int colon;
        if (equals != -1 && (colon = StringUtils.indexOf((CharSequence)line, (int)58, (int)equals)) != -1 && colon + 1 < line.length()) {
            String serverAddress = StringUtils.substring((String)line, (int)0, (int)equals);
            String userName = StringUtils.substring((String)line, (int)(equals + 1), (int)colon);
            String authValue = StringUtils.substring((String)line, (int)(colon + 1));
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            map.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
            map.put(USER_NAME_MAP_KEY, userName);
            map.put(AUTH_VALUE_MAP_KEY, authValue);
            authList.add(map);
        }
    }

    protected static void saveMemoryEntry(String userName, String serverAddress, String authValue, Map<String, String> authMap) {
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)serverAddress) && ObjectUtils.nonNull(authMap)) {
            String p4Port = serverAddress;
            if (serverAddress.lastIndexOf(58) == -1) {
                p4Port = "localhost:" + serverAddress;
            }
            String prefix = p4Port + "=" + userName;
            if (StringUtils.isNotBlank((CharSequence)authValue)) {
                authMap.put(prefix, authValue);
            } else if (authMap.containsKey(prefix)) {
                authMap.remove(prefix);
            }
        }
    }

    protected static List<Map<String, String>> getFileEntries(File authFile) throws IOException {
        CopyOnWriteArrayList<Map<String, String>> authList = new CopyOnWriteArrayList<Map<String, String>>();
        if (ObjectUtils.nonNull(authFile) && authFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(authFile));){
                String line = reader.readLine();
                while (line != null) {
                    int equals = StringUtils.indexOf((CharSequence)line, (int)61);
                    AbstractAuthHelper.popularAuthEntry(equals, line, authList);
                    line = reader.readLine();
                }
            }
        }
        return authList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveFileEntry(String userName, String serverAddress, String authValue, File authFile, int lockTry, long lockDelay, long lockWait) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)serverAddress) && ObjectUtils.nonNull(authFile)) {
            String p4Port = AbstractAuthHelper.firstMatch(StringUtils.lastIndexOf((CharSequence)serverAddress, (int)58) == -1, "localhost:" + serverAddress, serverAddress);
            Path authFilePath = authFile.toPath();
            Object object = lock;
            synchronized (object) {
                block47: {
                    if (Files.notExists(authFilePath, new LinkOption[0])) {
                        Files.createDirectories(authFilePath.getParent(), new FileAttribute[0]);
                        AbstractAuthHelper.createFileIgnoreIfFileAlreadyExists(authFilePath);
                    }
                    File lockFile = AbstractAuthHelper.createLockFileIfNotExist(authFile);
                    boolean locked = false;
                    try (RandomAccessFile lockFileRandomAccessor = new RandomAccessFile(lockFile, "rw");
                         FileChannel fileChannel = lockFileRandomAccessor.getChannel();
                         FileLock lock = AbstractAuthHelper.tryLockFile(fileChannel, lockFile, lockTry, lockWait);){
                        if (!ObjectUtils.nonNull(lock) || !lock.isValid()) break block47;
                        locked = true;
                        String authValuePrefix = StringHelper.format("%s=%s:", p4Port, userName);
                        String newAuthValue = AbstractAuthHelper.firstMatch(StringUtils.isNotBlank((CharSequence)authValue), authValuePrefix + authValue, "");
                        try {
                            AbstractAuthHelper.readAuthFileContentPlusNewAuthValueAndWriteToTempAuthFile(authFile, authValuePrefix, newAuthValue);
                            AbstractAuthHelper.updateReadBit(authFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            P4JavaExceptions.throwIOException(e, "P4TICKETS file: %s could not be overwritten.", authFile.getAbsolutePath());
                        }
                        AbstractAuthHelper.updateReadBit(authFile);
                    }
                    finally {
                        if (locked) {
                            Files.deleteIfExists(lockFile.toPath());
                        }
                    }
                }
            }
        }
    }

    private static void createFileIgnoreIfFileAlreadyExists(Path filePath) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
    }

    private static File createLockFileIfNotExist(@Nonnull File authFile) throws IOException {
        File lockFile = new File(authFile.getAbsolutePath() + ".lck");
        Path lockFilePath = lockFile.toPath();
        AbstractAuthHelper.createFileIgnoreIfFileAlreadyExists(lockFilePath);
        return lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAuthFileContentPlusNewAuthValueAndWriteToTempAuthFile(File authFile, String authValuePrefix, String newAuthValue) throws IOException {
        File tempAuth = File.createTempFile("p4auth_" + System.currentTimeMillis(), ".txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(authFile));
             PrintWriter writer = new PrintWriter(tempAuth, "utf-8");){
            String possibleValidAuthValue;
            boolean processed = false;
            while ((possibleValidAuthValue = reader.readLine()) != null) {
                boolean isExistingAuthValueEntry;
                boolean bl = isExistingAuthValueEntry = !processed && StringUtils.startsWith((CharSequence)possibleValidAuthValue, (CharSequence)authValuePrefix);
                if (isExistingAuthValueEntry) {
                    if (StringUtils.isNotBlank((CharSequence)newAuthValue)) {
                        writer.println(newAuthValue);
                    }
                    processed = true;
                    continue;
                }
                writer.println(possibleValidAuthValue);
            }
            if (!processed && StringUtils.isNotBlank((CharSequence)newAuthValue)) {
                writer.println(newAuthValue);
            }
            writer.flush();
        }
        if (authFile.exists()) {
            authFile.setWritable(true);
        }
        try {
            Files.move(tempAuth.toPath(), authFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            if (!FilesHelper.copy(tempAuth, authFile)) {
                P4JavaExceptions.throwIOException("P4 auth file: %s could not be overwritten.", authFile.getAbsolutePath());
            }
        }
        finally {
            if (tempAuth.exists()) {
                tempAuth.delete();
            }
        }
    }

    private static FileLock tryLockFile(@Nullable FileChannel lockFileChannel, @Nonnull File lockFile, int lockTry, long lockWait) throws IOException {
        int lockTries = AbstractAuthHelper.firstMatch(lockTry < 1, 100, lockTry);
        long lockWaits = AbstractAuthHelper.firstMatch(lockWait < 1L, 1L, lockWait);
        String currentThreadName = Thread.currentThread().getName();
        FileLock fileLock = null;
        if (ObjectUtils.nonNull(lockFileChannel)) {
            do {
                try {
                    Log.info("-----%s thread try to get lock", currentThreadName);
                    fileLock = lockFileChannel.tryLock();
                    if (fileLock.isValid()) {
                        Log.info("=====%s thread get lock successfully\r\n", currentThreadName);
                    }
                    if (ObjectUtils.isNull(fileLock)) {
                        System.out.println("did not get the lock");
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (ObjectUtils.nonNull(fileLock) && fileLock.isValid()) break;
                if (lockFile.lastModified() <= 0L) continue;
                try {
                    Log.info("-----%s thread put to sleep, and it will retry lock %s times", currentThreadName, lockTries - 1);
                    TimeUnit.SECONDS.sleep(lockWaits);
                }
                catch (InterruptedException e) {
                    Log.error("Error waiting for auth lock file: %s", e.getLocalizedMessage());
                }
            } while (lockTries-- > 0);
            if (ObjectUtils.isNull(fileLock) || !fileLock.isValid()) {
                P4JavaExceptions.throwIOException("Error creating new auth lock file \"%s\" after retries: %s", lockFile.getAbsolutePath(), lockTry);
            }
        }
        return fileLock;
    }

    private static <T> T firstMatch(boolean expression, T first, T second) {
        if (expression) {
            return first;
        }
        return second;
    }

    private static void updateReadBit(@Nullable File file) throws IOException {
        if (ObjectUtils.nonNull(file)) {
            file.setReadOnly();
            ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
            if (ObjectUtils.isNull(helper)) {
                helper = SysFileHelperBridge.getSysFileCommands();
            }
            if (ObjectUtils.nonNull(helper)) {
                helper.setOwnerReadOnly(file.getAbsolutePath());
            }
        }
    }
}

