/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.mapapi;

import com.perforce.p4java.mapapi.MapDisambiguate;
import com.perforce.p4java.mapapi.MapFlag;
import com.perforce.p4java.mapapi.MapHalf;
import com.perforce.p4java.mapapi.MapItem;
import com.perforce.p4java.mapapi.MapItemArray;
import com.perforce.p4java.mapapi.MapJoiner;
import com.perforce.p4java.mapapi.MapJoiner2;
import com.perforce.p4java.mapapi.MapPair;
import com.perforce.p4java.mapapi.MapPairArray;
import com.perforce.p4java.mapapi.MapParams;
import com.perforce.p4java.mapapi.MapStrings;
import com.perforce.p4java.mapapi.MapTableT;
import com.perforce.p4java.mapapi.MapTree;
import com.perforce.p4java.mapapi.MapWrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;

public class MapTable {
    public int count = 0;
    public MapItem entry = null;
    public boolean hasMaps = false;
    public boolean hasOverlays = false;
    public boolean hasHavemaps = false;
    public boolean hasAndmaps = false;
    public String emptyReason = "";
    public boolean joinError = false;
    public int caseMode = -1;
    public MapTree[] trees = new MapTree[]{new MapTree(), new MapTree()};

    private static long CHARHASH(long h, int c) {
        return 293L * h + (long)c;
    }

    public boolean isEmpty() {
        return !this.hasMaps;
    }

    public boolean joinError() {
        return this.joinError;
    }

    public boolean hasOverlays() {
        return this.hasOverlays;
    }

    public boolean hasHavemaps() {
        return this.hasHavemaps;
    }

    public boolean hasAndmaps() {
        return this.hasAndmaps;
    }

    public MapTable set(MapTable f) {
        if (this == f) {
            return this;
        }
        this.clear();
        this.insert(f, true, false);
        return this;
    }

    public void clear() {
        this.count = 0;
        this.entry = null;
        this.hasMaps = false;
        this.hasOverlays = false;
        this.hasHavemaps = false;
        this.hasAndmaps = false;
        this.trees[MapTableT.LHS.dir].clear();
        this.trees[MapTableT.RHS.dir].clear();
    }

    public void setCaseSensitivity(int mode) {
        if (mode != 0 && mode != 1) {
            return;
        }
        this.caseMode = mode;
        for (MapItem map = this.entry; map != null; map = map.next()) {
            map.half(MapTableT.LHS).setCaseMode(mode);
            map.half(MapTableT.RHS).setCaseMode(mode);
        }
    }

    public void reverse() {
        if (this.entry != null) {
            this.entry = this.entry.reverse();
        }
    }

    public void insert(MapTable table, boolean fwd, boolean rev) {
        for (MapItem map = table.entry; map != null; map = map.next()) {
            if (fwd) {
                this.insert(map.lhs().get(), map.rhs().get(), map.flag());
            }
            if (!rev) continue;
            this.insert(map.rhs().get(), map.lhs().get(), map.flag());
        }
        this.reverse();
    }

    public void insert(String lhs, String rhs, MapFlag mapFlag) {
        this.entry = new MapItem(this.entry, lhs, rhs, mapFlag, this.count++, this.caseMode);
        if (mapFlag != MapFlag.MfUnmap) {
            this.hasMaps = true;
        }
        if (mapFlag == MapFlag.MfRemap || mapFlag == MapFlag.MfHavemap) {
            this.hasOverlays = true;
        }
        if (mapFlag == MapFlag.MfHavemap) {
            this.hasHavemaps = true;
        }
        if (mapFlag == MapFlag.MfAndmap) {
            this.hasAndmaps = true;
        }
        this.trees[MapTableT.LHS.dir].clear();
        this.trees[MapTableT.RHS.dir].clear();
    }

    public void insert(String lhs, int slot, String rhs, MapFlag mapFlag) {
        this.insert(lhs, rhs, mapFlag);
        this.entry = this.entry.move(slot);
    }

    public void insertNoDups(String lhs, String rhs, MapFlag mapFlag) {
        MapHalf hLhs = new MapHalf(lhs);
        MapHalf hRhs = new MapHalf(rhs);
        int max = 8;
        for (MapItem map = this.entry; map != null && max-- != 0; map = map.next()) {
            if (!(mapFlag == MapFlag.MfRemap || map.mapFlag == MapFlag.MfRemap || mapFlag == MapFlag.MfHavemap || map.mapFlag == MapFlag.MfHavemap ? map.lhs().get().equals(lhs) && map.rhs().get().equals(rhs) : map.lhs().match(hLhs) && map.rhs().match(hRhs))) continue;
            return;
        }
        this.insert(lhs, rhs, mapFlag);
    }

    public void remove(int slotNum) {
        int slot = this.count - slotNum - 1;
        if (slot < 0 || slot > this.entry.slot) {
            return;
        }
        MapItem prev = null;
        MapItem target = this.entry;
        while (target.slot > slot) {
            --target.slot;
            prev = target;
            target = target.chain;
        }
        if (prev != null) {
            prev.chain = target.chain;
        } else {
            this.entry = target.chain;
        }
        --this.count;
        this.trees[MapTableT.LHS.dir].clear();
        this.trees[MapTableT.RHS.dir].clear();
    }

    void validate(String lhs, String rhs) throws Exception {
        MapHalf l = new MapHalf();
        MapHalf r = new MapHalf();
        l.set(lhs);
        r.set(rhs);
        l.validate(r);
    }

    void validHalf(MapTableT dir) throws Exception {
        for (MapItem map = this.entry; map != null; map = map.next()) {
            map.ths(dir).validate(null);
        }
    }

    long getHash() {
        long h = 0L;
        for (MapItem map = this.entry; map != null; map = map.next()) {
            int i;
            String c = map.lhs().get();
            for (i = 0; i < map.lhs().get().length(); ++i) {
                h = MapTable.CHARHASH(h, c.charAt(i));
            }
            c = map.rhs().get();
            for (i = 0; i < map.rhs().get().length(); ++i) {
                h = MapTable.CHARHASH(h, c.charAt(i));
            }
            h = MapTable.CHARHASH(h, map.flag().code);
        }
        return h;
    }

    public void dump(StringBuffer buf, String trace, int fmt) {
        String out = String.format("map %s: %d items, joinError %s, emptyReason %s\n", trace, this.count, this.joinError ? "true" : "false", this.emptyReason == null ? "NULL" : this.emptyReason);
        if (buf == null) {
            System.out.print(out);
        } else {
            buf.append(out);
        }
        if (fmt == 0) {
            for (MapItem map = this.entry; map != null; map = map.next()) {
                out = String.format("\t%c %s -> %s\n", Character.valueOf(" -+$@&    123456789".charAt(map.flag().code)), map.lhs().get(), map.rhs().get());
                if (buf == null) {
                    System.out.print(out);
                    continue;
                }
                buf.append(out);
            }
        } else {
            for (int i = this.count - 1; i >= 0; --i) {
                out = String.format("\t%c %s . %s\n", Character.valueOf(" -+$@&    123456789".charAt(this.getFlag((MapItem)this.get((int)i)).code)), this.get(i).lhs().get(), this.get(i).rhs().get());
                if (buf == null) {
                    System.out.print(out);
                    continue;
                }
                buf.append(out);
            }
        }
    }

    public void dumpTree(StringBuffer buf, MapTableT dir, String trace) {
        if (this.trees[dir.dir].tree == null) {
            this.makeTree(dir);
        }
        if (this.trees[dir.dir].tree != null) {
            this.trees[dir.dir].tree.dump(buf, dir, trace);
        }
    }

    public boolean isSingle() {
        return this.count >= 1 && !this.entry.lhs().isWild() && !this.entry.rhs().isWild();
    }

    public ArrayList<MapItem> sort(MapTableT direction) {
        return this.sort(direction, false);
    }

    public ArrayList<MapItem> sort(MapTableT direction, boolean streamFlag) {
        if (!streamFlag && this.trees[direction.dir].sort != null) {
            return this.trees[direction.dir].sort;
        }
        ArrayList<MapItem> vec = new ArrayList<MapItem>();
        for (MapItem map = this.entry; map != null; map = map.next()) {
            vec.add(map);
        }
        if (streamFlag) {
            if (direction == MapTableT.LHS) {
                Collections.sort(vec, new compareStreamLHS());
            } else {
                Collections.sort(vec, new compareStreamRHS());
            }
            return vec;
        }
        if (direction == MapTableT.LHS) {
            Collections.sort(vec, new compareLHS());
        } else {
            Collections.sort(vec, new compareRHS());
        }
        this.trees[direction.dir].sort = vec;
        return this.trees[direction.dir].sort;
    }

    void makeTree(MapTableT dir) {
        AtomicInteger depth = new AtomicInteger(0);
        ArrayList<MapItem> vec = this.sort(dir);
        this.trees[dir.dir].tree = MapItem.tree(vec, 0, vec.size(), dir, null, depth);
        this.trees[dir.dir].depth = depth.get();
    }

    boolean better(MapTable other, MapTableT dir) {
        if (this.trees[dir.dir].tree == null) {
            this.makeTree(dir);
        }
        if (other.trees[dir.dir].tree == null) {
            other.makeTree(dir);
        }
        return this.trees[dir.dir].depth < other.trees[dir.dir].depth;
    }

    public MapStrings strings(MapTableT direction) {
        ArrayList<MapItem> vec = this.sort(direction);
        MapStrings strings = new MapStrings();
        MapHalf oMapHalf = null;
        boolean oHasSubDirs = false;
        for (int i = 0; i < this.count; ++i) {
            if (((MapItem)vec.get(i)).flag() == MapFlag.MfUnmap) continue;
            MapHalf mapHalf = ((MapItem)vec.get(i)).ths(direction);
            if (oMapHalf != null) {
                int match = oMapHalf.getCommonLen(mapHalf);
                if (match == oMapHalf.getFixedLen()) {
                    oHasSubDirs |= mapHalf.hasSubDirs(match);
                    continue;
                }
                if (mapHalf.getFixedLen() > match) {
                    strings.add(oMapHalf, oHasSubDirs);
                }
            }
            oMapHalf = mapHalf;
            oHasSubDirs = mapHalf.hasSubDirs(mapHalf.getFixedLen());
        }
        if (oMapHalf != null) {
            strings.add(oMapHalf, oHasSubDirs);
        }
        return strings;
    }

    MapItem check(MapTableT dir, String from) {
        if (this.trees[dir.dir].tree == null) {
            this.makeTree(dir);
        }
        return this.trees[dir.dir].tree != null ? this.trees[dir.dir].tree.match(dir, from, null) : null;
    }

    public MapWrap translate(MapTableT dir, String from) {
        MapItem map;
        MapWrap out = null;
        if (this.trees[dir.dir].tree == null) {
            this.makeTree(dir);
        }
        MapItem mapItem = map = this.trees[dir.dir].tree != null ? this.trees[dir.dir].tree.match(dir, from, null) : null;
        if (map != null) {
            out = new MapWrap();
            out.setMap(map);
            MapParams params = new MapParams();
            map.ths(dir).match2(from, params);
            out.setTo(map.ohs(dir).expand(from, params));
        }
        return out;
    }

    public MapItemArray explode(MapTableT dir, String from) {
        MapItem map;
        MapItemArray maps = new MapItemArray();
        if (this.trees[dir.dir].tree == null) {
            this.makeTree(dir);
        }
        MapItemArray ands = new MapItemArray();
        if (this.trees[dir.dir].tree != null) {
            this.trees[dir.dir].tree.match(dir, from, ands);
        }
        int i = 0;
        int nonand = 0;
        while ((map = ands.getItem(i++)) != null) {
            MapParams params = new MapParams();
            if (!map.ths(dir).match2(from, params) || map.flag() == MapFlag.MfUnmap) {
                return maps;
            }
            if (map.flag() != MapFlag.MfAndmap && nonand != 0) continue;
            ++nonand;
            String to = map.ohs(dir).expand(from, params);
            maps.put(map, to);
        }
        return maps;
    }

    boolean match(MapHalf l, String rhs) {
        MapParams params = new MapParams();
        return l.match(rhs, params);
    }

    boolean match(String lhs, String rhs) {
        MapHalf l = new MapHalf(lhs);
        MapParams params = new MapParams();
        return l.match(rhs, params);
    }

    boolean validDepotMap(String map) {
        MapHalf l = new MapHalf(map);
        return l.wildcardCount() == 1 && l.hasEndSlashEllipses();
    }

    public MapItem get(int n) {
        for (MapItem map = this.entry; map != null; map = map.next()) {
            if (n == 0) {
                return map;
            }
            --n;
        }
        return null;
    }

    public int getSlot(MapItem m) {
        return this.count - m.slot() - 1;
    }

    public MapFlag getFlag(MapItem m) {
        return m.flag();
    }

    public MapItem getNext(MapItem m) {
        return m.next();
    }

    public String getStr(MapItem m, MapTableT dir) {
        return m.ths(dir).get();
    }

    public String translate(MapItem m, MapTableT dir, String from) {
        MapParams params = new MapParams();
        if (m.flag() == MapFlag.MfUnmap) {
            return null;
        }
        if (!m.ths(dir).match(from, params)) {
            return null;
        }
        return m.ohs(dir).expand(from, params);
    }

    public MapTable stripMap(MapFlag mapFlag) {
        MapTable m0 = new MapTable();
        for (MapItem map = this.entry; map != null; map = map.next()) {
            if (map.flag() == mapFlag) continue;
            m0.insert(map.lhs().get(), map.rhs().get(), map.flag());
        }
        m0.reverse();
        return m0;
    }

    public MapTable swap(MapTable table) {
        MapTable m0 = new MapTable();
        for (MapItem map = this.entry; map != null; map = map.next()) {
            m0.insert(map.rhs().get(), map.lhs().get(), map.flag());
        }
        m0.reverse();
        return m0;
    }

    public int countByFlag(MapFlag mapFlag) {
        int result = 0;
        for (MapItem map = this.entry; map != null; map = map.next()) {
            result += map.flag() == mapFlag ? 1 : 0;
        }
        return result;
    }

    public void insertByPattern(String lhs, String rhs, MapFlag mapFlag) {
        int slashes;
        int l = lhs.length() - 1;
        int r = rhs.length() - 1;
        int ls = 0;
        int rs = 0;
        for (slashes = 0; slashes < 3 && ls < l; slashes += lhs.charAt(ls) == '/' ? 1 : 0, ++ls) {
        }
        for (slashes = 0; slashes < 3 && rs < r; slashes += rhs.charAt(rs) == '/' ? 1 : 0, ++rs) {
        }
        slashes = 0;
        while (l > ls && r > rs && lhs.charAt(l - 1) == rhs.charAt(r - 1)) {
            --r;
            slashes += lhs.charAt(--l) == '/' ? 1 : 0;
        }
        if (l < lhs.length() - 1 && lhs.charAt(l) == '/') {
            ++l;
            ++r;
            --slashes;
        }
        if ((l < lhs.length() - 1 && lhs.charAt(l - 1) == '.' || r < rhs.length() - 1 && rhs.charAt(r - 1) == '.') && slashes != 0) {
            ++l;
            ++r;
        }
        if (slashes != 0 && l < lhs.length() - 4) {
            String left = "";
            left = left + lhs.substring(0, l);
            left = left + "...";
            String right = "";
            right = right + rhs.substring(0, r);
            right = right + "...";
            this.insertNoDups(left, right, mapFlag);
        } else if (slashes == 0 && l < lhs.length() - 2) {
            String left = "";
            left = left + lhs.substring(0, l);
            left = left + "*";
            String right = "";
            right = right + rhs.substring(0, r);
            right = right + "*";
            this.insertNoDups(left, right, mapFlag);
        } else {
            this.insertNoDups(lhs, rhs, mapFlag);
        }
    }

    public void disambiguate() {
        MapDisambiguate j = new MapDisambiguate();
        j.map = this.entry;
        while (j.map != null) {
            switch (j.map.flag()) {
                case MfUnmap: {
                    break;
                }
                default: {
                    j.map2 = this.entry;
                    while (j.map2 != j.map) {
                        switch (j.map2.flag()) {
                            case MfRemap: 
                            case MfHavemap: {
                                break;
                            }
                            case MfAndmap: {
                                j.map2.lhs().join(j.map2.rhs(), j);
                                j.map2.rhs().join(j.map.rhs(), j);
                                break;
                            }
                            default: {
                                j.map2.lhs().join(j.map.lhs(), j);
                                j.map2.rhs().join(j.map.rhs(), j);
                            }
                        }
                        j.map2 = j.map2.next();
                    }
                    j.m0.insert(j.map.lhs().get(), j.map.rhs().get(), j.map.flag());
                }
            }
            j.map = j.map.next();
        }
        j.m0.reverse();
        this.clear();
        this.insert(j.m0, true, false);
    }

    public boolean joinCheck(MapTableT dir, String lhs) {
        MapTable c = new MapTable();
        c.insert(lhs, null, MapFlag.MfMap);
        MapTable j = c.join(MapTableT.LHS, this, dir);
        return !j.isEmpty();
    }

    public boolean joinCheck(MapTableT dir, MapTable c, MapTableT dir2) {
        MapTable j = c.join(dir2, this, dir);
        return !j.isEmpty();
    }

    public void joinOptimizer(MapTableT dir2) {
        if (this.trees[dir2.dir].tree == null) {
            this.makeTree(dir2);
        }
    }

    public void join(MapTable m1, MapTableT dir1, MapTable m2, MapTableT dir2, MapJoiner j, String reason) {
        if (m1.caseMode == 0 || m1.caseMode == 1) {
            this.setCaseSensitivity(m1.caseMode);
        }
        int max1 = 100000;
        int max2 = 100000;
        int m = 100000 + m1.count + m2.count;
        if (m > 100000) {
            m = 100000;
        }
        if (m2.trees[dir2.dir].tree == null) {
            j.map = m1.entry;
            while (j.map != null && this.count < m) {
                j.map2 = m2.entry;
                while (j.map2 != null) {
                    j.map.ths(dir1).join(j.map2.ths(dir2), j);
                    if (j.badJoin) {
                        this.joinError = true;
                        this.emptyReason = "TooWild2";
                        this.joinError = true;
                        this.emptyReason = "TooWild";
                        return;
                    }
                    j.map2 = j.map2.next();
                }
                j.map = j.map.next();
            }
        } else {
            MapPairArray pairArray = new MapPairArray(dir1, dir2);
            if (m2.trees[dir2.dir].tree != null) {
                for (MapItem i1 = m1.entry; i1 != null && this.count < m; i1 = i1.next()) {
                    pairArray.clear();
                    pairArray.match(i1, m2.trees[dir2.dir].tree);
                    pairArray.sort();
                    for (int i = 0; i < pairArray.size(); ++i) {
                        MapPair jp = (MapPair)pairArray.get(i);
                        j.map = jp.item1;
                        j.map2 = jp.tree2;
                        jp.h1.join(jp.h2, j);
                    }
                }
            }
        }
        this.reverse();
        if (this.count >= m) {
            this.emptyReason = "TooWild";
            this.clear();
        } else if (m1.isEmpty() && m1.emptyReason != null) {
            this.emptyReason = m1.emptyReason;
        } else if (m2.isEmpty() && m2.emptyReason != null) {
            this.emptyReason = m2.emptyReason;
        } else if (!this.hasMaps && reason != null) {
            this.emptyReason = reason;
        }
    }

    public MapTable join(MapTableT dir1, MapTable m2, MapTableT dir2) {
        return this.join(dir1, m2, dir2, null);
    }

    public MapTable join(MapTableT dir1, MapTable m2, MapTableT dir2, String reason) {
        MapJoiner j = new MapJoiner();
        j.m0.join(this, dir1, m2, dir2, j, reason);
        return j.m0;
    }

    public MapTable join2(MapTableT dir1, MapTable m2, MapTableT dir2) {
        return this.join2(dir1, m2, dir2, null);
    }

    MapTable join2(MapTableT dir1, MapTable m2, MapTableT dir2, String reason) {
        MapJoiner2 j = new MapJoiner2(dir1, dir2);
        j.m0.join(this, dir1, m2, dir2, j, reason);
        return j.m0;
    }

    public class compareStreamRHS
    implements Comparator<MapItem> {
        @Override
        public int compare(MapItem e1, MapItem e2) {
            char c2;
            String str1 = e1.rhs().get();
            String str2 = e2.rhs().get();
            int i = 0;
            int j = 0;
            char c1 = str1.charAt(0);
            if (c1 == '%' || Character.isDigit(c1)) {
                while (str1.charAt(i) != '\u0000' && (c1 = str1.charAt(i)) != '/') {
                    ++i;
                }
            }
            if ((c2 = str2.charAt(0)) == '%' || Character.isDigit(c2)) {
                while (str2.charAt(j) != '\u0000' && (c2 = str2.charAt(j)) != '/') {
                    ++j;
                }
            }
            while ((c1 = str1.charAt(i)) != '\u0000' && (c2 = str2.charAt(j)) != '\u0000') {
                if (c1 != c2) {
                    if (str1.substring(i).startsWith("...")) {
                        return -1;
                    }
                    if (str2.substring(j).startsWith("...")) {
                        return 1;
                    }
                    if (c1 == '*') {
                        return -1;
                    }
                    if (c2 == '*') {
                        return 1;
                    }
                    if (c1 == '/') {
                        return 1;
                    }
                    if (c2 == '/') {
                        return -1;
                    }
                    return c1 - c2;
                }
                ++i;
                ++j;
            }
            return e1.slot() - e2.slot();
        }
    }

    public class compareStreamLHS
    implements Comparator<MapItem> {
        @Override
        public int compare(MapItem e1, MapItem e2) {
            char c2;
            String str1 = e1.lhs().get();
            String str2 = e2.lhs().get();
            int i = 0;
            int j = 0;
            char c1 = str1.charAt(0);
            if (c1 == '%' || Character.isDigit(c1)) {
                while (str1.charAt(i) != '\u0000' && (c1 = str1.charAt(i)) != '/') {
                    ++i;
                }
            }
            if ((c2 = str2.charAt(0)) == '%' || Character.isDigit(c2)) {
                while (str2.charAt(j) != '\u0000' && (c2 = str2.charAt(j)) != '/') {
                    ++j;
                }
            }
            while (i < str1.length() && (c1 = str1.charAt(i)) != '\u0000' && j < str2.length() && (c2 = str2.charAt(j)) != '\u0000') {
                if (c1 != c2) {
                    if (str1.substring(i).startsWith("...")) {
                        return -1;
                    }
                    if (str2.substring(j).startsWith("...")) {
                        return 1;
                    }
                    if (c1 == '*') {
                        return -1;
                    }
                    if (c2 == '*') {
                        return 1;
                    }
                    if (c1 == '/') {
                        return 1;
                    }
                    if (c2 == '/') {
                        return -1;
                    }
                    return c1 - c2;
                }
                ++i;
                ++j;
            }
            return e1.slot() - e2.slot();
        }
    }

    public class compareRHS
    implements Comparator<MapItem> {
        @Override
        public int compare(MapItem e1, MapItem e2) {
            int r = e1.rhs().compare(e2.rhs());
            return r != 0 ? r : e2.slot() - e1.slot();
        }
    }

    public class compareLHS
    implements Comparator<MapItem> {
        @Override
        public int compare(MapItem e1, MapItem e2) {
            int r = e1.lhs().compare(e2.lhs());
            return r != 0 ? r : e2.slot() - e1.slot();
        }
    }
}

