/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.FileDiffUtils;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.DescribeOptions;
import com.perforce.p4java.option.server.GetChangelistDiffsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IDescribeDelegator;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class DescribeDelegator
extends BaseDelegator
implements IDescribeDelegator {
    public DescribeDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public InputStream getChangelistDiffs(int changelistId, GetChangelistDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DESCRIBE, Parameters.processParameters((Options)opts, null, String.valueOf(changelistId), (IServer)this.server));
    }

    @Override
    public InputStream getChangelistDiffsStream(int id, DescribeOptions options) throws ConnectionException, RequestException, AccessException {
        DiffType diffType = null;
        boolean shelvedDiffs = false;
        if (ObjectUtils.nonNull(options)) {
            diffType = options.getType();
            shelvedDiffs = options.isOutputShelvedDiffs();
        }
        P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(shelvedDiffs && this.server.getServerVersion() >= 20092, "Shelved file diffs are not supported by this version of the Perforce server", new Object[0]);
        try {
            GetChangelistDiffsOptions opts = new GetChangelistDiffsOptions();
            opts.setOutputShelvedDiffs(shelvedDiffs);
            FileDiffUtils.setFileDiffsOptionsByDiffType(diffType, opts);
            return this.getChangelistDiffs(id, opts);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> getShelvedFiles(int changelistId) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", "-S", String.valueOf(changelistId)}, null);
        return ResultMapParser.parseCommandResultMapAsFileSpecs(changelistId, this.server, resultMaps);
    }

    @Override
    public List<IFileSpec> getShelvedFiles(int changelistId, int max) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", "-m" + max, "-S", String.valueOf(changelistId)}, null);
        return ResultMapParser.parseCommandResultMapAsFileSpecs(changelistId, this.server, resultMaps);
    }

    public InputStream getChangelistDiffs(int id, DiffType diffType) throws ConnectionException, RequestException, AccessException {
        return this.getChangelistDiffsStream(id, new DescribeOptions(diffType));
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id) throws ConnectionException, RequestException, AccessException {
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", String.valueOf(id)}, null);
            return ResultMapParser.parseCommandResultMapAsFileSpecs(id, this.server, resultMaps);
        }
        catch (P4JavaException p4je) {
            throw new RequestException(p4je);
        }
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id, int max) throws ConnectionException, RequestException, AccessException {
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", "-m" + max, String.valueOf(id)}, null);
            return ResultMapParser.parseCommandResultMapAsFileSpecs(id, this.server, resultMaps);
        }
        catch (P4JavaException p4je) {
            throw new RequestException(p4je);
        }
    }

    public List<IFileSpec> getCommitFiles(String repo, String commit) throws ConnectionException, RequestException, AccessException {
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", "-n", repo, commit}, null);
            return ResultMapParser.parseGraphCommandResultMapAsFileSpecs(this.server, resultMaps);
        }
        catch (P4JavaException p4je) {
            throw new RequestException(p4je);
        }
    }
}

