/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IObliterateResult;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.generic.core.file.ObliterateResult;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.ObliterateFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IObliterateDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ObliterateDelegator
extends BaseDelegator
implements IObliterateDelegator {
    public ObliterateDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IObliterateResult> obliterateFiles(@Nonnull List<IFileSpec> fileSpecs, ObliterateFilesOptions opts) throws P4JavaException {
        Validate.notNull(fileSpecs);
        ArrayList<IObliterateResult> obliterateResults = new ArrayList<IObliterateResult>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.OBLITERATE, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (ObjectUtils.nonNull(resultMaps)) {
            boolean reportOnly = false;
            if (resultMaps.size() > 1) {
                Map<String, Object> lastResultMap = resultMaps.get(resultMaps.size() - 1);
                reportOnly = ObjectUtils.nonNull(lastResultMap) && lastResultMap.containsKey("reportOnly");
            }
            try {
                ArrayList<IFileSpec> fsList = new ArrayList<IFileSpec>();
                for (Map<String, Object> map : resultMaps) {
                    FileSpec fs;
                    String errStr = ResultMapParser.handleFileErrorStr(map);
                    if (StringUtils.isBlank((CharSequence)errStr)) {
                        if (map.containsKey("purgeFile")) {
                            fs = this.createPurgeFileSpecFromMap(map);
                            fsList.add(fs);
                            continue;
                        }
                        if (!map.containsKey("revisionRecDeleted")) continue;
                        IObliterateResult result = this.createObliterateResultFromMapIfRevisionRecordsDeleted(map, fsList, reportOnly);
                        obliterateResults.add(result);
                        fsList = new ArrayList();
                        continue;
                    }
                    fs = this.createInfoOrErrorFileSpecFromMap(map, errStr, new Function<Map<String, Object>, Boolean>(){

                        @Override
                        public Boolean apply(Map<String, Object> map) {
                            return ResultMapParser.isInfoMessage(map);
                        }
                    });
                    fsList.add(fs);
                    ObliterateResult result = new ObliterateResult(fsList, 0, 0, 0, 0, 0, 0, reportOnly);
                    obliterateResults.add(result);
                }
            }
            catch (Exception exc) {
                Log.error("Unexpected exception in ObliterateFileSpec constructor %s", exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return obliterateResults;
    }

    private FileSpec createPurgeFileSpecFromMap(Map<String, Object> map) {
        FileSpec fs = new FileSpec();
        fs.setDepotPath(P4ResultMapUtils.parseString(map, "purgeFile"));
        fs.setEndRevision(P4ResultMapUtils.parseInt(map, "purgeRev"));
        return fs;
    }

    private FileSpec createInfoOrErrorFileSpecFromMap(Map<String, Object> map, String errStr, Function<Map<String, Object>, Boolean> infoMessageDetector) throws RequestException {
        FileSpec fs = new FileSpec(FileSpecOpStatus.ERROR, errStr);
        if (infoMessageDetector.apply(map).booleanValue()) {
            fs = new FileSpec(FileSpecOpStatus.INFO, errStr);
        }
        return fs;
    }

    private IObliterateResult createObliterateResultFromMapIfRevisionRecordsDeleted(@Nonnull Map<String, Object> map, @Nonnull List<IFileSpec> fsList, boolean reportOnly) {
        return new ObliterateResult(fsList, P4ResultMapUtils.parseInt(map, "integrationRecAdded"), P4ResultMapUtils.parseInt(map, "labelRecDeleted"), P4ResultMapUtils.parseInt(map, "clientRecDeleted"), P4ResultMapUtils.parseInt(map, "integrationRecDeleted"), P4ResultMapUtils.parseInt(map, "workingRecDeleted"), P4ResultMapUtils.parseInt(map, "revisionRecDeleted"), reportOnly);
    }
}

