/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetUserGroupsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IGroupsDelegator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GroupsDelegator
extends BaseDelegator
implements IGroupsDelegator {
    public GroupsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, GetUserGroupsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUPS, Parameters.processParameters((Options)opts, null, userOrGroupName, (IServer)this.server), null);
        HashMap<String, UserGroup> userGroupMap = new HashMap<String, UserGroup>();
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                UserGroup ugImpl;
                ResultMapParser.handleErrorStr(map);
                String groupName = P4ResultMapUtils.parseString(map, "group");
                if (userGroupMap.containsKey(groupName)) {
                    ugImpl = (UserGroup)userGroupMap.get(groupName);
                } else {
                    ugImpl = new UserGroup();
                    ugImpl.setName(groupName);
                    userGroupMap.put(groupName, ugImpl);
                }
                try {
                    String userName = P4ResultMapUtils.parseString(map, "user");
                    String maxScanRows = P4ResultMapUtils.parseString(map, "maxScanRows");
                    String maxLockTime = P4ResultMapUtils.parseString(map, "maxLockTime");
                    String timeout = P4ResultMapUtils.parseString(map, "timeout");
                    String passwordTimeout = P4ResultMapUtils.parseString(map, "passTimeout");
                    String maxResults = P4ResultMapUtils.parseString(map, "maxResults");
                    String isOwner = P4ResultMapUtils.parseString(map, "isOwner");
                    String isSubGroup = P4ResultMapUtils.parseString(map, "isSubGroup");
                    if ("1".equals(isOwner)) {
                        ugImpl.addOwner(userName);
                    }
                    if ("1".equals(isSubGroup)) {
                        ugImpl.addSubgroup(userName);
                    } else {
                        ugImpl.addUser(userName);
                    }
                    if (StringUtils.isNotBlank((CharSequence)maxScanRows)) {
                        ugImpl.setMaxScanRows(Integer.parseInt(maxScanRows));
                    }
                    if (StringUtils.isNotBlank((CharSequence)maxLockTime)) {
                        ugImpl.setMaxLockTime(Integer.parseInt(maxLockTime));
                    }
                    if (StringUtils.isNotBlank((CharSequence)timeout)) {
                        ugImpl.setTimeout(Integer.parseInt(timeout));
                    }
                    if (StringUtils.isNotBlank((CharSequence)maxResults)) {
                        ugImpl.setMaxResults(Integer.parseInt(maxResults));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)passwordTimeout)) continue;
                    ugImpl.setPasswordTimeout(Integer.parseInt(passwordTimeout));
                }
                catch (Throwable thr) {
                    Log.warn("Unexpected exception in ServerImpl.getUserGroups: %s", thr.getMessage());
                    Log.exception(thr);
                }
            }
        }
        return new ArrayList<IUserGroup>(userGroupMap.values());
    }

    public List<IUserGroup> getUserGroups(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUserGroups(userOrGroupName, new GetUserGroupsOptions().setIndirect(indirect).setDisplayValues(displayValues).setMaxGroups(maxGroups));
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

