/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;

public class ClientIgnoreChecker {
    private String clientRoot = null;
    private String ignoreFileName = null;
    private Charset charset = null;

    public ClientIgnoreChecker(String clientRoot, String ignoreFileName, Charset charset) {
        if (clientRoot == null) {
            throw new IllegalArgumentException("Null client root directory passed to IgnoreFileChecker constructor.");
        }
        if (ignoreFileName == null) {
            throw new IllegalArgumentException("Null ignore file passed to IgnoreFileChecker constructor.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Null charset passed to IgnoreFileChecker constructor.");
        }
        this.clientRoot = clientRoot;
        this.ignoreFileName = ignoreFileName;
        this.charset = charset;
    }

    public boolean match(File file) throws FileNotFoundException, IOException {
        return file != null && this.checkIgnoreFiles(file);
    }

    private boolean checkIgnoreFiles(File file) throws IOException {
        if (file != null) {
            Negate negate = new Negate();
            File clientRootDir = new File(this.clientRoot);
            File fileDir = file;
            do {
                File ignoreFile;
                if ((fileDir = fileDir.getParentFile()) == null || !(ignoreFile = new File(fileDir, this.ignoreFileName)).exists() || !this.checkIgnoreFile(ignoreFile, fileDir, file, negate)) continue;
                return !negate.isMatch();
            } while (fileDir != null && !fileDir.getAbsoluteFile().equals(clientRootDir));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIgnoreFile(File ignoreFile, File currentDir, File file, Negate negate) throws IOException {
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ignoreFile), this.charset));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            Collections.reverse(list);
            for (String entry : list) {
                if (!this.checkIgnorePattern(entry, currentDir, file, negate)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean checkIgnorePattern(String pattern, File currentDir, File file, Negate negate) {
        boolean wildcard = false;
        boolean negation = false;
        if (file == null) {
            return false;
        }
        if (pattern == null) {
            return false;
        }
        if ((pattern = pattern.trim()).startsWith("#")) {
            return false;
        }
        if (pattern.startsWith("!")) {
            negation = true;
            pattern = pattern.substring(1);
        }
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.contains("*")) {
            wildcard = true;
        }
        String path = file.getName();
        if (!wildcard) {
            path = file.getAbsolutePath().substring(currentDir.getAbsolutePath().length());
            path = path + File.separator;
            pattern = "*" + File.separator + pattern;
            pattern = pattern + File.separator + "*";
        }
        if (path.matches(pattern = pattern.replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*"))) {
            if (negation) {
                negate.setMatch(true);
            }
            return true;
        }
        return false;
    }

    private class Negate {
        private boolean match = false;

        private Negate() {
        }

        public boolean isMatch() {
            return this.match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }
    }
}

