/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.User;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.UpdateUserOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IUserDelegator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class UserDelegator
extends BaseDelegator
implements IUserDelegator {
    public UserDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String createUser(@Nonnull IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)user);
        return this.updateUser(user, force);
    }

    @Override
    public String createUser(@Nonnull IUser user, UpdateUserOptions opts) throws P4JavaException {
        return this.updateUser(user, opts);
    }

    @Override
    public String updateUser(@Nonnull IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUser(user, new UpdateUserOptions(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String updateUser(@Nonnull IUser user, UpdateUserOptions opts) throws P4JavaException {
        Validate.notNull((Object)user);
        Validate.notBlank((CharSequence)user.getLoginName());
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USER, Parameters.processParameters((Options)opts, null, "-i", (IServer)this.server), InputMapper.map(user));
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    @Override
    public String deleteUser(String userName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUser(userName, new UpdateUserOptions(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteUser(String userName, UpdateUserOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)userName, (String)"User name should not null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USER, Parameters.processParameters((Options)opts, null, new String[]{"-d", userName}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public IUser getUser(String userName) throws ConnectionException, RequestException, AccessException {
        List<Map<String, Object>> resultMaps;
        String[] args = new String[]{"-o"};
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            args = new String[]{"-o", userName};
        }
        if (ObjectUtils.nonNull(resultMaps = this.execMapCmdList(CmdSpec.USER, args, null))) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                if (ResultMapParser.isInfoMessage(map) || !ResultMapParser.isExistClientOrLabelOrUser(map)) continue;
                return new User(map, this.server);
            }
        }
        return null;
    }
}

