/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.StreamSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IStreamsDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StreamsDelegator
extends BaseDelegator
implements IStreamsDelegator {
    public StreamsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IStreamSummary> getStreams(List<String> streamPaths, GetStreamsOptions opts) throws P4JavaException {
        String[] args = new String[]{};
        if (ObjectUtils.nonNull(streamPaths)) {
            args = streamPaths.toArray(new String[streamPaths.size()]);
        }
        ArrayList<IStreamSummary> streamList = new ArrayList<IStreamSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAMS, Parameters.processParameters((Options)opts, null, args, (IServer)this.server), null);
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> streamMap : resultMaps) {
                String errStr = ResultMapParser.handleFileErrorStr(streamMap);
                if (StringUtils.isNotBlank((CharSequence)errStr)) {
                    Log.error(errStr, new Object[0]);
                    continue;
                }
                streamList.add(new StreamSummary(streamMap, true));
            }
        }
        return streamList;
    }
}

