/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.io;

import com.perforce.p4java.common.quantity.Amount;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class PdfFileDetector {
    private static final byte[] PDF_HEAD_MAGIC_NUMBER = new byte[]{37, 80, 68, 70, 45};
    private static final byte[] PDF_MAX_TAIL_MAGIC_NUMBER = new byte[]{37, 37, 69, 79, 70, 32, 13, 10};
    private static final byte[] PDF_EOF_ONLY_TAIL_MAGIC_NUMBER = new byte[]{37, 37, 69, 79, 70};

    private PdfFileDetector() {
    }

    public static boolean isPdfFile(@Nonnull File file) throws IOException {
        return PdfFileDetector.isPdfHeadMagicNumberPresent(file) && PdfFileDetector.isPdfTailMagicNumberPresent(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPdfHeadMagicNumberPresent(@Nonnull File file) throws IOException {
        byte[] buffer = new byte[Amount.DEFAULT_BUFFER_SIZE];
        boolean isPresent = false;
        try (FileInputStream inputStream = new FileInputStream(file);){
            int read = inputStream.read(buffer);
            isPresent = read >= PDF_HEAD_MAGIC_NUMBER.length && PdfFileDetector.isPdfHeadMagicNumberFound(buffer);
        }
        return isPresent;
    }

    private static boolean isPdfTailMagicNumberPresent(@Nonnull File file) throws IOException {
        int max = PDF_MAX_TAIL_MAGIC_NUMBER.length;
        byte[] tailNBytes = PdfFileDetector.readTailNBytes(file, max);
        return PdfFileDetector.isContainsDoublePercentEOFTailMagicNumber(tailNBytes);
    }

    private static byte[] readTailNBytes(@Nonnull File file, int n) throws IOException {
        byte[] buffer = new byte[n];
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            randomAccessFile.seek(file.length() - (long)n);
            int read = randomAccessFile.read(buffer, 0, n);
            if (read > 0) {
                byte[] byArray = Arrays.copyOf(buffer, read);
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
    }

    private static boolean isPdfHeadMagicNumberFound(byte[] sourceArray) {
        if (sourceArray.length < PDF_HEAD_MAGIC_NUMBER.length) {
            return false;
        }
        byte[] headBytes = Arrays.copyOf(sourceArray, PDF_HEAD_MAGIC_NUMBER.length);
        return Arrays.equals(headBytes, PDF_HEAD_MAGIC_NUMBER);
    }

    private static boolean isContainsDoublePercentEOFTailMagicNumber(byte[] sourceArray) {
        int length = PDF_EOF_ONLY_TAIL_MAGIC_NUMBER.length;
        if (sourceArray.length >= length) {
            int lastOffset = sourceArray.length - length;
            for (int i = 0; i <= lastOffset; ++i) {
                byte[] potentialMatchArray;
                byte firstByteOfTailMagicNumber = PDF_EOF_ONLY_TAIL_MAGIC_NUMBER[0];
                if (sourceArray[i] != firstByteOfTailMagicNumber || !Arrays.equals(potentialMatchArray = Arrays.copyOfRange(sourceArray, i, i + length), PDF_EOF_ONLY_TAIL_MAGIC_NUMBER)) continue;
                return true;
            }
        }
        return false;
    }
}

