/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.List;

public class GraphRevListOptions
extends Options {
    public static final String REVLIST_COMMAND_PART = "rev-list";
    public static final String OPTIONS_SPECS = "s:n i:m:gtz";
    private String depot;
    private int maxValue;
    private String[] commitValue;

    public GraphRevListOptions() {
    }

    @Override
    public List<String> processOptions(IServer server) throws OptionsException {
        this.optionList = this.processFields(OPTIONS_SPECS, this.depot, this.maxValue);
        if (this.commitValue != null && this.commitValue.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String commitValueItem : this.commitValue) {
                this.optionList.add(commitValueItem);
            }
        }
        this.optionList.add(0, REVLIST_COMMAND_PART);
        return this.optionList;
    }

    public GraphRevListOptions(String depot, int maxValue, String ... commitValue) {
        this.depot = depot;
        this.maxValue = maxValue;
        this.commitValue = commitValue;
    }

    public GraphRevListOptions withDepot(String depot) {
        this.depot = depot;
        return this;
    }

    public GraphRevListOptions withMaxValue(int maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public GraphRevListOptions withCommitValue(String ... commitValue) {
        this.commitValue = commitValue;
        return this;
    }
}

