/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMerge;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientProgressReport;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientSendFile;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientSystemFileCommands;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientUserInteraction;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.callback.IProgressCallback;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ClientFunctionDispatcher {
    public static final String TRACE_PREFIX = "ClientFunctionDispatcher";
    private RpcPacketDispatcher mainDispatcher = null;
    private ClientUserInteraction userInteractor = null;
    private ClientSystemFileCommands fileCommands = null;
    private ClientSendFile fileSender = null;
    private ClientMerge clientMerger = null;
    private ClientProgressReport progressReport = null;
    private Properties props = null;
    protected RpcServer server = null;

    public ClientFunctionDispatcher(RpcPacketDispatcher mainDispatcher, Properties props, RpcServer server) {
        if (mainDispatcher == null) {
            throw new NullPointerError("Null main dispatcher passed to ClientFunctionDispatcher constructor");
        }
        this.props = props;
        this.server = server;
        this.mainDispatcher = mainDispatcher;
        this.userInteractor = new ClientUserInteraction(this.props, server);
        this.fileCommands = new ClientSystemFileCommands(this.props, server);
        this.fileSender = new ClientSendFile(this.props);
        this.clientMerger = new ClientMerge(this.props);
        this.progressReport = new ClientProgressReport(server);
    }

    public RpcPacketDispatcher.RpcPacketDispatcherResult dispatch(RpcPacketDispatcher.RpcPacketDispatcherMode dispatchMode, RpcFunctionSpec funcSpec, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        boolean keepGoing;
        if (funcSpec == null) {
            throw new NullPointerError("Null function spec passed to ClientFunctionDispatcher.dispatch()");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null command environment passed to ClientFunctionDispatcher.dispatch()");
        }
        RpcPacketDispatcher.RpcPacketDispatcherResult result = RpcPacketDispatcher.RpcPacketDispatcherResult.NONE;
        RpcConnection rpcConnection = cmdEnv.getRpcConnection();
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        IProgressCallback progressCallback = cmdEnv.getProgressCallback();
        boolean bl = keepGoing = !cmdEnv.isUserCanceled();
        if (progressCallback != null && keepGoing) {
            keepGoing = this.progressReport.report(progressCallback, cmdCallBackKey, funcSpec, cmdEnv, resultsMap);
        }
        if (!keepGoing) {
            cmdEnv.setUserCanceled(true);
        }
        switch (funcSpec) {
            case CLIENT_MESSAGE: {
                if (cmdEnv.getProtocolSpecs().isQuietMode()) {
                    result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                    break;
                }
            }
            case CLIENT_FSTATINFO: {
                if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.ANNOTATE.toString()) || cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.LOGTAIL.toString())) {
                    resultsMap.remove("func");
                    cmdEnv.handleResult(this.fileCommands.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer()));
                } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DIFF2.toString()) || cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DESCRIBE.toString()) || cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.PRINT.toString())) {
                    RpcOutputStream outStream;
                    String infoMsg = this.server.getErrorOrInfoStr(resultsMap);
                    if (infoMsg != null && (outStream = this.fileCommands.getTempOutputStream(cmdEnv)) != null) {
                        String charsetName = rpcConnection.getClientCharset() == null ? CharsetDefs.DEFAULT_NAME : rpcConnection.getClientCharset().name();
                        try {
                            infoMsg = infoMsg + CommandEnv.LINE_SEPARATOR;
                            if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DESCRIBE.toString())) {
                                outStream.write("... ".getBytes(charsetName));
                            }
                            outStream.write(infoMsg.getBytes(charsetName));
                        }
                        catch (IOException ioexc) {
                            Log.warn("Unexpected exception in client function dispatch: " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                    }
                    resultsMap.remove("func");
                    cmdEnv.handleResult(resultsMap);
                } else {
                    resultsMap.remove("func");
                    cmdEnv.handleResult(resultsMap);
                }
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case CLIENT_PROMPT: {
                result = this.userInteractor.clientPrompt(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SETPASSWORD: {
                result = this.userInteractor.clientSetPassword(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CRYPTO: {
                result = this.userInteractor.clientCrypto(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHMODFILE: {
                result = this.fileCommands.chmodFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENFILE: {
                result = this.fileCommands.openFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHECKFILE: {
                result = this.fileCommands.checkFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_RECONCILEEDIT: {
                result = this.fileCommands.reconcileEdit(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_RECONCILEADD: {
                result = this.fileCommands.reconcileAdd(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_RECONCILEFLUSH: {
                result = this.fileCommands.reconcileFlush(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_WRITEFILE: {
                result = this.fileCommands.writeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEFILE: {
                result = this.fileCommands.closeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_ACK: {
                result = this.userInteractor.clientAck(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_INPUTDATA: {
                result = this.userInteractor.clientInputData(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SENDFILE: {
                result = this.fileSender.sendFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_DELETEFILE: {
                result = this.fileCommands.deleteFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTBINARY: {
                result = this.fileCommands.writeBinary(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTERROR: {
                resultsMap.remove("func");
                String msg = new String((byte[])resultsMap.remove("data"));
                int code = 1073756161;
                resultsMap.put("code0", String.valueOf(code));
                resultsMap.put("fmt0", msg);
                cmdEnv.handleResult(resultsMap);
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.STOP_NORMAL;
                break;
            }
            case CLIENT_OUTPUTTEXT: {
                result = this.fileCommands.writeText(rpcConnection, cmdEnv, resultsMap);
                if (!cmdEnv.getProtocolSpecs().isEnableTracking()) break;
                cmdEnv.handleResult(this.fileCommands.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer()));
                break;
            }
            case CLIENT_OUTPUTDATA: 
            case CLIENT_OUTPUTINFO: {
                resultsMap = this.fileCommands.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer());
                RpcOutputStream dataOutStream = this.fileCommands.getTempOutputStream(cmdEnv);
                if (dataOutStream != null) {
                    try {
                        String dataString = (String)resultsMap.get("data");
                        if (dataString != null) {
                            dataOutStream.write(dataString.getBytes());
                        }
                    }
                    catch (IOException e) {
                        Log.exception(e);
                    }
                }
                cmdEnv.handleResult(resultsMap);
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case CLIENT_PROGRESS: {
                RpcOutputStream progressOutStream = this.fileCommands.getTempOutputStream(cmdEnv);
                if (progressOutStream != null) {
                    StringBuilder sb = new StringBuilder();
                    if (resultsMap.get("desc") != null) {
                        sb.append(resultsMap.get("desc"));
                    }
                    if (resultsMap.get("update") != null) {
                        sb.append(" ").append(resultsMap.get("update"));
                    }
                    if (resultsMap.get("done") != null) {
                        sb.append(" ").append("finishing");
                    }
                    if (sb.length() > 0) {
                        try {
                            sb.append(CommandEnv.LINE_SEPARATOR);
                            progressOutStream.write(sb.toString().getBytes());
                        }
                        catch (IOException ioexc) {
                            Log.warn("Unexpected exception in client function dispatch: " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                    }
                }
                cmdEnv.handleResult(resultsMap);
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case CLIENT_MOVEFILE: {
                result = this.fileCommands.moveFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENMERGE3: {
                result = this.clientMerger.clientOpenMerge3(rpcConnection, cmdEnv, resultsMap, false);
                break;
            }
            case CLIENT_OPENMERGE2: {
                result = this.clientMerger.clientOpenMerge3(rpcConnection, cmdEnv, resultsMap, true);
                break;
            }
            case CLIENT_WRITEMERGE: {
                result = this.clientMerger.clientWriteMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEMERGE: {
                result = this.clientMerger.clientCloseMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SSO: {
                result = this.userInteractor.clientSingleSignon(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            default: {
                Log.error("Unimplemented function spec in ClientFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'", new Object[0]);
                throw new P4JavaError("Unimplemented function spec in ClientFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'");
            }
        }
        return result;
    }
}

