/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.server.AbstractAuthHelper;
import com.perforce.p4java.server.Fingerprint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FingerprintsHelper
extends AbstractAuthHelper {
    private static final Fingerprint[] EMPTY = new Fingerprint[0];
    private static Map<String, String> fingerprintsMap = new ConcurrentHashMap<String, String>();

    public static String getFingerprintValue(String userName, String serverAddress, String trustFilePath) throws IOException {
        String fingerprintValue = null;
        Fingerprint fingerprint = FingerprintsHelper.getFingerprint(userName, serverAddress, trustFilePath);
        if (fingerprint != null) {
            fingerprintValue = fingerprint.getFingerprintValue();
        }
        return fingerprintValue;
    }

    public static Fingerprint[] getFingerprints(String trustFilePath) throws IOException {
        File file = trustFilePath != null ? new File(trustFilePath) : null;
        Fingerprint[] fingerprints = FingerprintsHelper.getFingerprints(file);
        return fingerprints;
    }

    public static Fingerprint[] getFingerprints(File trustFile) throws IOException {
        List<Map<String, String>> authList;
        Fingerprint[] fingerprints = EMPTY;
        List<Map<String, String>> list = authList = trustFile != null ? FingerprintsHelper.getFileEntries(trustFile) : FingerprintsHelper.getMemoryEntries(fingerprintsMap);
        if (authList != null) {
            ArrayList<Fingerprint> fingerprintList = new ArrayList<Fingerprint>();
            for (Map<String, String> map : authList) {
                if (map == null) continue;
                String serverAddress = map.get("serverAddress");
                String userName = map.get("userName");
                String fingerprintValue = map.get("authValue");
                Fingerprint fingerprint = new Fingerprint(serverAddress, userName, fingerprintValue);
                fingerprintList.add(fingerprint);
            }
            fingerprints = fingerprintList.toArray(new Fingerprint[0]);
        }
        return fingerprints;
    }

    public static Fingerprint getFingerprint(String userName, String serverAddress, String trustFilePath) throws IOException {
        Fingerprint foundFingerprint = null;
        if (serverAddress != null) {
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = "localhost:" + serverAddress;
            }
            for (Fingerprint fingerprint : FingerprintsHelper.getFingerprints(trustFilePath)) {
                if (!serverAddress.equals(fingerprint.getServerAddress()) || userName != null && !userName.equals(fingerprint.getUserName())) continue;
                foundFingerprint = fingerprint;
                break;
            }
        }
        return foundFingerprint;
    }

    public static Fingerprint getFingerprint(String serverAddress, String trustFilePath) throws IOException {
        return FingerprintsHelper.getFingerprint(null, serverAddress, trustFilePath);
    }

    public static void saveFingerprint(Fingerprint fingerprint, String trustFilePath) throws IOException {
        File file = trustFilePath != null ? new File(trustFilePath) : null;
        FingerprintsHelper.saveFingerprint(fingerprint, file);
    }

    public static void saveFingerprint(Fingerprint fingerprint, File trustFile) throws IOException {
        if (fingerprint != null) {
            FingerprintsHelper.saveFingerprint(fingerprint.getUserName(), fingerprint.getServerAddress(), fingerprint.getFingerprintValue(), trustFile);
        }
    }

    public static void saveFingerprint(String userName, String serverAddress, String fingerprintValue, String trustFilePath) throws IOException {
        File file = trustFilePath != null ? new File(trustFilePath) : null;
        FingerprintsHelper.saveFingerprint(userName, serverAddress, fingerprintValue, file);
    }

    public static void saveFingerprint(String userName, String serverAddress, String fingerprintValue, String trustFilePath, int lockTry, long lockDelay, long lockWait) throws IOException {
        File file = trustFilePath != null ? new File(trustFilePath) : null;
        FingerprintsHelper.saveFingerprint(userName, serverAddress, fingerprintValue, file, lockTry, lockDelay, lockWait);
    }

    public static void saveFingerprint(String userName, String serverAddress, String fingerprintValue, File trustFile) throws IOException {
        FingerprintsHelper.saveFingerprint(userName, serverAddress, fingerprintValue, trustFile, 0, 0L, 0L);
    }

    public static void saveFingerprint(String userName, String serverAddress, String fingerprintValue, File trustFile, int lockTry, long lockDelay, long LockWait) throws IOException {
        if (trustFile != null) {
            FingerprintsHelper.saveFileEntry(userName, serverAddress, fingerprintValue, trustFile, lockTry, lockDelay, LockWait);
        } else {
            FingerprintsHelper.saveMemoryEntry(userName, serverAddress, fingerprintValue, fingerprintsMap);
        }
    }
}

