/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcCRC32Checksum;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInflaterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcLineEndFilterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.Inflater;

public class RpcOutputStream
extends FileOutputStream {
    private static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int TRAILER_SIZE = 8;
    private RpcPerforceFile file;
    private RpcPerforceFileType fileType;
    private RpcInflaterOutputStream outStream;
    private CheckedOutputStream checkedOutStream;
    private Inflater inflater;
    private RpcCRC32Checksum crc;
    private boolean headerRead;
    private byte[] footerBytes;
    private boolean closed;
    private boolean writeUtf8Bom;
    private ClientLineEnding lineEnding;
    private RpcLineEndFilterOutputStream lineEndStream;
    private Charset charset;
    private CharsetConverter converter;
    private String serverDigest;
    private MD5Digester localDigester;

    public RpcOutputStream(RpcPerforceFile file) throws IOException {
        this(file, null, false, false);
    }

    public RpcOutputStream(RpcPerforceFile file, boolean useLocalDigester) throws IOException {
        this(file, null, false, useLocalDigester);
    }

    public RpcOutputStream(RpcPerforceFile file, Charset charset, boolean isUnicodeServer, boolean useLocalDigester) throws IOException {
        block13: {
            block12: {
                super(file);
                this.file = null;
                this.fileType = null;
                this.outStream = null;
                this.checkedOutStream = null;
                this.inflater = null;
                this.crc = null;
                this.headerRead = false;
                this.footerBytes = null;
                this.closed = false;
                this.writeUtf8Bom = false;
                this.lineEnding = null;
                this.lineEndStream = null;
                this.charset = null;
                this.converter = null;
                this.serverDigest = null;
                this.localDigester = null;
                if (file == null) {
                    throw new NullPointerError("Null RpcPerforceFile passed to RpcOutputStream constructor");
                }
                if (useLocalDigester) {
                    this.localDigester = new MD5Digester();
                }
                this.fileType = file.getFileType();
                if (charset != null && !this.fileType.equals((Object)RpcPerforceFileType.FST_XUTF8) && !this.fileType.equals((Object)RpcPerforceFileType.FST_UTF8)) {
                    this.charset = isUnicodeServer && !charset.equals(CharsetDefs.UTF8) ? charset : null;
                }
                this.closed = false;
                this.file = file;
                this.lineEnding = file.getLineEnding();
                this.writeUtf8Bom = false;
                if (this.fileType == null) break block12;
                switch (this.fileType) {
                    case FST_UTF16: 
                    case FST_XUTF16: {
                        this.charset = CharsetDefs.UTF16;
                    }
                    case FST_UTF8: 
                    case FST_XUTF8: {
                        this.writeUtf8Bom = this.charset == null;
                    }
                    case FST_UNICODE: 
                    case FST_XUNICODE: {
                        if (this.charset != null && (isUnicodeServer || this.charset == CharsetDefs.UTF16)) {
                            this.converter = new CharsetConverter(CharsetDefs.UTF8, this.charset);
                        }
                    }
                    case FST_TEXT: 
                    case FST_XTEXT: {
                        if (ClientLineEnding.needsLineEndFiltering(this.lineEnding)) {
                            this.lineEndStream = new RpcLineEndFilterOutputStream(this, this.lineEnding);
                            break;
                        }
                        break block13;
                    }
                    case FST_GUNZIP: 
                    case FST_XGUNZIP: {
                        this.inflater = new Inflater(true);
                        this.crc = new RpcCRC32Checksum();
                        this.checkedOutStream = new CheckedOutputStream(new BufferedOutputStream(this), this.crc);
                        this.outStream = new RpcInflaterOutputStream(this.checkedOutStream, this.inflater, this.localDigester);
                        this.headerRead = false;
                        this.footerBytes = new byte[8];
                        break;
                    }
                }
                break block13;
            }
            this.fileType = RpcPerforceFileType.FST_TEXT;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            switch (this.fileType) {
                case FST_UTF16: 
                case FST_XUTF16: 
                case FST_UTF8: 
                case FST_XUTF8: 
                case FST_UNICODE: 
                case FST_XUNICODE: 
                case FST_TEXT: 
                case FST_XTEXT: {
                    if (this.lineEndStream == null) break;
                    this.lineEndStream.close();
                    break;
                }
                case FST_GUNZIP: 
                case FST_XGUNZIP: {
                    this.readTrailer(this.footerBytes);
                    this.outStream.close();
                    this.checkedOutStream.close();
                    break;
                }
            }
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        byte[] underflow;
        super.flush();
        if (this.converter != null && (underflow = this.converter.clearUnderflow()) != null) {
            try {
                this.writeConverted(underflow);
            }
            catch (FileDecoderException e) {
                throw new IOException(e);
            }
            catch (FileEncoderException e) {
                throw new IOException(e);
            }
        }
    }

    public long write(Map<String, Object> map) throws IOException, FileDecoderException, FileEncoderException {
        if (map == null) {
            throw new NullPointerError("Null map passed to RpcOutputStream.write(map)");
        }
        try {
            byte[] sourceBytes = (byte[])map.get("data");
            return this.writeConverted(sourceBytes);
        }
        catch (ClassCastException exc) {
            throw new P4JavaError("RpcFunctionMapKey.DATA value not byte[] type");
        }
    }

    @Override
    public void write(byte[] sourceBytes, int off, int len) throws IOException {
        if (sourceBytes == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        if (off < 0) {
            throw new P4JavaError("Negative offset in RpcOutputStream.write()");
        }
        if (len < 0) {
            throw new P4JavaError("Negative length in RpcOutputStream.write()");
        }
        super.write(sourceBytes, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        super.write(b, 0, b.length);
    }

    public long writeConverted(byte[] sourceBytes) throws IOException, FileDecoderException, FileEncoderException {
        int len = sourceBytes.length;
        int start = 0;
        int bom = 0;
        if (this.writeUtf8Bom) {
            this.write(new byte[]{-17, -69, -65}, 0, 3);
            bom = 3;
            this.writeUtf8Bom = false;
        }
        if (len <= 0) {
            return 0L;
        }
        long bytesWritten = len + bom - start;
        switch (this.fileType) {
            case FST_UTF16: 
            case FST_XUTF16: 
            case FST_UNICODE: 
            case FST_XUNICODE: {
                if (this.converter != null) {
                    ByteBuffer sourceBuffer;
                    ByteBuffer converted;
                    if (this.localDigester != null) {
                        this.localDigester.update(sourceBytes);
                    }
                    if (this.lineEndStream != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
                        this.lineEndStream.write(out, sourceBytes, start, len);
                        sourceBytes = out.toByteArray();
                        len = sourceBytes.length;
                        start = 0;
                    }
                    if ((converted = this.converter.convert(sourceBuffer = ByteBuffer.wrap(sourceBytes))) != null) {
                        sourceBytes = converted.array();
                        start = converted.position();
                        len = converted.limit();
                    } else {
                        len = 0;
                    }
                    if (len <= 0) {
                        return 0L;
                    }
                    this.write(sourceBytes, start, len);
                    bytesWritten = len + bom - start;
                    break;
                }
            }
            case FST_UTF8: 
            case FST_XUTF8: 
            case FST_TEXT: 
            case FST_XTEXT: {
                if (this.localDigester != null) {
                    this.localDigester.update(sourceBytes, start, len);
                }
                if (this.lineEndStream != null) {
                    this.lineEndStream.write(sourceBytes, start, len);
                } else {
                    this.write(sourceBytes, start, len);
                }
                bytesWritten = len + bom - start;
                break;
            }
            case FST_GUNZIP: 
            case FST_XGUNZIP: {
                long bytesWrittenPrior = this.outStream.getBytesWritten();
                if (!this.headerRead) {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(sourceBytes, 0, len);
                    this.readHeader(byteStream, new RpcCRC32Checksum());
                    this.headerRead = true;
                    int bytesAvailable = byteStream.available();
                    if (bytesAvailable > 0) {
                        this.outStream.write(sourceBytes, len - bytesAvailable, bytesAvailable);
                        if (bytesAvailable >= 8) {
                            System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
                        } else {
                            System.arraycopy(sourceBytes, len - bytesAvailable, this.footerBytes, 0, bytesAvailable);
                        }
                    }
                } else {
                    this.outStream.write(sourceBytes, 0, len);
                    if (len >= 8) {
                        System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
                    } else {
                        System.arraycopy(this.footerBytes, len, this.footerBytes, 0, 8 - len);
                        System.arraycopy(sourceBytes, 0, this.footerBytes, 8 - len, len);
                    }
                }
                bytesWritten = this.outStream.getBytesWritten() - bytesWrittenPrior;
                break;
            }
            default: {
                if (this.localDigester != null) {
                    this.localDigester.update(sourceBytes, 0, len);
                }
                this.write(sourceBytes, 0, len);
                bytesWritten = len + bom - 0;
            }
        }
        return bytesWritten;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    public RpcPerforceFile getFile() {
        return this.file;
    }

    private void readHeader(InputStream inStream, RpcCRC32Checksum crc) throws IOException {
        CheckedInputStream in = new CheckedInputStream(inStream, crc);
        crc.reset();
        if (this.readUShort(in) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(in) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int flg = this.readUByte(in);
        this.skipBytes(in, 6);
        if ((flg & 4) == 4) {
            this.skipBytes(in, this.readUShort(in));
        }
        if ((flg & 8) == 8) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 0x10) == 16) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 2) == 2) {
            int v = (int)crc.getValue() & 0xFFFF;
            if (this.readUShort(in) != v) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        long intIn = this.readUInt(in);
        long len = this.readUInt(in);
        Checksum checksum = this.checkedOutStream.getChecksum();
        if (checksum != null && intIn != checksum.getValue()) {
            throw new IOException("Corrupt GZIP trailer (bad CRC value)");
        }
        if (len != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new IOException("Corrupt GZIP trailer (bad bytes-written size)");
        }
    }

    private long readUInt(InputStream in) throws IOException {
        long s = this.readUShort(in);
        return (long)this.readUShort(in) << 16 | s;
    }

    private int readUShort(InputStream in) throws IOException {
        int b = this.readUByte(in);
        return this.readUByte(in) << 8 | b;
    }

    private int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b < -1 || b > 255) {
            throw new IOException(".read() returned value out of range -1..255: " + b);
        }
        return b;
    }

    private void skipBytes(InputStream in, int n) throws IOException {
        byte[] tmpbuf = new byte[128];
        while (n > 0) {
            int len = in.read(tmpbuf, 0, n < tmpbuf.length ? n : tmpbuf.length);
            if (len == -1) {
                throw new EOFException("Unexpected EOF");
            }
            n -= len;
        }
    }

    public String getServerDigest() {
        return this.serverDigest;
    }

    public void setServerDigest(String serverDigest) {
        this.serverDigest = serverDigest;
    }

    public MD5Digester getLocalDigester() {
        return this.localDigester;
    }

    public void setLocalDigester(MD5Digester localDigester) {
        this.localDigester = localDigester;
    }
}

