/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSSLSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;

public class RpcSocketHelper {
    public static void configureSocket(Socket socket, Properties properties) {
        if (socket == null || properties == null) {
            return;
        }
        try {
            boolean tcpNoDelay = RpcPropertyDefs.getPropertyAsBoolean(properties, "tcpNoDelay", true);
            socket.setTcpNoDelay(tcpNoDelay);
            String keepAlive = RpcPropertyDefs.getProperty(properties, "useKeepAlive");
            int timeouts = RpcPropertyDefs.getPropertyAsInt(properties, "sockSoTimeout", 30000);
            int[] perfPrefs = RpcPropertyDefs.getPropertyAsIntArray(properties, "sockPerfPrefs", ",", RpcPropertyDefs.RPC_SOCKET_PERFORMANCE_PREFERENCES_DEFAULT);
            if (perfPrefs != null && perfPrefs.length == 3) {
                socket.setPerformancePreferences(perfPrefs[0], perfPrefs[1], perfPrefs[2]);
            }
            socket.setSoTimeout(timeouts);
            if (keepAlive != null && (keepAlive.startsWith("n") || keepAlive.startsWith("N"))) {
                socket.setKeepAlive(false);
            } else {
                socket.setKeepAlive(true);
            }
            int sockRecvBufSize = RpcPropertyDefs.getPropertyAsInt(properties, "sockRecvBufSize", 0);
            int sockSendBufSize = RpcPropertyDefs.getPropertyAsInt(properties, "sockSendBufSize", 0);
            if (sockRecvBufSize != 0) {
                socket.setReceiveBufferSize(sockRecvBufSize);
            }
            if (sockSendBufSize != 0) {
                socket.setSendBufferSize(sockSendBufSize);
            }
        }
        catch (Throwable exc) {
            Log.warn("Unexpected exception while setting Perforce RPC socket options: " + exc.getLocalizedMessage());
            Log.exception(exc);
        }
    }

    public static Socket createSocket(String host, int port, Properties properties, boolean secure) throws IOException {
        Socket socket = null;
        socket = secure ? RpcSSLSocketFactory.getInstance(properties).createSocket() : new Socket();
        RpcSocketHelper.configureSocket(socket, properties);
        socket.bind(new InetSocketAddress(0));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }
}

