/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.proto;

import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.server.callback.IProgressCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolFunctionDispatcher {
    public static final String TRACE_PREFIX = "ProtocolFunctionDispatcher";
    private RpcPacketDispatcher mainDispatcher = null;
    private Properties props = null;

    public ProtocolFunctionDispatcher(RpcPacketDispatcher mainDispatcher, Properties props) {
        if (mainDispatcher == null) {
            throw new NullPointerError("Null main dispatcher passed to ProtocolFunctionDispatcher constructor");
        }
        this.props = props;
        this.mainDispatcher = mainDispatcher;
    }

    public RpcPacketDispatcher.RpcPacketDispatcherResult dispatch(RpcPacketDispatcher.RpcPacketDispatcherMode dispatchMode, RpcFunctionSpec funcSpec, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (funcSpec == null) {
            throw new NullPointerError("Null function spec passed to ProtocolFunctionDispatcher.dispatch()");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null command environment passed to ProtocolFunctionDispatcher.dispatch()");
        }
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        RpcConnection rpcConnection = cmdEnv.getRpcConnection();
        RpcPacketDispatcher.RpcPacketDispatcherResult result = RpcPacketDispatcher.RpcPacketDispatcherResult.NONE;
        switch (funcSpec) {
            case PROTOCOL_PROTOCOL: {
                for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                    cmdEnv.getServerProtocolSpecsMap().put(entry.getKey(), entry.getValue());
                }
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_FLUSH1: {
                RpcPacket flush2Packet = rpcConnection.getFlowController().respondToFlush1(resultsMap);
                rpcConnection.putRpcPacket(flush2Packet);
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_FLUSH2: {
                throw new ProtocolError("Unexpected flush2 message in protocol dispatcher");
            }
            case PROTOCOL_RELEASE: {
                IProgressCallback progressCallback = cmdEnv.getProgressCallback();
                if (progressCallback != null) {
                    progressCallback.stop(cmdCallBackKey);
                }
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.STOP_NORMAL;
                break;
            }
            case PROTOCOL_RELEASE2: {
                throw new ProtocolError("Unexpected release2 message in protocol dispatcher");
            }
            case PROTOCOL_COMPRESS1: {
                rpcConnection.useConnectionCompression();
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_COMPRESS2: {
                throw new ProtocolError("Unexpected compress2 message in protocol dispatcher");
            }
            default: {
                throw new P4JavaError("Unimplemented function spec in ProtocolFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'");
            }
        }
        return result;
    }

    public void sendRelease2(RpcConnection rpcConnection) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpc connection passed to ProtocolFunctionDispatcher.sendRelease2()");
        }
        HashMap<String, Object> flushMap = new HashMap<String, Object>(2);
        RpcPacket flush2Packet = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_RELEASE2, flushMap, null);
        rpcConnection.putRpcPacket(flush2Packet);
    }
}

