/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

public class SystemInfo {
    public static boolean isWindows() {
        return SystemInfo.getOsName().toLowerCase().startsWith("windows");
    }

    public static boolean isMac() {
        return SystemInfo.getOsName().toLowerCase().startsWith("mac") || SystemInfo.getOsName().toLowerCase().startsWith("darwin");
    }

    public static boolean isLinux() {
        return SystemInfo.getOsName().toLowerCase().startsWith("linux");
    }

    public static boolean isUnix() {
        if (SystemInfo.isLinux()) {
            return true;
        }
        if (SystemInfo.getOsName().toLowerCase().startsWith("solaris") || SystemInfo.getOsName().toLowerCase().startsWith("sunos")) {
            return true;
        }
        if (SystemInfo.getOsName().toLowerCase().indexOf("mac os x") != -1) {
            return true;
        }
        if (SystemInfo.getOsName().toLowerCase().startsWith("freebsd") || SystemInfo.getOsName().toLowerCase().startsWith("netbsd") || SystemInfo.getOsName().toLowerCase().startsWith("openbsd")) {
            return true;
        }
        if (SystemInfo.getOsName().toLowerCase().startsWith("aix")) {
            return true;
        }
        if (SystemInfo.getOsName().toLowerCase().startsWith("hp-ux")) {
            return true;
        }
        return SystemInfo.getOsName().toLowerCase().startsWith("irix");
    }

    public static String getOsName() {
        return System.getProperty("os.name", "unknown");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version", "unknown");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch", "unknown");
    }
}

