/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.P4JavaError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileAction {
    ADD,
    BRANCH,
    EDIT,
    INTEGRATE,
    DELETE,
    SYNC,
    UPDATED,
    ADDED,
    REFRESHED,
    REPLACED,
    DELETED,
    IGNORED,
    ABANDONED,
    EDIT_IGNORED,
    MOVE,
    MOVE_ADD,
    MOVE_DELETE,
    RESOLVED,
    UNRESOLVED,
    COPY_FROM,
    MERGE_FROM,
    EDIT_FROM,
    PURGE,
    IMPORT,
    UNKNOWN;

    private static final String[] names;

    public static FileAction fromString(String str) {
        if (str == null) {
            return null;
        }
        for (String name : names) {
            if (name == null || !name.equalsIgnoreCase(str)) continue;
            try {
                if (str.contains(" ")) {
                    return FileAction.valueOf(name.toUpperCase().replace(' ', '_'));
                }
                if (str.contains("/")) {
                    return FileAction.valueOf(name.toUpperCase().replace('/', '_'));
                }
                return FileAction.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                Log.error("Bad conversion attempt in FileAction.fromString; string: " + str + "; message: " + iae.getMessage());
                Log.exception(iae);
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        int ord = this.ordinal();
        if (ord >= names.length) {
            throw new P4JavaError("name / ordinal mismatch in FileAction.toString; ord: " + ord + "; names.length: " + names.length);
        }
        return names[ord];
    }

    static {
        names = new String[]{"add", "branch", "edit", "integrate", "delete", "sync", "updated", "added", "refreshed", "replaced", "deleted", "ignored", "abandoned", "edit/ignored", "move", "move/add", "move/delete", "resolved", "unresolved", "copy from", "merge from", "edit from", "purge", "import"};
    }
}

