/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.server.P4JServerFactory;
import com.perforce.p4java.server.P4JTicket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class P4JTicketsHelper {
    private static final P4JTicket[] EMPTY = new P4JTicket[0];

    public static String getTicketValue(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        String ticketValue = null;
        P4JTicket ticket = P4JTicketsHelper.getTicket(userName, serverAddress, ticketsFilePath);
        if (ticket != null) {
            ticketValue = ticket.getTicketValue();
        }
        return ticketValue;
    }

    public static P4JTicket[] getTickets(String ticketsFilePath) throws IOException {
        P4JTicket[] tickets = EMPTY;
        if (ticketsFilePath != null) {
            File ticketsFile = new File(ticketsFilePath);
            tickets = P4JTicketsHelper.getTickets(ticketsFile);
        }
        return tickets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static P4JTicket[] getTickets(File ticketsFile) throws IOException {
        P4JTicket[] tickets = EMPTY;
        if (ticketsFile != null) {
            ArrayList<P4JTicket> ticketList = new ArrayList<P4JTicket>();
            BufferedReader reader = new BufferedReader(new FileReader(ticketsFile));
            try {
                String ticketLine = reader.readLine();
                while (ticketLine != null) {
                    int colon;
                    int equals = ticketLine.indexOf(61);
                    if (equals != -1 && (colon = ticketLine.indexOf(58, equals)) != -1 && colon + 1 < ticketLine.length()) {
                        String serverAddress = ticketLine.substring(0, equals);
                        String userName = ticketLine.substring(equals + 1, colon);
                        String ticketValue = ticketLine.substring(colon + 1);
                        P4JTicket ticket = new P4JTicket(serverAddress, userName, ticketValue);
                        ticketList.add(ticket);
                    }
                    ticketLine = reader.readLine();
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            tickets = ticketList.toArray(new P4JTicket[0]);
        }
        return tickets;
    }

    public static P4JTicket getTicket(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        P4JTicket foundTicket = null;
        if (serverAddress != null) {
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            for (P4JTicket ticket : P4JTicketsHelper.getTickets(ticketsFilePath)) {
                if (!serverAddress.equals(ticket.getServerAddress()) || userName != null && !userName.equals(ticket.getUserName())) continue;
                foundTicket = ticket;
                break;
            }
        }
        return foundTicket;
    }

    public static P4JTicket getTicket(String serverAddress, String ticketsFilePath) throws IOException {
        return P4JTicketsHelper.getTicket(null, serverAddress, ticketsFilePath);
    }

    public static void saveTicket(P4JTicket ticket, String ticketsFilePath) throws IOException {
        if (ticketsFilePath != null) {
            P4JTicketsHelper.saveTicket(ticket, new File(ticketsFilePath));
        }
    }

    public static void saveTicket(P4JTicket ticket, File ticketsFile) throws IOException {
        if (ticket != null) {
            P4JTicketsHelper.saveTicket(ticket.getUserName(), ticket.getServerAddress(), ticket.getTicketValue(), ticketsFile);
        }
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath) throws IOException {
        if (ticketsFilePath != null) {
            P4JTicketsHelper.saveTicket(userName, serverAddress, ticketValue, new File(ticketsFilePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile) throws IOException {
        boolean renamed;
        File tempTicket;
        block16: {
            if (userName == null) return;
            if (serverAddress == null) return;
            if (ticketsFile == null) return;
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            String prefix = serverAddress + "=" + userName + ":";
            String value = null;
            if (ticketValue != null) {
                value = prefix + ticketValue;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(ticketsFile));
            }
            catch (FileNotFoundException fnfe) {
                reader = null;
            }
            tempTicket = File.createTempFile("p4tickets", ".txt");
            tempTicket.deleteOnExit();
            PrintWriter writer = new PrintWriter(tempTicket, "utf-8");
            try {
                boolean processed = false;
                if (reader != null) {
                    String ticketLine = reader.readLine();
                    while (ticketLine != null) {
                        if (!processed && ticketLine.startsWith(prefix)) {
                            if (value != null) {
                                writer.println(value);
                            }
                            processed = true;
                        } else {
                            writer.println(ticketLine);
                        }
                        ticketLine = reader.readLine();
                    }
                }
                if (!processed && value != null) {
                    writer.println(value);
                }
                Object var12_12 = null;
                writer.flush();
                writer.close();
                if (reader == null) break block16;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                writer.flush();
                writer.close();
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            reader.close();
        }
        if (!(renamed = tempTicket.renameTo(ticketsFile))) {
            renamed = P4JTicketsHelper.copy(tempTicket, ticketsFile);
        }
        P4JTicketsHelper.updateReadBit(ticketsFile);
        if (renamed) return;
        throw new IOException("P4 tickets file: " + ticketsFile.getAbsolutePath() + " could not be overwritten.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(File source, File destination) throws IOException {
        boolean copied = false;
        if (source != null && destination != null) {
            IOException e22;
            AbstractInterruptibleChannel writer;
            block13: {
                FileChannel reader = null;
                writer = null;
                try {
                    long targetCount;
                    long transferCount;
                    reader = new FileInputStream(source).getChannel();
                    P4JSystemFileCommandsHelper helper = P4JServerFactory.getRpcFileSystemHelper();
                    if (helper != null) {
                        helper.setWritable(destination.getAbsolutePath(), true);
                    }
                    copied = (transferCount = ((FileChannel)(writer = new FileOutputStream(destination, false).getChannel())).transferFrom(reader, 0L, targetCount = reader.size())) == targetCount;
                    Object var11_8 = null;
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    IOException e22;
                    Object var11_9 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e22) {}
            }
        }
        return copied;
    }

    private static void updateReadBit(File file) throws IOException {
        if (file != null) {
            file.setReadOnly();
            P4JSystemFileCommandsHelper helper = P4JServerFactory.getRpcFileSystemHelper();
            if (helper != null) {
                helper.setOwnerReadOnly(file.getAbsolutePath());
            }
        }
    }
}

