/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JMetadata;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JNoSuchObjectException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JResourceException;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.p4cmd.P4CmdServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcNtsServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcOneShotServerImpl;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import com.perforce.p4java.impl.mapbased.server.P4JServerImplControl;
import com.perforce.p4java.server.P4JServer;
import com.perforce.p4java.server.P4JServerImplMetadata;
import com.perforce.p4java.server.callback.P4JLogCallback;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JServerFactory {
    public static final String TRACE_PREFIX = "P4JServerFactory";
    public static final String DEFAULT_PROTOCOL_SPEC = "p4java";
    public static final String DEFAULT_PROTOCOL_NAME = "p4jrpc";
    public static P4JLogCallback logCallback = null;
    private static Map<String, Class> implMap = new HashMap<String, Class>();
    private static P4JSystemFileCommandsHelper rpcFileCommandsHelper = null;

    public static List<P4JServerImplMetadata> getAvailableImplementationMetadata() {
        ArrayList<P4JServerImplMetadata> retList = new ArrayList<P4JServerImplMetadata>();
        for (String key : implMap.keySet()) {
            Class implClass = implMap.get(key);
            P4JServerImplMetadata md = P4JServerFactory.getImplMetadata(implClass);
            if (md == null) continue;
            retList.add(md);
        }
        return retList;
    }

    public static P4JServer getServer(String serverUriString, Properties props) throws URISyntaxException, P4JConnectionException, P4JNoSuchObjectException, P4JConfigException, P4JResourceException {
        P4JServerImplMetadata implMetadata;
        if (serverUriString == null) {
            throw new P4JNullPointerError("Null server serverUriString passed to server factory");
        }
        P4JTracer.coarse("P4JServerFactory.getServer: P4Java version: " + P4JMetadata.getP4JVersionString());
        P4JTracer.fine("P4JServerFactory.getServer: Perforce server URI string: " + serverUriString);
        P4JLog.info("P4Java server factory called for Perforce server URI: " + serverUriString);
        String protoPart = null;
        String hostPart = null;
        String portPartStr = null;
        int portPart = -1;
        String queryPart = null;
        int protoPartEnd = serverUriString.indexOf("://");
        if (protoPartEnd < 0) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce scheme / protocol part");
        }
        protoPart = serverUriString.substring(0, protoPartEnd);
        if (protoPart.length() + 3 >= serverUriString.length()) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server hostname");
        }
        String restStr = serverUriString.substring(protoPartEnd + 3);
        int portStart = restStr.indexOf(":");
        int queryStart = restStr.indexOf("?");
        if (portStart == 0) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server hostname");
        }
        if (portStart < 0 || queryStart > 0 && queryStart < portStart) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server port specifier");
        }
        hostPart = restStr.substring(0, portStart);
        if (queryStart > 0) {
            portPartStr = restStr.substring(portStart + 1, queryStart);
            if (queryStart >= restStr.length()) {
                throw new URISyntaxException(serverUriString, "empty or malformed P4Java query string");
            }
            queryPart = restStr.substring(queryStart + 1);
        } else {
            portPartStr = restStr.substring(portStart + 1);
        }
        try {
            portPart = new Integer(portPartStr);
        }
        catch (NumberFormatException nfe) {
            throw new URISyntaxException(serverUriString, "non-numeric Perforce server port specifier");
        }
        if (protoPart.equals(DEFAULT_PROTOCOL_SPEC)) {
            protoPart = DEFAULT_PROTOCOL_NAME;
        }
        Properties serverProps = props;
        if (queryPart != null) {
            String[] queries;
            P4JTracer.fine("P4JServerFactory.getServer: URI query string: " + queryPart);
            if (serverProps == null) {
                serverProps = new Properties();
            }
            for (String query : queries = queryPart.split("&")) {
                String[] qStrs;
                if (query == null || (qStrs = query.split("=")).length <= 0 || qStrs[0] == null) continue;
                if (qStrs.length > 1) {
                    serverProps.put(qStrs[0], qStrs[1]);
                    continue;
                }
                serverProps.put(qStrs[0], (Object)null);
            }
        }
        if (serverProps != null && P4JTracer.isTracingAtLevel(P4JLogCallback.P4JLogTraceLevel.SUPERFINE)) {
            for (Object propKey : serverProps.keySet()) {
                String propVal = serverProps.getProperty((String)propKey);
                P4JTracer.superfine("P4JServerFactory.getServer property value: " + propKey + "=" + (propVal == null ? "<null>" : propVal));
            }
        }
        if ((implMetadata = P4JServerFactory.getImplMetadata(implMap.get(protoPart))) == null) {
            throw new P4JNoSuchObjectException("No such server implementation found for protocol '" + protoPart + "'");
        }
        try {
            Class<?> serverImplClass = Class.forName(implMetadata.getImplClassName());
            P4JTracer.fine("P4JServerFactory.getServer: using impl class " + serverImplClass.getCanonicalName());
            P4JLog.info("Using Server implementation class: " + serverImplClass.getCanonicalName());
            P4JServerImplControl serverImpl = (P4JServerImplControl)serverImplClass.newInstance();
            serverImpl.init(hostPart, portPart, serverProps);
            return (P4JServer)((Object)serverImpl);
        }
        catch (ClassNotFoundException cnfe) {
            P4JLog.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class not found)");
            P4JLog.exception(cnfe);
            throw new P4JNoSuchObjectException("No such p4j server implementation class found for protocol", cnfe);
        }
        catch (ClassCastException cce) {
            P4JLog.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class cast error)");
            P4JLog.exception(cce);
            throw new P4JConfigException("Specified Perforce server implementation class does not implement required interface(s)", cce);
        }
        catch (InstantiationException ie) {
            P4JLog.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (instantiation failed)");
            P4JLog.exception(ie);
            throw new P4JConfigException("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "'", ie);
        }
        catch (IllegalAccessException iae) {
            P4JLog.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (illegal access exception)");
            P4JLog.exception(iae);
            throw new P4JConfigException("Unable to instantiate Perforce server class '" + implMetadata.getImplClassName() + "'", iae);
        }
    }

    public static P4JServer getServer(URI serverUrl, Properties props) throws P4JConnectionException, P4JNoSuchObjectException, P4JConfigException, P4JResourceException, URISyntaxException {
        if (serverUrl == null) {
            throw new P4JNullPointerError("Null server URI passed to server factory");
        }
        return P4JServerFactory.getServer(serverUrl.toString(), props);
    }

    private static P4JServerImplMetadata getImplMetadata(final Class<P4JServerImpl> implClass) {
        if (implClass == null) {
            return null;
        }
        return new P4JServerImplMetadata(){

            public String getScreenName() {
                try {
                    return (String)implClass.getField("SCREEN_NAME").get(null);
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return "Unknown";
                }
            }

            public String getComments() {
                try {
                    return (String)implClass.getField("IMPL_COMMENTS").get(null);
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return "No comments available";
                }
            }

            public P4JServerImplMetadata.ImplType getImplType() {
                try {
                    return (P4JServerImplMetadata.ImplType)((Object)implClass.getField("IMPL_TYPE").get(null));
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return P4JServerImplMetadata.ImplType.UNKNOWN;
                }
            }

            public int getMinimumServerLevel() {
                try {
                    return (Integer)implClass.getField("MINIMUM_SUPPORTED_SERVER_LEVEL").get(null);
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return -1;
                }
            }

            public String getUriScheme() {
                try {
                    return (String)implClass.getField("PROTOCOL_NAME").get(null);
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return "p4j";
                }
            }

            public boolean isDefault() {
                try {
                    return (Boolean)implClass.getField("DEFAULT_STATUS").get(null);
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return false;
                }
            }

            public String getImplClassName() {
                try {
                    return implClass.getCanonicalName();
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerFactory.getImplMetadata: " + exc.getMessage());
                    P4JLog.exception(exc);
                    return "com.perforce.p4java.NoSuchImplClass";
                }
            }
        };
    }

    public static void setRpcFileSystemHelper(P4JSystemFileCommandsHelper fsCmdHelper) {
        rpcFileCommandsHelper = fsCmdHelper;
        P4JLog.info("setting RPC system file helper to " + (fsCmdHelper == null ? "null" : "class " + fsCmdHelper.getClass().getCanonicalName()));
    }

    public static P4JSystemFileCommandsHelper getRpcFileSystemHelper() {
        return rpcFileCommandsHelper;
    }

    static {
        implMap.put("p4jcmd", P4CmdServerImpl.class);
        implMap.put(DEFAULT_PROTOCOL_NAME, P4JRpcOneShotServerImpl.class);
        implMap.put("p4jrpcnts", P4JRpcNtsServerImpl.class);
        P4JLog.info("P4Java server factory loaded; version: " + P4JMetadata.getP4JVersionString() + "; date: " + P4JMetadata.getP4JDateString());
        P4JLog.info("Using default charset: " + P4JCharset.DEFAULT + "; JVM charset: " + P4JCharset.LOCAL);
    }
}

