/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.client.P4JClient;
import com.perforce.p4java.client.P4JClientView;
import com.perforce.p4java.core.P4JBranchSpec;
import com.perforce.p4java.core.P4JChangeList;
import com.perforce.p4java.core.P4JChangeListStatus;
import com.perforce.p4java.core.P4JDepot;
import com.perforce.p4java.core.P4JFix;
import com.perforce.p4java.core.P4JJob;
import com.perforce.p4java.core.P4JJobSpec;
import com.perforce.p4java.core.P4JLabel;
import com.perforce.p4java.core.P4JServerProcess;
import com.perforce.p4java.core.P4JUserGroup;
import com.perforce.p4java.core.file.P4JDiffType;
import com.perforce.p4java.core.file.P4JExtendedFileSpec;
import com.perforce.p4java.core.file.P4JFileRevisionData;
import com.perforce.p4java.core.file.P4JFileSpec;
import com.perforce.p4java.core.file.P4JFileSpecOpStatus;
import com.perforce.p4java.core.file.P4JFileStatAncilliaryOptions;
import com.perforce.p4java.core.file.P4JFileStatOutputOptions;
import com.perforce.p4java.core.file.P4JIntegrationFileSpec;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.client.P4JClientOptionsImpl;
import com.perforce.p4java.impl.generic.client.P4JClientSpecImpl;
import com.perforce.p4java.impl.generic.client.P4JClientSubmitOptionsImpl;
import com.perforce.p4java.impl.generic.client.P4JClientViewImpl;
import com.perforce.p4java.impl.generic.core.P4JBranchSpecImpl;
import com.perforce.p4java.impl.generic.core.P4JChangeListImpl;
import com.perforce.p4java.impl.generic.core.P4JDepotImpl;
import com.perforce.p4java.impl.generic.core.P4JFixImpl;
import com.perforce.p4java.impl.generic.core.P4JInputMapper;
import com.perforce.p4java.impl.generic.core.P4JJobImpl;
import com.perforce.p4java.impl.generic.core.P4JJobSpecImpl;
import com.perforce.p4java.impl.generic.core.P4JLabelImpl;
import com.perforce.p4java.impl.generic.core.P4JServerProcessImpl;
import com.perforce.p4java.impl.generic.core.P4JUserGroupImpl;
import com.perforce.p4java.impl.generic.core.P4JUserImpl;
import com.perforce.p4java.impl.generic.core.file.P4JExtendedFileSpecImpl;
import com.perforce.p4java.impl.generic.core.file.P4JFileRevisionDataImpl;
import com.perforce.p4java.impl.generic.core.file.P4JFileSpecImpl;
import com.perforce.p4java.impl.mapbased.client.P4JClientImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.server.P4JServerImplControl;
import com.perforce.p4java.impl.mapbased.server.P4JServerInfoImpl;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServer;
import com.perforce.p4java.server.P4JServerCharsets;
import com.perforce.p4java.server.P4JServerInfo;
import com.perforce.p4java.server.P4JServerStatus;
import com.perforce.p4java.server.P4JUser;
import com.perforce.p4java.server.callback.P4JCommandCallback;
import com.perforce.p4java.server.callback.P4JProgressCallback;
import com.perforce.p4java.server.callback.P4JSSOCallback;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P4JServerImpl
implements P4JServer,
P4JServerImplControl {
    public static final String SCREEN_NAME_FIELD_NAME = "SCREEN_NAME";
    public static final String IMPL_COMMENTS_FIELD_NAME = "IMPL_COMMENTS";
    public static final String IMPL_TYPE_FIELD_NAME = "IMPL_TYPE";
    public static final String MINIMUM_SUPPORTED_SERVER_LEVEL_FIELD_NAME = "MINIMUM_SUPPORTED_SERVER_LEVEL";
    public static final String PROTOCOL_NAME_FIELD_NAME = "PROTOCOL_NAME";
    public static final String DEFAULT_STATUS_FIELD_NAME = "DEFAULT_STATUS";
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    public static final String P4TICKETS_ENV_VAR = "P4TICKETS";
    public static final String P4TICKETS_DEFAULT_WINDOWS = "p4tickets.txt";
    public static final String P4TICKETS_DEFAULT_OTHER = ".p4tickets";
    protected static final int UNKNOWN_SERVER_VERSION = -1;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected P4JServerStatus status = P4JServerStatus.UNKNOWN;
    protected Properties props = null;
    protected int serverVersion = -1;
    protected String serverHost = UNKNOWN_SERVER_HOST;
    protected int serverPort = -1;
    protected String userName = null;
    protected String password = null;
    protected String authTicket = null;
    protected P4JClient client = null;
    protected String clientName = null;
    protected String clientUnsetName = "noclient";
    protected String progName = "Unknown P4Java program";
    protected String progVersion = "Unknown P4Java program version";
    protected boolean setupOnConnect = false;
    protected boolean loginOnConnect = false;
    protected P4JCommandCallback commandCallback = null;
    protected P4JProgressCallback progressCallback = null;
    protected P4JSSOCallback ssoCallback = null;
    protected String ssoKey = null;
    protected String charsetName = null;
    protected Charset charset = null;
    protected boolean connected = false;
    protected int minumumSupportedServerVersion = 20052;
    protected String tmpDirName = null;
    protected String workingDirectoryPath = null;
    protected AtomicInteger nextCmdCallBackKey = new AtomicInteger();
    protected AtomicInteger nextProgressCallbackKey = new AtomicInteger();
    protected static boolean isRunningOnWindows = false;

    @Override
    public P4JCommandCallback registerCallback(P4JCommandCallback callback) {
        P4JCommandCallback oldCallback = this.commandCallback;
        this.commandCallback = callback;
        return oldCallback;
    }

    @Override
    public P4JProgressCallback registerProgressCallback(P4JProgressCallback progressCallback) {
        P4JProgressCallback oldCallback = this.progressCallback;
        this.progressCallback = progressCallback;
        return oldCallback;
    }

    @Override
    public P4JSSOCallback registerSSOCallback(P4JSSOCallback callback, String ssoKey) {
        P4JSSOCallback oldCallback = this.ssoCallback;
        this.ssoCallback = callback;
        this.ssoKey = ssoKey;
        return oldCallback;
    }

    @Override
    public P4JServerStatus getStatus() {
        return this.status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (charsetName != null && !P4JServerCharsets.isSupported(charsetName)) {
            throw new UnsupportedCharsetException(charsetName);
        }
        this.charsetName = charsetName;
        if (this.charsetName != null) {
            if (!Charset.isSupported(charsetName = P4JServerCharsets.getJavaCharsetName(charsetName))) return false;
            this.charset = Charset.forName(charsetName);
            return true;
        } else {
            this.charset = null;
        }
        return true;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public boolean supportsUnicode() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, String> counters = this.getCounters();
        return counters != null && counters.containsKey("unicode");
    }

    @Override
    public String[] getKnownCharsets() {
        return P4JServerCharsets.getKnownCharsets();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public P4JServerStatus init(String host, int port, Properties props) throws P4JConfigException, P4JConnectionException {
        this.serverHost = host;
        this.serverPort = port;
        this.props = props != null ? props : new Properties();
        this.tmpDirName = P4JRpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir"));
        if (this.tmpDirName == null) {
            this.tmpDirName = "/tmp";
            P4JLog.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
        this.progName = this.userName = this.props.getProperty("programName", this.props.getProperty("com.perforce.p4java.programName", "Unknown P4Java program"));
        this.progVersion = this.userName = this.props.getProperty("programVersion", this.props.getProperty("com.perforce.p4java.programVersion", "Unknown P4Java program version"));
        P4JLog.info("Using program name: '" + this.progName + "'; progam version: '" + this.progVersion + "'");
        P4JLog.info("Using tmp file directory: " + this.tmpDirName);
        this.userName = this.props.getProperty("userName", this.props.getProperty("com.perforce.p4java.userName", null));
        this.password = this.props.getProperty("password", this.props.getProperty("com.perforce.p4java.password", null));
        this.clientName = this.props.getProperty("clientName", this.props.getProperty("com.perforce.p4java.clientName", null));
        this.clientUnsetName = this.props.getProperty("com.perforce.p4java.unsetClientName", "noclient");
        this.setupOnConnect = this.props.getProperty("autoConnect", this.props.getProperty("com.perforce.p4java.autoConnect", null)) != null;
        this.loginOnConnect = this.props.getProperty("autoLogin", this.props.getProperty("com.perforce.p4java.autoLogin", null)) != null;
        return this.status;
    }

    @Override
    public void connect() throws P4JConnectionException, P4JAccessException, P4JRequestException, P4JConfigException {
        this.connected = true;
        this.status = P4JServerStatus.READY;
        P4JLog.info("connected to Perforce server at " + this.serverHost + ":" + this.serverPort);
        int serverVersion = this.getServerVersion();
        if (serverVersion == -1) {
            throw new P4JConnectionException("Unable to determine Perforce server version for connection; check network connection, connection character set setting, and / or server status");
        }
        if (serverVersion < this.minumumSupportedServerVersion) {
            throw new P4JConnectionException("Attempted to connect to an unsupported Perforce server version; target server version: " + serverVersion + "; minimum supported version: " + this.minumumSupportedServerVersion);
        }
        if (this.loginOnConnect && this.userName != null && this.password != null) {
            this.login(this.password);
        }
        if (this.setupOnConnect && this.clientName != null) {
            this.client = this.getClient(this.clientName);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() throws P4JConnectionException, P4JAccessException {
        this.connected = false;
        this.status = P4JServerStatus.DISCONNECTED;
        P4JLog.info("disconnected from Perforce server at " + this.serverHost + ":" + this.serverPort);
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    @Override
    public String getAuthTicket() {
        return this.authTicket;
    }

    @Override
    public P4JServerInfo getServerInfo() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.INFO, new String[0], null);
        if (resultsMap != null && resultsMap.length > 0) {
            return new P4JServerInfoImpl(resultsMap[0]);
        }
        return new P4JServerInfoImpl();
    }

    @Override
    public void login(String password) throws P4JConnectionException, P4JRequestException, P4JAccessException, P4JConfigException {
        if (password != null) {
            password = password + "\n";
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", password);
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.LOGIN, new String[0], pwdMap);
        if (resultsMap[0] != null) {
            this.handleErrorStr(resultsMap[0]);
            this.authTicket = (String)resultsMap[0].get("authTicket");
        }
    }

    @Override
    public void logout() throws P4JConnectionException, P4JRequestException, P4JAccessException, P4JConfigException {
        if (this.authTicket == null) {
            return;
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.LOGOUT, new String[0], null);
        this.authTicket = null;
    }

    @Override
    public List<P4JClient> getClientList(String userName, String queryString, int maxResults) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] resultsMap;
        int argCount = 0;
        if (maxResults > 0) {
            ++argCount;
        }
        String[] args = null;
        if (userName != null) {
            ++argCount;
        }
        if (queryString != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (userName != null) {
            if (this.getServerVersion() >= 20062) {
                args[i++] = "-u" + userName;
            } else {
                throw new P4JRequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (queryString != null) {
            if (this.getServerVersion() >= 20081) {
                args[i++] = "-e" + queryString;
            } else {
                throw new P4JRequestException("query expressions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxResults > 0) {
            if (this.getServerVersion() >= 20061) {
                args[i++] = "-m" + maxResults;
            } else {
                throw new P4JRequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if ((resultsMap = this.execMapCmd(P4JCmdSpec.CLIENTS, args, null)) == null) {
            throw new P4JError("Null resultsMap in getClientList call");
        }
        ArrayList<P4JClient> specList = new ArrayList<P4JClient>();
        for (Map<String, Object> map : resultsMap) {
            String errStr = this.getErrorStr(map);
            if (errStr != null) {
                throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            specList.add(new P4JClientImpl(this, new P4JClientSpecImpl(map), false));
        }
        return specList;
    }

    @Override
    public List<P4JLabel> getLabelList(String user, int maxLabels, String nameFilter, List<P4JFileSpec> fileList) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        String[] args = null;
        if (user != null) {
            ++argCount;
        }
        if (maxLabels > 0) {
            ++argCount;
        }
        if (nameFilter != null) {
            ++argCount;
        }
        if (fileList != null) {
            argCount += fileList.size();
        }
        args = new String[argCount];
        int i = 0;
        if (user != null) {
            if (this.getServerVersion() >= 20062) {
                args[i++] = "-u" + user;
            } else {
                throw new P4JRequestException("user restrictions for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxLabels > 0) {
            if (this.getServerVersion() >= 20061) {
                args[i++] = "-m" + maxLabels;
            } else {
                throw new P4JRequestException("max limit for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (nameFilter != null) {
            if (this.getServerVersion() >= 20081) {
                args[i++] = "-e" + nameFilter;
            } else {
                throw new P4JRequestException("query expressions for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        Map<String, Object>[] resultsMaps = this.execMapCmd(P4JCmdSpec.LABELS, P4JServerImpl.populatePathArray(args, i, fileList), null);
        ArrayList<P4JLabel> labelList = new ArrayList<P4JLabel>();
        if (resultsMaps != null) {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null || this.handleErrorStr(map)) continue;
                labelList.add(new P4JLabelImpl(map, true, this));
            }
        }
        return labelList;
    }

    @Override
    public P4JLabel getLabel(String labelName) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (labelName == null) {
            throw new P4JNullPointerError("Null label name passed to P4JServerImpl.labelName");
        }
        String OFLAG = "-o";
        Map<String, Object>[] resultsMaps = this.execMapCmd(P4JCmdSpec.LABEL, new String[]{"-o", labelName}, null);
        P4JLabelImpl label = null;
        if (resultsMaps == null) {
            P4JLog.warn("Unexpected null map array returned to P4JServerImpl.getLabel()");
        } else {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                label = new P4JLabelImpl(map, false, this);
            }
        }
        return label;
    }

    @Override
    public String newLabel(P4JLabel label) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (label == null) {
            throw new P4JNullPointerError("null label passed to P4JServerImpl.newLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.LABEL, new String[]{"-i"}, P4JInputMapper.map(label));
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            P4JLog.warn("null return map array in P4JServerImpl.newLabel");
        }
        return retStr;
    }

    @Override
    public String updateLabel(P4JLabel label) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (label == null) {
            throw new P4JNullPointerError("null label passed to P4JServerImpl.updateLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.LABEL, new String[]{"-i"}, P4JInputMapper.map(label));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            P4JLog.warn("null return map array in P4JServerImpl.updateLabel");
        }
        return retVal;
    }

    @Override
    public List<P4JFileSpec> getDepotFileList(List<P4JFileSpec> fileSpecs, boolean allRevs) throws P4JConnectionException, P4JAccessException {
        if (fileSpecs == null) {
            throw new P4JNullPointerError("Null file specification list passed to getDepotFiles");
        }
        ArrayList<P4JFileSpec> fileList = new ArrayList<P4JFileSpec>();
        String[] args = allRevs ? P4JServerImpl.getPreferredPathArray(new String[]{"-a"}, fileSpecs) : P4JServerImpl.getPreferredPathArray(null, fileSpecs);
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.FILES, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<P4JFileSpec> tagFiles(List<P4JFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        String[] args = null;
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        if (labelName != null) {
            ++argCount;
        }
        if (listOnly) {
            ++argCount;
        }
        if (delete) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (listOnly) {
            args[i++] = "-n";
        }
        if (delete) {
            args[i++] = "-d";
        }
        if (labelName != null) {
            args[i++] = "-l" + labelName;
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.TAG, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null);
        ArrayList<P4JFileSpec> fileList = new ArrayList<P4JFileSpec>();
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        } else {
            P4JLog.warn("null return map array in P4JServerImpl.tagFiles");
        }
        return fileList;
    }

    @Override
    public List<P4JFileSpec> moveFile(int changeListId, boolean listOnly, String fileType, P4JFileSpec fromFile, P4JFileSpec toFile) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int MIN_SUPPORTED_SERVER = 20091;
        if (this.serverVersion < 20091) {
            throw new P4JRequestException("command requires a Perforce server version 2009.1 or later");
        }
        if (fromFile == null || toFile == null) {
            throw new P4JRequestException("command requires both to and from files to be specified");
        }
        ArrayList<P4JFileSpec> fileList = new ArrayList<P4JFileSpec>();
        int argCount = 0;
        String[] args = null;
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (listOnly) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        } else if (changeListId == 0) {
            args[i++] = "-cdefault";
        }
        if (listOnly) {
            args[i++] = "-n";
        }
        if (fileType != null) {
            args[i++] = "-i" + fileType;
        }
        ArrayList<P4JFileSpec> specList = new ArrayList<P4JFileSpec>();
        try {
            P4JFileSpecImpl fromSpec = new P4JFileSpecImpl(fromFile.getPreferredPath(false));
            P4JFileSpecImpl toSpec = new P4JFileSpecImpl(toFile.getPreferredPath(false));
            specList.add(fromSpec);
            specList.add(toSpec);
        }
        catch (ClassCastException cce) {
            P4JLog.error("Class cast error in P4JFileSpecImpl.move(): " + cce.getLocalizedMessage());
            P4JLog.exception(cce);
            throw new P4JError("Class cast error in P4JFileSpecImpl.move(): " + cce.getLocalizedMessage(), cce);
        }
        Map<String, Object>[] resultsArray = this.execMapCmd(P4JCmdSpec.MOVE, P4JServerImpl.getPreferredPathArray(args, specList), null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<P4JUser> getUserList(List<String> userList, int maxUsers) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        String[] args = null;
        if (maxUsers > 0) {
            ++argCount;
        }
        if (userList != null) {
            argCount += userList.size();
        }
        args = new String[argCount];
        int i = 0;
        if (userList != null) {
            for (String user : userList) {
                args[i++] = user;
            }
        }
        if (maxUsers > 0) {
            args[i] = "-m" + maxUsers;
        }
        ArrayList<P4JUser> resultsList = new ArrayList<P4JUser>();
        Map<String, Object>[] resultsArray = this.execMapCmd(P4JCmdSpec.USERS, args, null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) continue;
                resultsList.add(new P4JUserImpl(map));
            }
        }
        return resultsList;
    }

    @Override
    public List<P4JUserGroup> getUserGroupList(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        String[] args = null;
        if (maxGroups > 0) {
            ++argCount;
        }
        if (indirect) {
            ++argCount;
        }
        if (displayValues) {
            ++argCount;
        }
        if (userOrGroupName != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (maxGroups > 0) {
            args[i++] = "-m" + maxGroups;
        }
        if (indirect) {
            args[i++] = "-i";
        }
        if (displayValues) {
            args[i++] = "-v";
        }
        if (userOrGroupName != null) {
            args[i++] = userOrGroupName;
        }
        ArrayList<P4JUserGroup> resultsList = new ArrayList<P4JUserGroup>();
        Map<String, Object>[] resultsArray = this.execMapCmd(P4JCmdSpec.GROUPS, args, null);
        if (resultsArray != null) {
            P4JUserGroupImpl ugImpl = null;
            ArrayList<String> userList = null;
            for (Map<String, Object> map : resultsArray) {
                this.handleErrorStr(map);
                String groupName = (String)map.get("group");
                if (groupName == null) continue;
                if (ugImpl == null) {
                    ugImpl = new P4JUserGroupImpl();
                    userList = new ArrayList<String>();
                    ugImpl.setName(groupName);
                } else if (!ugImpl.getName().equals(groupName)) {
                    ugImpl.setUsers(userList);
                    resultsList.add(ugImpl);
                    ugImpl = new P4JUserGroupImpl();
                    ugImpl.setName(groupName);
                    userList = new ArrayList();
                    ugImpl.setUsers(userList);
                }
                try {
                    String isSubGroup;
                    String userName = (String)map.get("user");
                    String maxScanRows = (String)map.get("maxScanRows");
                    String maxLockTime = (String)map.get("maxLockTime");
                    String timeout = (String)map.get("timeout");
                    String maxResults = (String)map.get("maxResults");
                    userList.add(userName);
                    String isOwner = (String)map.get("isOwner");
                    if (isOwner != null && isOwner.equalsIgnoreCase("1") && ugImpl.getOwners() == null) {
                        ugImpl.setOwners(new ArrayList<String>());
                        ugImpl.getOwners().add(userName);
                    }
                    if ((isSubGroup = (String)map.get("isSubGroup")) != null && isSubGroup.equals("1")) {
                        ugImpl.setSubGroup(true);
                    }
                    if (maxScanRows != null) {
                        ugImpl.setMaxScanRows(new Integer(maxScanRows));
                    }
                    if (maxLockTime != null) {
                        ugImpl.setMaxLockTime(new Integer(maxLockTime));
                    }
                    if (timeout != null) {
                        ugImpl.setTimeout(new Integer(timeout));
                    }
                    if (maxResults == null) continue;
                    ugImpl.setMaxResults(new Integer(maxResults));
                }
                catch (Throwable thr) {
                    P4JLog.warn("Unexpected exception in P4JServerImpl.getUserGroupList: " + thr.getMessage());
                    P4JLog.exception(thr);
                }
            }
            if (ugImpl != null) {
                ugImpl.setUsers(userList);
                resultsList.add(ugImpl);
            }
        }
        return resultsList;
    }

    @Override
    public P4JUserGroup getUserGroup(String name) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JUserGroupImpl ugImpl;
        block1: {
            Map<String, Object>[] arr$;
            int len$;
            int i$;
            if (name == null) {
                throw new P4JNullPointerError("null group name passed to P4JServer.getUserGroup");
            }
            Map<String, Object>[] resultsArray = this.execMapCmd(P4JCmdSpec.GROUP, new String[]{"-o", name}, null);
            ugImpl = null;
            if (resultsArray == null || (i$ = 0) >= (len$ = (arr$ = resultsArray).length)) break block1;
            Map<String, Object> map = arr$[i$];
            this.handleErrorStr(map);
            ugImpl = new P4JUserGroupImpl(map);
        }
        return ugImpl;
    }

    @Override
    public List<P4JBranchSpec> getBranchSpecList(String userName, String nameFilter, int maxReturns) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        String[] args = null;
        if (userName != null) {
            ++argCount;
        }
        if (nameFilter != null) {
            ++argCount;
        }
        if (maxReturns > 0) {
            ++argCount;
        }
        args = new String[argCount];
        int arg = 0;
        if (userName != null) {
            if (this.getServerVersion() >= 20062) {
                args[arg++] = "-u" + userName;
            } else {
                throw new P4JRequestException("user restrictions for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (nameFilter != null) {
            if (this.getServerVersion() >= 20081) {
                args[arg++] = "-e" + nameFilter;
            } else {
                throw new P4JRequestException("query expressions for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxReturns > 0) {
            if (this.getServerVersion() >= 20061) {
                args[arg++] = "-m" + maxReturns;
            } else {
                throw new P4JRequestException("max limit for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        ArrayList<P4JBranchSpec> branchList = new ArrayList<P4JBranchSpec>();
        Map<String, Object>[] branchMaps = this.execMapCmd(P4JCmdSpec.BRANCHES, args, null);
        if (branchMaps != null) {
            for (Map<String, Object> branchMap : branchMaps) {
                this.handleErrorStr(branchMap);
                branchList.add(new P4JBranchSpecImpl(branchMap, true, this));
            }
        }
        return branchList;
    }

    @Override
    public P4JBranchSpec getBranchSpec(String name) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (name == null) {
            throw new P4JNullPointerError("Null branch spec name passed to getBranchSpec");
        }
        P4JBranchSpecImpl branchSpec = null;
        Map<String, Object>[] branchMaps = this.execMapCmd(P4JCmdSpec.BRANCH, new String[]{"-o", name}, null);
        if (branchMaps != null) {
            for (Map<String, Object> map : branchMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                branchSpec = new P4JBranchSpecImpl(map, false, this);
            }
        }
        return branchSpec;
    }

    @Override
    public P4JClient getCurrentClient() {
        return this.client;
    }

    @Override
    public void setCurrentClient(P4JClient client) {
        this.client = client;
        this.clientName = this.client != null && client != null ? this.client.getName() : null;
    }

    @Override
    public P4JClient getClient(String clientName) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (clientName == null) {
            throw new P4JNullPointerError("Null client name passed to P4JServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.CLIENT, args, null);
        P4JClientImpl client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                Vector<String> altRoots = null;
                for (String key : map.keySet()) {
                    if (!key.startsWith("AltRoots")) continue;
                    if (altRoots == null) {
                        altRoots = new Vector<String>();
                    }
                    altRoots.add((String)map.get(key));
                }
                P4JClientOptionsImpl optsImpl = new P4JClientOptionsImpl((String)map.get("Options"));
                P4JClientSubmitOptionsImpl subOptsImpl = null;
                String submitOptions = (String)map.get("SubmitOptions");
                if (submitOptions != null) {
                    subOptsImpl = new P4JClientSubmitOptionsImpl(submitOptions);
                }
                P4JClientViewImpl viewImpl = new P4JClientViewImpl();
                ArrayList<P4JClientView.P4JClientViewMapping> mappingList = new ArrayList<P4JClientView.P4JClientViewMapping>();
                viewImpl.setMapping(mappingList);
                String pfx = "View";
                int i = 0;
                while (map.containsKey(pfx + i)) {
                    String key = pfx + i;
                    String[] parts = ((String)map.get(key)).split(" ");
                    if (parts.length < 2) {
                        throw new P4JError("bad client view mapping string in P4JServerImpl.getClient: " + (String)map.get(key));
                    }
                    mappingList.add(new P4JClientViewImpl.P4JClientViewMappingImpl(i, parts[0], parts[1]));
                    ++i;
                }
                String descString = (String)map.get("Description");
                if (descString != null && descString.length() > 1 && descString.endsWith("\n")) {
                    descString = descString.substring(0, descString.length() - 1);
                }
                try {
                    Date accessedDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                    Date updateDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                    P4JClientSpecImpl spec = new P4JClientSpecImpl((String)map.get("Client"), accessedDate, updateDate, descString, (String)map.get("Host"), (String)map.get("Owner"), (String)map.get("Root"), P4JClient.P4JClientLineEnd.getValue((String)map.get("LineEnd")), optsImpl, viewImpl, subOptsImpl, altRoots);
                    client = new P4JClientImpl(this, spec, true);
                    viewImpl.setClient(client);
                }
                catch (Exception exc) {
                    P4JLog.error("Date parse error in P4JServerImpl.getClient: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                }
            }
        }
        return client;
    }

    @Override
    public P4JClient getClientTemplate(String clientName, boolean allowExistent) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (clientName == null) {
            throw new P4JNullPointerError("Null client name passed to P4JServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.CLIENT, args, null);
        P4JClientImpl client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                boolean nonExistent;
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                boolean bl = nonExistent = !map.containsKey("Update") && !map.containsKey("Access");
                if (!allowExistent && !nonExistent) continue;
                P4JClientOptionsImpl optsImpl = new P4JClientOptionsImpl((String)map.get("Options"));
                P4JClientSubmitOptionsImpl subOptsImpl = null;
                String submitOptions = (String)map.get("SubmitOptions");
                if (submitOptions != null) {
                    subOptsImpl = new P4JClientSubmitOptionsImpl(submitOptions);
                }
                P4JClientViewImpl viewImpl = new P4JClientViewImpl();
                ArrayList<P4JClientView.P4JClientViewMapping> mappingList = new ArrayList<P4JClientView.P4JClientViewMapping>();
                viewImpl.setMapping(mappingList);
                String pfx = "View";
                int i = 0;
                while (map.containsKey(pfx + i)) {
                    String key = pfx + i;
                    String[] parts = ((String)map.get(key)).split(" ");
                    if (parts.length < 2) {
                        throw new P4JError("bad client view mapping string in P4JServerImpl.getClient: " + (String)map.get(key));
                    }
                    mappingList.add(new P4JClientViewImpl.P4JClientViewMappingImpl(i, parts[0], parts[1]));
                    ++i;
                }
                String descString = (String)map.get("Description");
                if (descString != null && descString.length() > 1 && descString.endsWith("\n")) {
                    descString = descString.substring(0, descString.length() - 1);
                }
                try {
                    Date accessedDate = null;
                    String accessed = (String)map.get("Access");
                    if (accessed != null) {
                        accessedDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(accessed);
                    }
                    Date updateDate = null;
                    String update = (String)map.get("Update");
                    if (update != null) {
                        updateDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(update);
                    }
                    P4JClientSpecImpl spec = new P4JClientSpecImpl((String)map.get("Client"), accessedDate, updateDate, descString, (String)map.get("Host"), (String)map.get("Owner"), (String)map.get("Root"), P4JClient.P4JClientLineEnd.getValue((String)map.get("LineEnd")), optsImpl, viewImpl, subOptsImpl, null);
                    client = new P4JClientImpl(this, spec, false);
                    viewImpl.setClient(client);
                }
                catch (Exception exc) {
                    P4JLog.error("Date parse error in P4JServerImpl.getClient: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                }
            }
        }
        return client;
    }

    @Override
    public P4JClient getClientTemplate(String clientName) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.getClientTemplate(clientName, false);
    }

    @Override
    public String newClient(P4JClient newClient) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (newClient == null) {
            throw new P4JNullPointerError("Null new client spec in newClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.CLIENT, new String[]{"-i"}, P4JInputMapper.map(newClient));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public void updateClient(P4JClient client) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (client == null) {
            throw new P4JNullPointerError("Null client in P4JServer.updateClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.CLIENT, new String[]{"-i"}, P4JInputMapper.map(client));
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
            }
        }
    }

    @Override
    public void deleteClient(String clientName, boolean force) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (clientName == null) {
            throw new P4JNullPointerError("Null client name passed to P4JServerImpl.deleteClient");
        }
        String[] args = null;
        args = force ? new String[]{"-d", "-f", clientName} : new String[]{"-d", clientName};
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.CLIENT, args, null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
            }
        }
    }

    @Override
    public List<P4JDepot> getDepotList() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] resultsMap;
        ArrayList<P4JDepot> metadataArray = new ArrayList<P4JDepot>();
        for (Map<String, Object> map : resultsMap = this.execMapCmd(P4JCmdSpec.DEPOTS, new String[0], null)) {
            if (this.handleErrorStr(map)) continue;
            try {
                metadataArray.add(new P4JDepotImpl(map));
            }
            catch (Exception exc) {
                P4JLog.exception(exc);
                throw new P4JError("Unexpected conversion error in getDepotList: " + exc.getLocalizedMessage(), exc);
            }
        }
        return metadataArray;
    }

    @Override
    public List<P4JChangeList> getChangeLists(int maxMostRecent, List<P4JFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] resultsMap;
        Vector<String> argVec = new Vector<String>();
        String[] argStrings = null;
        ArrayList<P4JChangeList> changeListList = new ArrayList<P4JChangeList>();
        if (maxMostRecent > 0) {
            argVec.add("-m" + maxMostRecent);
        }
        if (clientName != null) {
            argVec.add("-c" + clientName);
        }
        if (userName != null) {
            argVec.add("-u" + userName);
        }
        if (includeIntegrated) {
            argVec.add("-i");
        }
        if (submittedOnly) {
            argVec.add("-ssubmitted");
        }
        if (pendingOnly) {
            argVec.add("-spending");
        }
        if (longDesc) {
            argVec.add("-l");
        }
        if (fileSpecs != null) {
            for (P4JFileSpec fSpec : fileSpecs) {
                argVec.add(fSpec.getPreferredPath());
            }
        }
        if (argVec.size() > 0) {
            argStrings = new String[argVec.size()];
            int i = 0;
            for (String str : argVec) {
                argStrings[i++] = str;
            }
        } else {
            argStrings = new String[]{};
        }
        if ((resultsMap = this.execMapCmd(P4JCmdSpec.CHANGES, argStrings, null)) != null) {
            for (Map<String, Object> result : resultsMap) {
                if (this.handleErrorStr(result)) continue;
                try {
                    changeListList.add(new P4JChangeListImpl(new Integer((String)result.get("change")), (String)result.get("client"), (String)result.get("user"), P4JChangeListStatus.fromString((String)result.get("status")), (String)result.get("time") == null ? null : new Date(Long.parseLong((String)result.get("time")) * 1000L), (String)result.get("desc"), this));
                }
                catch (Exception exc) {
                    P4JLog.exception(exc);
                    throw new P4JError("Unexpected conversion error in getChangeList: " + exc.getLocalizedMessage(), exc);
                }
            }
        }
        return changeListList;
    }

    @Override
    public P4JChangeList getChangeList(int id) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JChangeListImpl changeList = null;
        String[] args = null;
        args = id == 0 ? new String[]{"-o"} : new String[]{"-o", "" + id};
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.CHANGE, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                changeList = new P4JChangeListImpl(map, this);
            }
        }
        return changeList;
    }

    @Override
    public void deletePendingChangeList(int id) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        String errStr;
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.CHANGE, new String[]{"-d", "" + id}, null);
        if (resultsMap != null && resultsMap.length > 0 && resultsMap[0] != null && (errStr = this.getErrorOrInfoStr(resultsMap[0])) != null && !errStr.contains("Change " + id + " deleted")) {
            throw new P4JRequestException(errStr, this.getGenericCode(resultsMap[0]), this.getSeverityCode(resultsMap[0]));
        }
    }

    @Override
    public List<P4JFileSpec> getChangeListFiles(int id) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.DESCRIBE, new String[]{"-s", "" + id}, null);
        ArrayList<P4JFileSpec> fileList = new ArrayList<P4JFileSpec>();
        if (resultsMap != null && resultsMap.length > 0 && resultsMap[0] != null) {
            Map<String, Object> map = resultsMap[0];
            int i = 0;
            while (map.get("rev" + i) != null) {
                P4JFileSpecImpl fSpec = new P4JFileSpecImpl(map, this, i);
                fSpec.setChangeListId(id);
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    @Override
    public InputStream getChangeListDiffs(int id, P4JDiffType diffType) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 1;
        if (diffType != null) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (diffType != null) {
            args[i++] = "-d" + diffType.toArgString();
        }
        args[i++] = "" + id;
        return this.execStreamCmd(P4JCmdSpec.DESCRIBE, args);
    }

    @Override
    public Map<P4JFileSpec, List<P4JFileRevisionData>> revisionHistory(List<P4JFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] historyMap;
        int argCount = 0;
        String[] args = null;
        HashMap<P4JFileSpec, List<P4JFileRevisionData>> revMap = new HashMap<P4JFileSpec, List<P4JFileRevisionData>>();
        if (maxRevs > 0) {
            ++argCount;
        }
        if (contentHistory) {
            ++argCount;
        }
        if (includeInherited) {
            ++argCount;
        }
        if (longOutput) {
            ++argCount;
        }
        if (truncatedLongOutput) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (maxRevs > 0) {
            args[i++] = "-m" + maxRevs;
        }
        if (contentHistory) {
            args[i++] = "-h";
        }
        if (includeInherited) {
            args[i++] = "-i";
        }
        if (longOutput) {
            args[i++] = "-l";
        }
        if (truncatedLongOutput) {
            args[i++] = "-L";
        }
        if ((historyMap = this.execMapCmd(P4JCmdSpec.FILELOG, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : historyMap) {
                String errStr = this.handleFileErrorStr(result);
                if (errStr != null) {
                    P4JFileSpecImpl fSpec = new P4JFileSpecImpl(P4JFileSpecOpStatus.ERROR, errStr, this.getGenericCode(result), this.getSeverityCode(result));
                    String depotPath = (String)result.get("depotFile");
                    fSpec.setDepotPath(depotPath);
                    revMap.put(fSpec, null);
                    continue;
                }
                int revNum = 0;
                ArrayList<P4JFileRevisionDataImpl> revList = new ArrayList<P4JFileRevisionDataImpl>();
                String depotFilePath = (String)result.get("depotFile");
                P4JFileSpecImpl fSpec = new P4JFileSpecImpl();
                fSpec.setDepotPath(depotFilePath);
                revMap.put(fSpec, revList);
                while (result.get("rev" + revNum) != null) {
                    revList.add(new P4JFileRevisionDataImpl(result, revNum));
                    ++revNum;
                }
            }
        }
        return revMap;
    }

    @Override
    public List<P4JFileSpec> openedFiles(List<P4JFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] openMap;
        ArrayList<P4JFileSpec> specList = new ArrayList<P4JFileSpec>();
        int argCount = 0;
        if (allClients) {
            ++argCount;
        }
        if (clientName != null) {
            ++argCount;
        }
        if (maxFiles > 0) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allClients) {
            args[i++] = "-a";
        }
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        } else if (changeListId == 0) {
            args[i++] = "-cdefault";
        }
        if (clientName != null) {
            args[i++] = "-C" + clientName;
        }
        if ((openMap = this.execMapCmd(P4JCmdSpec.OPENED, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : openMap) {
                specList.add(this.handleFileReturn(map));
            }
        }
        return specList;
    }

    @Override
    public InputStream getFileContents(List<P4JFileSpec> fileSpecs, boolean allRevs, boolean noHeaderLine) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        if (allRevs) {
            ++argCount;
        }
        if (noHeaderLine) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allRevs) {
            args[i++] = "-a";
        }
        if (noHeaderLine) {
            args[i++] = "-q";
        }
        if (fileSpecs != null) {
            for (P4JFileSpec fSpec : fileSpecs) {
                args[i++] = fSpec.getPreferredPath();
            }
        }
        return this.execStreamCmd(P4JCmdSpec.PRINT, args);
    }

    @Override
    public List<P4JFileSpec> getDirectories(List<P4JFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] dirMaps;
        if (fileSpecs == null) {
            throw new P4JNullPointerError("Null fileSpecs in getDirectories");
        }
        ArrayList<P4JFileSpec> specList = new ArrayList<P4JFileSpec>();
        int argCount = 0;
        if (clientOnly) {
            ++argCount;
        }
        if (deletedOnly) {
            ++argCount;
        }
        if (haveListOnly) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (clientOnly) {
            args[i++] = "-C";
        }
        if (deletedOnly) {
            args[i++] = "-D";
        }
        if (haveListOnly) {
            args[i++] = "-H";
        }
        if ((dirMaps = this.execMapCmd(P4JCmdSpec.DIRS, P4JServerImpl.populatePathArray(args, i, fileSpecs), null)) != null) {
            for (Map<String, Object> map : dirMaps) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr == null) {
                    specList.add(new P4JFileSpecImpl((String)map.get("dir")));
                    continue;
                }
                if (this.isInfoMessage(map)) {
                    specList.add(new P4JFileSpecImpl(P4JFileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
                    continue;
                }
                specList.add(new P4JFileSpecImpl(P4JFileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
            }
        }
        return specList;
    }

    @Override
    public List<P4JIntegrationFileSpec> getSubmittedIntegrationsList(List<P4JFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        if (branchSpec != null) {
            ++argCount;
        }
        if (reverseMappings) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (branchSpec != null) {
            args[i++] = "-b" + branchSpec;
        }
        if (reverseMappings) {
            args[i++] = "-r";
        }
        if (fileSpecs != null) {
            for (P4JFileSpec fileSpec : fileSpecs) {
                args[i++] = fileSpec.getPreferredPath();
            }
        }
        Map<String, Object>[] mapArray = this.execMapCmd(P4JCmdSpec.INTEGRATED, args, null);
        ArrayList<P4JIntegrationFileSpec> integList = new ArrayList<P4JIntegrationFileSpec>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                integList.add(this.handleIntegrationFileReturn(map, null));
            }
        }
        return integList;
    }

    @Override
    public List<P4JExtendedFileSpec> getExtendedFileList(List<P4JFileSpec> fileSpecs, int maxFiles, int sinceChangeList, int affectedByChangelist, P4JFileStatOutputOptions outputOptions, P4JFileStatAncilliaryOptions ancilliaryOptions) throws P4JConnectionException, P4JAccessException {
        int argCount = 0;
        if (sinceChangeList >= 0) {
            ++argCount;
        }
        if (affectedByChangelist >= 0) {
            ++argCount;
        }
        if (maxFiles > 0) {
            ++argCount;
        }
        if (outputOptions != null) {
            if (outputOptions.isMappedFiles()) {
                ++argCount;
            }
            if (outputOptions.isSyncedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedNotHeadRevFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedResolvedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedNeedsResolvingFiles()) {
                ++argCount;
            }
        }
        if (ancilliaryOptions != null) {
            if (ancilliaryOptions.isAllRevs()) {
                ++argCount;
            }
            if (ancilliaryOptions.isFileSizeDigest()) {
                ++argCount;
            }
            if (ancilliaryOptions.isBothPathTypes()) {
                ++argCount;
            }
            if (ancilliaryOptions.isPendingIntegrationRecs()) {
                ++argCount;
            }
            if (ancilliaryOptions.isExcludeLocalPath()) {
                ++argCount;
            }
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (sinceChangeList > 0) {
            args[i++] = "-c" + sinceChangeList;
        } else if (sinceChangeList == 0) {
            args[i++] = "-cdefault";
        }
        if (affectedByChangelist > 0) {
            args[i++] = "-e" + affectedByChangelist;
        } else if (affectedByChangelist == 0) {
            args[i++] = "-edefault";
        }
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (outputOptions != null) {
            if (outputOptions.isMappedFiles()) {
                args[i++] = "-Rc";
            }
            if (outputOptions.isSyncedFiles()) {
                args[i++] = "-Rh";
            }
            if (outputOptions.isOpenedNotHeadRevFiles()) {
                args[i++] = "-Rn";
            }
            if (outputOptions.isOpenedFiles()) {
                args[i++] = "-Ro";
            }
            if (outputOptions.isOpenedResolvedFiles()) {
                args[i++] = "-Rr";
            }
            if (outputOptions.isOpenedNeedsResolvingFiles()) {
                args[i++] = "-Ru";
            }
        }
        if (ancilliaryOptions != null) {
            if (ancilliaryOptions.isAllRevs()) {
                args[i++] = "-Of";
            }
            if (ancilliaryOptions.isFileSizeDigest()) {
                args[i++] = "-Ol";
            }
            if (ancilliaryOptions.isBothPathTypes()) {
                args[i++] = "-Op";
            }
            if (ancilliaryOptions.isPendingIntegrationRecs()) {
                args[i++] = "-Or";
            }
            if (ancilliaryOptions.isExcludeLocalPath()) {
                args[i++] = "-Os";
            }
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.FSTAT, P4JServerImpl.populatePathArray(args, i, fileSpecs), null);
        ArrayList<P4JExtendedFileSpec> specList = new ArrayList<P4JExtendedFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                String errStr = this.handleFileErrorStr(map);
                P4JExtendedFileSpecImpl eSpec = null;
                eSpec = errStr == null ? new P4JExtendedFileSpecImpl(map, this, -1) : (this.isInfoMessage(map) ? new P4JExtendedFileSpecImpl(P4JFileSpecOpStatus.INFO, errStr) : new P4JExtendedFileSpecImpl(P4JFileSpecOpStatus.ERROR, errStr));
                specList.add(eSpec);
            }
        }
        return specList;
    }

    @Override
    public List<P4JJob> getJobList(List<P4JFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        if (maxJobs > 0) {
            ++argCount;
        }
        if (longDescriptions) {
            ++argCount;
        }
        if (reverseOrder) {
            ++argCount;
        }
        if (includeIntegrated) {
            ++argCount;
        }
        if (jobView != null) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (maxJobs > 0) {
            args[i++] = "-m" + maxJobs;
        }
        if (longDescriptions) {
            args[i++] = "-l";
        }
        if (reverseOrder) {
            args[i++] = "-r";
        }
        if (includeIntegrated) {
            args[i++] = "-i";
        }
        if (jobView != null) {
            args[i++] = "-e" + jobView;
        }
        ArrayList<P4JJob> jobList = new ArrayList<P4JJob>();
        Map<String, Object>[] jobMaps = this.execMapCmd(P4JCmdSpec.JOBS, P4JServerImpl.populatePathArray(args, i, fileSpecs), null);
        if (jobMaps != null) {
            for (Map<String, Object> map : jobMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                jobList.add(new P4JJobImpl(this, map, longDescriptions));
            }
        }
        return jobList;
    }

    @Override
    public P4JJob getJob(String jobId) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (jobId == null) {
            throw new P4JError("Null jobId in server.getJob()");
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(P4JCmdSpec.JOB, new String[]{"-o", jobId}, null);
        P4JJobImpl job = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                job = new P4JJobImpl(this, map);
            }
        }
        return job;
    }

    @Override
    public P4JJob createJob(Map<String, Object> fieldMap) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (fieldMap == null) {
            throw new P4JNullPointerError("Null field map passed to P4JServerImpl.createJob");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.JOB, new String[]{"-i"}, fieldMap);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                String[] strs;
                this.handleErrorStr(map);
                String infoStr = this.getInfoStr(map);
                if (infoStr == null || !infoStr.contains("Job ") || !infoStr.contains(" saved") || (strs = infoStr.split(" ")).length != 3 || strs[1] == null) continue;
                return this.getJob(strs[1]);
            }
        }
        return null;
    }

    @Override
    public String updateJob(P4JJob job) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (job == null) {
            throw new P4JNullPointerError("Null job passed to P4JServerImpl.updateJob");
        }
        String retVal = null;
        Map<String, Object>[] retMaps = this.execMapCmd(P4JCmdSpec.JOB, new String[]{"-i"}, job.getRawFields());
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public P4JJobSpec getJobSpec() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] specMaps = this.execMapCmd(P4JCmdSpec.JOBSPEC, new String[]{"-o"}, null);
        P4JJobSpecImpl jobSpec = null;
        if (specMaps != null) {
            for (Map<String, Object> map : specMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                jobSpec = new P4JJobSpecImpl(map, this);
            }
        }
        return jobSpec;
    }

    @Override
    public List<P4JFix> getFixList(List<P4JFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argCount = 0;
        if (maxFixes > 0) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (jobId != null) {
            ++argCount;
        }
        if (includeIntegrations) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (maxFixes > 0) {
            args[i++] = "-m" + maxFixes;
        }
        if (changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        if (jobId != null) {
            args[i++] = "-j" + jobId;
        }
        if (includeIntegrations) {
            args[i++] = "-i";
        }
        ArrayList<P4JFix> fixList = new ArrayList<P4JFix>();
        Map<String, Object>[] fixMaps = this.execMapCmd(P4JCmdSpec.FIXES, P4JServerImpl.populatePathArray(args, i, fileSpecs), null);
        if (fixMaps != null) {
            for (Map<String, Object> map : fixMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                fixList.add(new P4JFixImpl(map));
            }
        }
        return fixList;
    }

    @Override
    public List<P4JFix> fixJobs(List<String> jobIdList, int changeListId, String status, boolean delete) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (jobIdList == null) {
            throw new P4JError("Null jobIdList in fixJobs");
        }
        if (jobIdList.size() == 0) {
            throw new P4JRequestException("fix jobs method requires a non-empty jobs list");
        }
        int argCount = jobIdList.size() + 1 + (status == null ? 0 : 1) + (delete ? 1 : 0);
        String[] args = new String[argCount];
        int i = 0;
        args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        if (status != null) {
            args[i++] = "-s" + status;
        }
        if (delete) {
            args[i++] = "-d";
        }
        for (String id : jobIdList) {
            if (id == null) {
                throw new P4JError("Null job id in jobIdList in fixJobs method");
            }
            args[i++] = id;
        }
        ArrayList<P4JFix> fixList = new ArrayList<P4JFix>();
        Map<String, Object>[] fixMap = this.execMapCmd(P4JCmdSpec.FIX, args, null);
        if (fixMap != null) {
            for (Map<String, Object> map : fixMap) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                fixList.add(new P4JFixImpl(map));
            }
        }
        return fixList;
    }

    @Override
    public String getCounter(String counterName) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (counterName == null) {
            throw new P4JNullPointerError("null counter name passed to getCounter method");
        }
        Map<String, Object>[] counterMapArray = this.execMapCmd(P4JCmdSpec.COUNTER, new String[]{counterName}, null);
        String retVal = "";
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                if (map == null || !map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return retVal;
    }

    @Override
    public Map<String, String> getCounters() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] counterMapArray = this.execMapCmd(P4JCmdSpec.COUNTERS, null, null);
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new P4JAccessException(errStr);
                    }
                    throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                try {
                    counterMap.put((String)map.get("counter"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    P4JLog.error("getCounter conversion error: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                }
            }
        }
        return counterMap;
    }

    @Override
    public List<P4JServerProcess> getServerProcessList() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        ArrayList<P4JServerProcess> processList = new ArrayList<P4JServerProcess>();
        Map<String, Object>[] monitorMaps = this.execMapCmd(P4JCmdSpec.MONITOR, new String[]{"show"}, null);
        if (monitorMaps != null) {
            for (Map<String, Object> map : monitorMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                processList.add(new P4JServerProcessImpl(map));
            }
        }
        return processList;
    }

    public boolean handleErrorStr(Map<String, Object> map) throws P4JRequestException, P4JAccessException {
        String errStr = this.getErrorStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new P4JAccessException(errStr);
            }
            throw new P4JRequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return false;
    }

    public P4JFileSpec handleFileReturn(Map<String, Object> map) throws P4JAccessException, P4JConnectionException {
        return this.handleFileReturn(map, this.client);
    }

    public P4JFileSpec handleFileReturn(Map<String, Object> map, P4JClient client) throws P4JAccessException, P4JConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new P4JFileSpecImpl(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                return new P4JFileSpecImpl(P4JFileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            return new P4JFileSpecImpl(P4JFileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public P4JIntegrationFileSpec handleIntegrationFileReturn(Map<String, Object> map, P4JClient client) throws P4JAccessException, P4JConnectionException {
        return this.handleIntegrationFileReturn(map, false);
    }

    public P4JIntegrationFileSpec handleIntegrationFileReturn(Map<String, Object> map, boolean ignoreInfo) throws P4JAccessException, P4JConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new P4JFileSpecImpl(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                if (ignoreInfo) {
                    return new P4JFileSpecImpl(map, this, -1);
                }
                return new P4JFileSpecImpl(P4JFileSpecOpStatus.INFO, errStr);
            }
            return new P4JFileSpecImpl(P4JFileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public String handleFileErrorStr(Map<String, Object> map) throws P4JConnectionException, P4JAccessException {
        String errStr = this.getErrorOrInfoStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new P4JAccessException(errStr);
            }
            return errStr.trim();
        }
        return null;
    }

    public static String guardNull(String str) {
        String nullStr = "<null>";
        return str == null ? "<null>" : str;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<P4JFileSpec> specList) {
        String[] pathArray = new String[(preamble == null ? 0 : preamble.length) + (specList == null ? 0 : specList.size())];
        int i = 0;
        if (preamble != null) {
            for (String str : preamble) {
                pathArray[i++] = str;
            }
        }
        if (specList != null) {
            for (P4JFileSpec fSpec : specList) {
                if (fSpec != null && fSpec.getOpStatus() == P4JFileSpecOpStatus.VALID) {
                    pathArray[i++] = fSpec.getPreferredPath();
                    continue;
                }
                pathArray[i++] = null;
            }
        }
        return pathArray;
    }

    public static String[] populatePathArray(String[] pathArray, int start, List<P4JFileSpec> fileSpecList) {
        if (pathArray == null) {
            return null;
        }
        if (fileSpecList == null) {
            return pathArray;
        }
        if (start < 0) {
            throw new P4JError("negative start index in populatePathArray: " + start);
        }
        if (start > pathArray.length || pathArray.length < start + fileSpecList.size()) {
            throw new P4JError("pathArray too small in populatePathArray");
        }
        int i = start;
        for (P4JFileSpec fSpec : fileSpecList) {
            pathArray[i] = fSpec != null && fSpec.getOpStatus() == P4JFileSpecOpStatus.VALID ? fSpec.getPreferredPath() : null;
            ++i;
        }
        return pathArray;
    }

    public Map<String, Object>[] execMapCmd(P4JCmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException {
        if (cmdSpec == null) {
            throw new P4JNullPointerError("Null command spec in execMapCmd");
        }
        try {
            return this.execMapCmd(cmdSpec.toString().toLowerCase(), cmdArgs, inMap);
        }
        catch (P4JRequestException exc) {
            return null;
        }
    }

    public InputStream execStreamCmd(P4JCmdSpec cmdSpec, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (cmdSpec == null) {
            throw new P4JNullPointerError("Null command spec in execMapCmd");
        }
        return this.execStreamCmd(cmdSpec.toString().toLowerCase(), cmdArgs);
    }

    protected boolean isUnicode() {
        return this.charsetName != null;
    }

    public abstract String getErrorStr(Map<String, Object> var1);

    public abstract String getErrorOrInfoStr(Map<String, Object> var1);

    public abstract String getInfoStr(Map<String, Object> var1);

    public abstract boolean isAuthFail(String var1);

    public abstract boolean isInfoMessage(Map<String, Object> var1);

    protected abstract int getGenericCode(Map<String, Object> var1);

    protected abstract int getSeverityCode(Map<String, Object> var1);

    @Override
    public abstract Map<String, Object>[] execMapCmd(String var1, String[] var2, Map<String, Object> var3) throws P4JConnectionException, P4JAccessException, P4JRequestException;

    @Override
    public abstract Map<String, Object>[] execQuietMapCmd(String var1, String[] var2, Map<String, Object> var3) throws P4JConnectionException, P4JRequestException, P4JAccessException;

    @Override
    public abstract InputStream execStreamCmd(String var1, String[] var2) throws P4JConnectionException, P4JRequestException, P4JAccessException;

    @Override
    public abstract InputStream execQuietStreamCmd(String var1, String[] var2) throws P4JConnectionException, P4JRequestException, P4JAccessException;

    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectoryPath;
    }

    @Override
    public void setWorkingDirectory(String dirPath) {
        this.workingDirectoryPath = dirPath;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    protected int getServerVersion() throws P4JConnectionException {
        if (this.serverVersion != -1) {
            return this.serverVersion;
        }
        try {
            Map<String, Object>[] resultMap = this.execMapCmd(P4JCmdSpec.INFO.toString().toLowerCase(), new String[0], null);
            if (resultMap != null) {
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverVersion")) continue;
                    this.serverVersion = this.parseVersionString((String)map.get("serverVersion"));
                    return this.serverVersion;
                }
            }
        }
        catch (Exception exc) {
            P4JLog.exception(exc);
            throw new P4JConnectionException(exc.getLocalizedMessage());
        }
        return -1;
    }

    protected String getInfoServerAddress() {
        String address;
        block3: {
            address = null;
            try {
                Map<String, Object>[] resultMap = this.execMapCmd(P4JCmdSpec.INFO.toString().toLowerCase(), new String[0], null);
                if (resultMap == null) break block3;
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverAddress")) continue;
                    address = map.get("serverAddress").toString();
                    break;
                }
            }
            catch (Exception exc) {
                P4JLog.exception(exc);
            }
        }
        return address;
    }

    protected int parseVersionString(String versionString) {
        String candidate;
        String[] candParts;
        String[] subStrings;
        if (versionString != null && (subStrings = versionString.split("/")).length >= 3 && (candParts = (candidate = subStrings[2]).split("\\.")).length >= 2) {
            try {
                return new Integer(candParts[0] + candParts[1]);
            }
            catch (NumberFormatException nfe) {
                P4JLog.error("Unexpected exception in P4CmdServerImpl.parseVersionString: " + nfe);
            }
        }
        return -1;
    }

    public static boolean isRunningOnWindows() {
        return isRunningOnWindows;
    }

    protected String getP4TicketsOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase().contains("windows")) {
                builtLocation.append(P4TICKETS_DEFAULT_WINDOWS);
            } else {
                builtLocation.append(P4TICKETS_DEFAULT_OTHER);
            }
            location = builtLocation.toString();
        }
        return location;
    }

    public P4JSSOCallback getSSOCallback() {
        return this.ssoCallback;
    }

    public String getSSOKey() {
        return this.ssoKey;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName != null && (osName.contains("Windows") || osName.contains("windows"))) {
            isRunningOnWindows = true;
        }
    }
}

