/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.server.P4JServerCharsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class P4JRpcUnicodeHelper {
    public static Charset inferCharset(byte[] bytes, int bytesRead) {
        Charset charset = null;
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes, 0, bytesRead);
        CharBuffer charBuf = CharBuffer.allocate(byteBuf.capacity() * 2);
        for (String name : P4JServerCharsets.getKnownCharsets()) {
            if (name.equalsIgnoreCase("none")) continue;
            try {
                charset = Charset.forName(name);
            }
            catch (UnsupportedCharsetException exc) {
                continue;
            }
            if (charset == null) continue;
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            CoderResult coderResult = decoder.decode(byteBuf, charBuf, false);
            if (coderResult == null || coderResult.isError()) continue;
            return charset;
        }
        return null;
    }
}

