/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.P4JRpcSysFileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class P4JRpcPerforceFile
extends File {
    public static String TRACE_PREFIX = "P4JRpcPerforceFile";
    public static String systemTmpDirName = null;
    public static final String TMP_FILE_PFX = "p4j";
    public static final String TMP_FILE_SFX = ".tmp";
    private static final long serialVersionUID = 1L;
    private P4JRpcPerforceFileType fileType = null;
    private P4JClientLineEnding lineEnding = null;

    public static String createTempFileName(String tmpDirName) {
        File tmpDir = null;
        try {
            if (tmpDirName != null) {
                tmpDir = new File(tmpDirName);
            }
            File tmpFile = File.createTempFile(TMP_FILE_PFX, TMP_FILE_SFX, tmpDir);
            return tmpFile.getPath();
        }
        catch (IOException ioexc) {
            P4JLog.error("Unable to create temporary file: " + ioexc.getLocalizedMessage());
            return null;
        }
    }

    public P4JRpcPerforceFile(String fileName, String fileTypeStr) {
        super(fileName);
        if (fileName == null) {
            throw new P4JNullPointerError("Null file name passed to P4JRpcPerforceFile constructor");
        }
        this.fileType = P4JRpcPerforceFileType.decodeFromServerString(fileTypeStr);
        this.lineEnding = P4JClientLineEnding.decodeFromServerString(fileTypeStr, this.fileType);
        P4JTracer.superfine(TRACE_PREFIX + " constructing file: " + fileName + "; type: " + (Object)((Object)this.fileType) + "; line ending: " + (Object)((Object)this.lineEnding));
    }

    public P4JRpcPerforceFile(String fileName, P4JRpcPerforceFileType fileType) {
        super(fileName);
        if (fileName == null) {
            throw new P4JNullPointerError("Null file name passed to P4JRpcPerforceFile constructor");
        }
        this.fileType = fileType;
        this.lineEnding = P4JClientLineEnding.FST_L_LOCAL;
        P4JTracer.superfine(TRACE_PREFIX + " constructing file: " + fileName + "; type: " + (Object)((Object)this.fileType) + "; line ending: " + (Object)((Object)this.lineEnding));
    }

    public boolean renameTo(File targetFile) {
        return this.renameTo(targetFile, false);
    }

    public boolean renameTo(File targetFile, boolean alwaysCopyUnMunged) {
        if (targetFile == null) {
            throw new P4JNullPointerError("Null target file in P4JRpcPerforceFile.renameTo");
        }
        try {
            if (this.fileType == null || alwaysCopyUnMunged || this.canCopyAsIs()) {
                if (super.renameTo(targetFile)) {
                    return true;
                }
                return this.copyTo(targetFile);
            }
            return this.decodeTo(targetFile);
        }
        catch (IOException ioexc) {
            P4JLog.error("Unexpected problem with renaming / copying file '" + targetFile.getName() + "': " + ioexc.getLocalizedMessage());
            P4JLog.exception(ioexc);
            return false;
        }
    }

    private boolean setWritable(String filePath) {
        boolean writable = false;
        P4JSystemFileCommandsHelper helper = P4JRpcSysFileHelper.getSysFileCommands();
        if (helper != null) {
            writable = helper.setWritable(filePath, true);
        }
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTo(File targetFile) throws IOException {
        AbstractInterruptibleChannel targetChannel;
        AbstractInterruptibleChannel sourceChannel;
        FileOutputStream outStream;
        FileInputStream inStream;
        block29: {
            block30: {
                boolean bl;
                if (targetFile == null) {
                    throw new P4JNullPointerError("Null target file in P4JRpcPerforceFile.copyTo");
                }
                if (targetFile.exists() && !targetFile.delete()) {
                    if (!targetFile.canWrite() && this.setWritable(targetFile.getAbsolutePath())) {
                        targetFile.delete();
                    }
                    if (targetFile.exists()) {
                        P4JLog.warn("Unable to delete target file for copy in P4JRpcPerforceFile.copyTo; target: '" + targetFile.getPath());
                    }
                }
                inStream = null;
                outStream = null;
                sourceChannel = null;
                targetChannel = null;
                try {
                    long bytesTransferred = 0L;
                    inStream = new FileInputStream(this);
                    outStream = new FileOutputStream(targetFile);
                    sourceChannel = inStream.getChannel();
                    targetChannel = outStream.getChannel();
                    if (sourceChannel == null || targetChannel == null) break block29;
                    bytesTransferred = ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)targetChannel));
                    if (bytesTransferred == ((FileChannel)sourceChannel).size()) break block30;
                    P4JLog.error("channel copy for copyTo operation failed with fewer bytes transferred than expected; expected: " + ((FileChannel)sourceChannel).size() + "; saw: " + bytesTransferred);
                    bl = false;
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    try {
                        if (sourceChannel != null) {
                            sourceChannel.close();
                        }
                        if (targetChannel != null) {
                            targetChannel.close();
                        }
                        if (inStream != null) {
                            inStream.close();
                        }
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Exception exc) {
                        P4JLog.warn("Unexpected exception in P4JRpcPerforceFile.copyTo() final clause: " + exc.getLocalizedMessage());
                        P4JLog.exception(exc);
                    }
                    throw throwable;
                }
                try {
                    if (sourceChannel != null) {
                        sourceChannel.close();
                    }
                    if (targetChannel != null) {
                        targetChannel.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception exc) {
                    P4JLog.warn("Unexpected exception in P4JRpcPerforceFile.copyTo() final clause: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                }
                return bl;
            }
            boolean bl = true;
            Object var10_10 = null;
            try {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (targetChannel != null) {
                    targetChannel.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exc) {
                P4JLog.warn("Unexpected exception in P4JRpcPerforceFile.copyTo() final clause: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
            }
            return bl;
        }
        Object var10_11 = null;
        try {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (Exception exc) {
            P4JLog.warn("Unexpected exception in P4JRpcPerforceFile.copyTo() final clause: " + exc.getLocalizedMessage());
            P4JLog.exception(exc);
        }
        return false;
    }

    public boolean decodeTo(File targetFile) throws IOException {
        if (targetFile == null) {
            throw new P4JNullPointerError("Null target file in P4JRpcPerforceFile.decodeTo");
        }
        return this.copyTo(targetFile);
    }

    public P4JRpcPerforceFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(P4JRpcPerforceFileType fileType) {
        this.fileType = fileType;
    }

    public P4JClientLineEnding getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(P4JClientLineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }

    public boolean canCopyAsIs() {
        return true;
    }
}

