/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcLineEndFilterInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import java.io.FileInputStream;
import java.io.IOException;

public class P4JRpcInputStream
extends FileInputStream {
    private P4JRpcPerforceFile file = null;
    private P4JRpcPerforceFileType fileType = P4JRpcPerforceFileType.FST_TEXT;
    private P4JRpcLineEndFilterInputStream lineEndStream = null;
    private P4JClientLineEnding lineEnding = null;

    public P4JRpcInputStream(P4JRpcPerforceFile file) throws IOException {
        super(file);
        if (file == null) {
            throw new P4JNullPointerError("Null P4JRpcPerforceFile passed to P4JRpcInputStream constructor");
        }
        this.file = file;
        this.fileType = this.file.getFileType();
        this.lineEnding = this.file.getLineEnding();
        if (this.lineEnding == null) {
            this.lineEnding = P4JClientLineEnding.FST_L_LOCAL;
        }
        if (this.fileType == null) {
            this.fileType = P4JRpcPerforceFileType.FST_TEXT;
        }
        switch (this.fileType) {
            case FST_TEXT: 
            case FST_UNICODE: 
            case FST_UTF16: 
            case FST_XTEXT: {
                if (!P4JClientLineEnding.needsLineEndFiltering(this.lineEnding)) break;
                this.lineEndStream = new P4JRpcLineEndFilterInputStream(new FileInputStream(this.file), this.lineEnding);
            }
        }
    }

    public void close() throws IOException {
        switch (this.fileType) {
            case FST_TEXT: 
            case FST_UNICODE: 
            case FST_UTF16: 
            case FST_XTEXT: {
                if (this.lineEndStream == null) break;
                this.lineEndStream.close();
            }
        }
        super.close();
    }

    public int read() throws IOException {
        throw new P4JUnimplementedError("P4JRpcInputStream.read()");
    }

    public int read(byte[] targetBytes, int targetOffset, int targetLen) throws IOException {
        if (targetBytes == null) {
            throw new P4JNullPointerError("Null target byte array in P4JRpcInputStream.read()");
        }
        if (targetOffset < 0) {
            throw new P4JError("Negative target offset in P4JRpcInputStream.read()");
        }
        if (targetLen < 0) {
            throw new P4JError("Negative target length in P4JRpcInputStream.read()");
        }
        switch (this.fileType) {
            case FST_TEXT: 
            case FST_UNICODE: 
            case FST_UTF16: 
            case FST_XTEXT: {
                if (this.lineEndStream == null) break;
                return this.lineEndStream.read(targetBytes, targetOffset, targetLen);
            }
        }
        return super.read(targetBytes, targetOffset, targetLen);
    }

    public int read(byte[] targetBytes) throws IOException {
        return this.read(targetBytes, 0, targetBytes.length);
    }
}

