/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketPreamble;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JGZIPInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JGZIPOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JRpcSocketInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JRpcSocketOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

public class P4JRpcStreamConnection
extends P4JRpcConnection {
    public static final String TRACE_PREFIX = "P4JRpcStreamConnection";
    protected static final int INITIAL_SENDBUF_SIZE = 2048;
    protected static final int SENDBUF_REALLOC_INCR = 1024;
    private Socket socket = null;
    private InputStream sockInputStream = null;
    private OutputStream sockOutputStream = null;
    private InputStream topInputStream = null;
    private OutputStream topOutputStream = null;

    public P4JRpcStreamConnection(String serverHost, int serverPort, Properties props, P4JRpcServerStats stats, Charset charset) throws P4JConnectionException {
        super(serverHost, serverPort, props, stats, charset);
        P4JTracer.coarse("P4JRpcStreamConnectionconstructing connection for host:port '" + serverHost + ":" + serverPort + "'");
        try {
            this.socket = new Socket(this.hostName, this.hostPort);
            this.setSockOpts(this.socket, this.props);
            this.sockInputStream = new P4JRpcSocketInputStream(this.socket, this.stats);
            this.sockOutputStream = new P4JRpcSocketOutputStream(this.socket, this.stats);
            this.topInputStream = this.sockInputStream;
            this.topOutputStream = this.sockOutputStream;
        }
        catch (UnknownHostException exc) {
            throw new P4JConnectionException("Unable to resolve Perforce server host name '" + this.hostName + "' for RPC connection");
        }
        catch (IOException exc) {
            throw new P4JConnectionException("Unable to connect to Perforce server at " + this.hostName + ":" + this.hostPort);
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JConnectionException(thr.getLocalizedMessage());
        }
    }

    public void disconnect() throws P4JConnectionException {
        P4JTracer.coarse("P4JRpcStreamConnection.disconnect: disconnecting RPC connection");
        try {
            this.topInputStream.close();
            this.topOutputStream.close();
        }
        catch (IOException exc) {
            throw new P4JConnectionException("RPC disconnection error: " + exc.getLocalizedMessage(), exc);
        }
    }

    public void useConnectionCompression() throws P4JConnectionException {
        super.useConnectionCompression();
        try {
            this.topOutputStream.flush();
            this.putRpcPacket(P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_COMPRESS2, (String[])null, null));
            this.topOutputStream.flush();
            this.topOutputStream = new P4JGZIPOutputStream(this.sockOutputStream);
            this.topInputStream = new P4JGZIPInputStream(this.sockInputStream);
        }
        catch (IOException exc) {
            P4JLog.error("I/O exception encountered while setting up GZIP streaming: " + exc.getLocalizedMessage());
            P4JLog.exception(exc);
            throw new P4JConnectionException("unable to set up client compression streaming to Perforce server: " + exc.getLocalizedMessage(), exc);
        }
    }

    public P4JRpcPacket getRpcPacket() throws P4JConnectionException {
        byte[] preambleBytes = new byte[5];
        P4JRpcPacket packet = null;
        try {
            int moreBytesRead;
            int packetBytesRead;
            int moreBytesRead2;
            int bytesRead;
            this.stats.streamRecvs.incrementAndGet();
            if (bytesRead < 0) {
                throw new P4JConnectionException("server connection unexpectedly closed");
            }
            for (bytesRead = this.topInputStream.read(preambleBytes); bytesRead >= 0 && bytesRead < preambleBytes.length; bytesRead += moreBytesRead2) {
                moreBytesRead2 = this.topInputStream.read(preambleBytes, bytesRead, preambleBytes.length - bytesRead);
                this.stats.streamRecvs.incrementAndGet();
                if (moreBytesRead2 >= 0) continue;
                throw new P4JConnectionException("server connection unexpectedly closed");
            }
            this.stats.totalBytesRecv.getAndAdd(bytesRead);
            if (bytesRead != preambleBytes.length) {
                throw new P4JConnectionException("Incomplete RPC packet preamble read from Perforce server; connection probably broken. bytes read: " + bytesRead);
            }
            P4JRpcPacketPreamble preamble = P4JRpcPacketPreamble.retrievePreamble(preambleBytes);
            if (preamble == null) {
                throw new P4JProtocolError("Null RPC packet preamble in byte buffer");
            }
            if (!preamble.isValidChecksum()) {
                throw new P4JProtocolError("Bad checksum in RPC preamble");
            }
            int payloadLength = preamble.getPayloadSize();
            if (payloadLength <= 0) {
                throw new P4JProtocolError("Bad payload size in RPC preamble: " + payloadLength);
            }
            P4JTracer.fine("P4JRpcStreamConnection.getPacket payload length: " + payloadLength + " bytes");
            byte[] packetBytes = new byte[payloadLength];
            this.stats.streamRecvs.incrementAndGet();
            this.stats.totalBytesRecv.getAndAdd(packetBytesRead);
            if (packetBytesRead <= 0) {
                throw new P4JConnectionException("Perforce server network connection closed unexpectedly");
            }
            for (packetBytesRead = this.topInputStream.read(packetBytes, 0, payloadLength); packetBytesRead < payloadLength; packetBytesRead += moreBytesRead) {
                this.stats.incompleteReads.incrementAndGet();
                moreBytesRead = this.topInputStream.read(packetBytes, packetBytesRead, payloadLength - packetBytesRead);
                this.stats.streamRecvs.incrementAndGet();
                this.stats.totalBytesRecv.getAndAdd(moreBytesRead);
                if (moreBytesRead >= 0) continue;
                throw new P4JConnectionException("Perforce server network connection closed unexpectedly");
            }
            if (packetBytesRead != payloadLength) {
                throw new P4JError("RPC packet payload read size mismatch; expected: " + payloadLength + "; got: " + packetBytesRead);
            }
            packet = P4JRpcPacket.constructRpcPacket(preamble, packetBytes, this.clientCharset);
        }
        catch (IOException exc) {
            throw new P4JConnectionException(exc);
        }
        catch (P4JConnectionException p4jexc) {
            throw p4jexc;
        }
        catch (P4JError p4je) {
            throw p4je;
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JError(thr.getLocalizedMessage(), thr);
        }
        if (packet != null && this.stats != null) {
            this.stats.packetsRecv.incrementAndGet();
            this.stats.largestRpcPacketRecv.set(Math.max(this.stats.largestRpcPacketRecv.get(), (long)packet.getPacketLength()));
        }
        return packet;
    }

    public long putRpcPacket(P4JRpcPacket packet) throws P4JConnectionException {
        byte[] sendBytes = new byte[2048];
        int sendPos = 0;
        if (packet == null) {
            throw new P4JNullPointerError("null RPC packet passed to P4JRpcStreamConnection.putPacket");
        }
        if (packet.getFuncNameString() == null) {
            throw new P4JError("Unmapped / unmappable function in P4JRpcPacket.put()");
        }
        P4JTracer.fine("P4JRpcStreamConnection.put: putting " + packet.getFuncNameString() + " RPC packet to the wire...");
        sendPos += 5;
        Map<String, Object> mapArgs = packet.getMapArgs();
        String[] strArgs = packet.getStrArgs();
        if (mapArgs != null) {
            for (String key : mapArgs.keySet()) {
                P4JTracer.superfine("P4JRpcStreamConnection.put: putting map arg name: " + key + "; value: " + mapArgs.get(key));
                byte[] fieldBytes = this.marshalPacketField(key, mapArgs.get(key));
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (strArgs != null) {
            for (String arg : strArgs) {
                if (arg == null) continue;
                byte[] fieldBytes = this.marshalPacketField(null, arg);
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (packet.getEnv() != null) {
            P4JTracer.superfine("P4JRpcStreamConnection.put: putting env: " + packet.getEnv());
            byte[] envBytes = packet.getEnv().marshal();
            if (sendBytes.length - sendPos <= envBytes.length) {
                this.stats.bufferCompacts.getAndIncrement();
                int newBytesLength = sendBytes.length + envBytes.length + 1024;
                byte[] newBytes = new byte[newBytesLength];
                System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                sendBytes = newBytes;
            }
            System.arraycopy(envBytes, 0, sendBytes, sendPos, envBytes.length);
            sendPos += envBytes.length;
        }
        P4JTracer.superfine("P4JRpcStreamConnection.put: putting function name: " + packet.getFuncNameString());
        byte[] nameBytes = this.marshalPacketField("func", packet.getFuncNameString());
        if (sendBytes.length - sendPos <= nameBytes.length) {
            this.stats.bufferCompacts.getAndIncrement();
            int newBytesLength = sendBytes.length + nameBytes.length;
            byte[] newBytes = new byte[newBytesLength];
            System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
            sendBytes = newBytes;
        }
        System.arraycopy(nameBytes, 0, sendBytes, sendPos, nameBytes.length);
        byte[] preambleBytes = P4JRpcPacketPreamble.constructPreamble((sendPos += nameBytes.length) - 5).marshalAsBytes();
        System.arraycopy(preambleBytes, 0, sendBytes, 0, preambleBytes.length);
        try {
            this.topOutputStream.write(sendBytes, 0, sendPos);
            this.topOutputStream.flush();
            this.stats.streamSends.incrementAndGet();
            this.stats.totalBytesSent.getAndAdd(sendPos);
            this.stats.packetsSent.incrementAndGet();
            if (this.stats.largestRpcPacketSent.get() < (long)sendPos) {
                this.stats.largestRpcPacketSent.set(sendPos);
            }
        }
        catch (IOException exc) {
            P4JLog.exception(exc);
            throw new P4JConnectionException("Unable to send command to Perforce server: " + exc.getMessage(), exc);
        }
        return 0L;
    }

    public long putRpcPackets(P4JRpcPacket[] packets) throws P4JConnectionException {
        int retVal = 0;
        if (packets == null) {
            throw new P4JNullPointerError("Null RPC packets passed to P4JRpcStreamConnection.putPacket");
        }
        P4JTracer.fine("P4JRpcStreamConnection.send: sending " + packets.length + " text packets");
        for (P4JRpcPacket packet : packets) {
            if (packet == null) continue;
            retVal = (int)((long)retVal + this.putRpcPacket(packet));
        }
        return retVal;
    }

    private void setSockOpts(Socket sock, Properties props) {
        try {
            String keepAlive = P4JRpcPropertyDefs.getProperty(props, "useKeepAlive");
            int timeouts = P4JRpcPropertyDefs.getPropertyAsInt(props, "sockSoTimeout", 0);
            sock.setSoTimeout(timeouts);
            P4JTracer.superfine("P4JRpcStreamConnection.setSockOpts: setting socket timeouts to " + timeouts + " msec");
            if (keepAlive != null && (keepAlive.startsWith("n") || keepAlive.startsWith("N"))) {
                sock.setKeepAlive(false);
            } else {
                sock.setKeepAlive(true);
            }
            int sockRecvBufSize = P4JRpcPropertyDefs.getPropertyAsInt(props, "sockRecvBufSize", 0);
            int sockSendBufSize = P4JRpcPropertyDefs.getPropertyAsInt(props, "sockSendBufSize", 0);
            if (sockRecvBufSize != 0) {
                P4JTracer.superfine("P4JRpcStreamConnection.setSockOpts: setting socket recv buf to: " + sockRecvBufSize + " bytes");
                sock.setReceiveBufferSize(sockRecvBufSize);
            }
            if (sockSendBufSize != 0) {
                P4JTracer.superfine("P4JRpcStreamConnection.setSockOpts: setting socket send buf to: " + sockSendBufSize + " bytes");
                sock.setSendBufferSize(sockSendBufSize);
            }
        }
        catch (Throwable exc) {
            P4JTracer.fine("P4JRpcStreamConnection.setSockOpts exception: " + exc);
            P4JLog.warn("Unexpected exception while setting Perforce RPC socket options: " + exc.getLocalizedMessage());
            P4JLog.exception(exc);
        }
    }

    public int getSystemSendBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getSendBufferSize();
            }
            catch (SocketException exc) {
                P4JLog.error("unexpected exception: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
            }
        }
        return 0;
    }

    public int getSystemRecvBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getReceiveBufferSize();
            }
            catch (SocketException exc) {
                P4JLog.error("unexpected exception: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
            }
        }
        return 0;
    }
}

