/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerStats;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class P4JRpcSocketInputStream
extends InputStream {
    public static final String TRACE_PREFIX = "P4JRpcSocketInputStream";
    private Socket socket = null;
    private InputStream socketStream = null;
    private P4JRpcServerStats stats = null;

    public P4JRpcSocketInputStream(Socket socket, P4JRpcServerStats stats) {
        if (socket == null) {
            throw new P4JNullPointerError("null RPC socket passed to P4JRpcSocketInputStream constructor");
        }
        this.socket = socket;
        this.stats = stats;
        try {
            this.socketStream = socket.getInputStream();
        }
        catch (IOException ioexc) {
            P4JLog.error("Unexpected I/O exception thrown during input stream retrieval in P4JRpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
            P4JLog.exception(ioexc);
            throw new P4JError("Unexpected I/O exception thrown during input stream retrieval in P4JRpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
        }
    }

    public int read() throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read();
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    public int read(byte[] bytes) throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketInputStream.read()");
        }
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array in P4JRpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read(bytes);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    public int read(byte[] bytes, int offset, int len) throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketInputStream.read()");
        }
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array in P4JRpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read(bytes, offset, len);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected InputStream getSockStream() {
        return this.socketStream;
    }

    protected void setSockStream(InputStream sockStream) {
        this.socketStream = sockStream;
    }
}

