/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.jcraft.jzlib.ZStream;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JUnimplementedError;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class P4JGZIPOutputStream
extends FilterOutputStream {
    private static final int ZBITS = 15;
    private static final int ZBUF_SIZE = 10240;
    private ZStream jzOutputSream = new ZStream();
    private byte[] jzBytes = null;

    public P4JGZIPOutputStream(OutputStream out) throws IOException {
        super(out);
        this.jzOutputSream.deflateInit(-1, 15, true);
        this.jzBytes = new byte[10240];
        this.jzOutputSream.next_out = this.jzBytes;
        this.jzOutputSream.next_out_index = 0;
        this.jzOutputSream.avail_out = this.jzBytes.length;
    }

    public void write(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array passed to P4JGZIPOutputStream.write()");
        }
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array passed to P4JGZIPOutputStream.write()");
        }
        if (len <= 0 || offset < 0 || offset >= bytes.length || len > bytes.length - offset) {
            throw new P4JError("bad length or offset in P4JGZIPOutputStream.write()");
        }
        this.jzOutputSream.next_in = bytes;
        this.jzOutputSream.avail_in = len;
        this.jzOutputSream.next_in_index = offset;
        while (this.jzOutputSream.avail_in != 0) {
            int jzErr;
            if (this.jzOutputSream.avail_out == 0) {
                this.out.write(this.jzBytes);
                this.jzOutputSream.next_out = this.jzBytes;
                this.jzOutputSream.avail_out = this.jzBytes.length;
                this.jzOutputSream.next_out_index = 0;
            }
            if ((jzErr = this.jzOutputSream.deflate(0)) == 0) continue;
            throw new IOException("connection compression error: " + this.getJZlibErrorStr(jzErr));
        }
    }

    public void write(int b) throws IOException {
        throw new P4JUnimplementedError("single-byte P4JGZIPOutputStream.write()");
    }

    public void flush() throws IOException {
        this.jzOutputSream.avail_in = 0;
        boolean done = false;
        while (true) {
            if (this.jzOutputSream.avail_out == 0 || done) {
                this.out.write(this.jzBytes, 0, this.jzBytes.length - this.jzOutputSream.avail_out);
                this.jzOutputSream.next_out = this.jzBytes;
                this.jzOutputSream.avail_out = this.jzBytes.length;
                this.jzOutputSream.next_out_index = 0;
            }
            if (done) break;
            int jzErr = this.jzOutputSream.deflate(3);
            if (jzErr != 0) {
                throw new IOException("Perforce connection compression error: " + this.getJZlibErrorStr(jzErr));
            }
            if (this.jzOutputSream.avail_out == 0) continue;
            done = true;
        }
    }

    public void close() throws IOException {
        this.jzOutputSream.deflateEnd();
    }

    protected String getJZlibErrorStr(int errNum) {
        switch (errNum) {
            case -2: {
                return "stream error";
            }
            case -3: {
                return "data error";
            }
            case -4: {
                return "memory error";
            }
            case -5: {
                return "buffer error";
            }
            case -6: {
                return "version error";
            }
        }
        return "unknown error";
    }
}

