/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketFieldType;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class P4JRpcPacketField {
    public static final String TRACE_PREFIX = "P4JRpcPacketField";
    public static final int NUM_ELEMENTS = 2;
    public static final int NAME_FIELD = 0;
    public static final int VALUE_FIELD = 1;
    private String name = null;
    private Object value = null;

    public P4JRpcPacketField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static Object[] retrievePacketField(ByteBuffer buf, Charset charset) {
        int remaining;
        if (buf == null) {
            throw new P4JNullPointerError("Null byte buffer passed to P4JRpcTextField.retrievePacketField()");
        }
        P4JTracer.superfine("P4JRpcPacketField.retrievePacketField: extracting packet field");
        Object[] retVal = new Object[]{null, null};
        int INITIAL_BYTEARRAY_SIZE = 128;
        byte[] bytes = new byte[128];
        int i = 0;
        while ((bytes[i] = buf.get()) != 0) {
            if (++i < bytes.length) continue;
            P4JTracer.superfine("P4JRpcPacketField.constructor: byte buffer resized");
            byte[] newBytes = new byte[bytes.length + 128];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            bytes = newBytes;
        }
        if (i > 0) {
            try {
                retVal[0] = new String(bytes, 0, i, charset == null ? P4JRpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : P4JRpcConnection.UNICODE_SERVER_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                P4JLog.exception(e);
            }
        }
        if ((remaining = buf.remaining()) < 4) {
            throw new P4JProtocolError("Insufficient bytes in buffer to retrieve text value field length");
        }
        byte[] lengthBytes = new byte[4];
        buf.get(lengthBytes);
        int valLength = P4JRpcPacket.decodeInt4(lengthBytes);
        if (valLength < 0) {
            throw new P4JProtocolError("Negative text field value length in P4JRpcTextField initializer: " + valLength);
        }
        if (remaining < valLength) {
            throw new P4JProtocolError("Insufficient bytes in buffer to retrieve text value field");
        }
        byte[] valBytes = new byte[valLength];
        buf.get(valBytes);
        if (P4JRpcPacketFieldType.getFieldType((String)retVal[0]) == P4JRpcPacketFieldType.TEXT) {
            try {
                retVal[1] = new String(valBytes, charset == null ? P4JRpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : P4JRpcConnection.UNICODE_SERVER_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                P4JLog.exception(e);
            }
        } else {
            retVal[1] = valBytes;
        }
        buf.get();
        P4JTracer.superfine("P4JRpcPacketField.constructor name: " + (retVal[0] == null ? "<null>" : retVal[0]) + "; value: " + (retVal[1] == null ? "<null>" : retVal[1]));
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static void marshal(ByteBuffer buf, String name, String value, Charset charset) throws BufferOverflowException, UnsupportedEncodingException {
        P4JRpcPacketField.marshal(buf, name, value == null ? null : value.getBytes(charset == null ? P4JCharset.DEFAULT.name() : charset.name()));
    }

    public static void marshal(ByteBuffer buf, String name, StringBuffer value, Charset charset) throws BufferOverflowException, UnsupportedEncodingException {
        P4JRpcPacketField.marshal(buf, name, value == null ? null : value.toString().getBytes(charset == null ? P4JCharset.DEFAULT.name() : charset.name()));
    }

    public static void marshal(ByteBuffer buf, String name, byte[] value) throws BufferOverflowException {
        if (buf == null) {
            throw new P4JNullPointerError("Null byte buffer passed to P4JRpcPacketField.marshal()");
        }
        try {
            if (name != null) {
                buf.put(name.getBytes(P4JCharset.DEFAULT.name()));
            }
            buf.put((byte)0);
            int valLength = 0;
            if (value != null) {
                valLength = value.length;
            }
            buf.put(P4JRpcPacket.encodeInt4(valLength));
            if (value != null) {
                buf.put(value);
            }
            buf.put((byte)0);
        }
        catch (BufferOverflowException boe) {
            throw boe;
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JError(thr.getLocalizedMessage());
        }
    }

    public static void marshal(ByteBuffer buf, String name, ByteBuffer value) throws BufferOverflowException {
        if (buf == null) {
            throw new P4JNullPointerError("Null byte buffer passed to P4JRpcPacketField.marshal()");
        }
        try {
            if (name != null) {
                buf.put(name.getBytes(P4JCharset.DEFAULT.name()));
            }
            buf.put((byte)0);
            int valLength = 0;
            if (value != null) {
                valLength = value.limit();
            }
            buf.put(P4JRpcPacket.encodeInt4(valLength));
            if (value != null) {
                buf.put(value);
            }
            buf.put((byte)0);
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JError("Unexpected exception in P4JRpcPacketField.marshal(ByteBuffer): " + thr.getLocalizedMessage(), thr);
        }
    }

    public static void marshal(byte[] buf, String name, byte[] value) throws BufferOverflowException {
    }
}

