/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JConnectionNotConnectedException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientFunctionDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.P4JRpcFlowControl;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.P4JRpcProtocolFunctionDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcPacketDispatcher {
    public static final String TRACE_PREFIX = "P4JRpcPacketDispatcher";
    private P4JRpcFlowControl flowController = null;
    private P4JRpcProtocolFunctionDispatcher protocolDispatcher = null;
    private P4JRpcClientFunctionDispatcher clientDispatcher = null;
    private Properties props = null;

    public P4JRpcPacketDispatcher(Properties props, P4JRpcServerImpl server) {
        this.props = props;
        this.protocolDispatcher = new P4JRpcProtocolFunctionDispatcher(this, this.props);
        this.clientDispatcher = new P4JRpcClientFunctionDispatcher(this, this.props, server);
        this.flowController = new P4JRpcFlowControl(this, this.props);
    }

    public Map<String, Object>[] dispatch(P4JRpcCommandEnv cmdEnv) throws P4JConnectionException, P4JAccessException {
        String DISPATCH_PFX = "P4JRpcPacketDispatcher.dispatch ";
        if (cmdEnv == null) {
            throw new P4JNullPointerError("Null command environment passed to main dispatcher");
        }
        if (cmdEnv.getRpcConnection() == null) {
            throw new P4JNullPointerError("Null rpc connection passed to main dispatcher");
        }
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        P4JRpcConnection rpcConnection = cmdEnv.getRpcConnection();
        Vector<Map<String, Object>> resultsMapVec = new Vector<Map<String, Object>>();
        cmdEnv.setResultsMapVec(resultsMapVec);
        P4JTracer.superfine("P4JRpcPacketDispatcherP4JRpcPacketDispatcher.dispatch receive buffer size: ");
        try {
            P4JRpcPacketDispatcherMode dispatchMode = P4JRpcPacketDispatcherMode.PRIMAL;
            P4JRpcPacket packet = null;
            if (cmdEnv.getProgressCallback() != null) {
                cmdEnv.getProgressCallback().start(cmdCallBackKey);
            }
            block19: while ((packet = rpcConnection.getRpcPacket()) != null) {
                Map<String, Object> paramMap = null;
                String funcNameStr = null;
                P4JRpcFunctionSpec func = P4JRpcFunctionSpec.NONE;
                paramMap = packet.getResultsMap();
                if (paramMap == null) {
                    throw new P4JProtocolError("Null results map in P4JRpcTextPacket");
                }
                P4JTracer.superfine("P4JRpcPacketDispatcher.dispatch Results map: " + paramMap);
                funcNameStr = packet.getFuncNameString();
                if (funcNameStr == null) {
                    throw new P4JProtocolError("Null function value string in dispatch text packet");
                }
                func = P4JRpcFunctionSpec.decode(funcNameStr);
                if (func == P4JRpcFunctionSpec.NONE) {
                    throw new P4JProtocolError("Unable to decode function in P4JRpcTextPacket; func string: " + funcNameStr);
                }
                switch (func.getType()) {
                    case CLIENT: {
                        P4JTracer.coarse("P4JRpcPacketDispatcher.dispatch recvd client function: " + funcNameStr);
                        switch (this.clientDispatcher.dispatch(dispatchMode, func, cmdEnv, paramMap)) {
                            case CONTINUE: {
                                continue block19;
                            }
                            case CONTINUE_LOOP: {
                                dispatchMode = P4JRpcPacketDispatcherMode.LOOP;
                                continue block19;
                            }
                            case STOP_NORMAL: {
                                return resultsMapVec.toArray(new HashMap[resultsMapVec.size()]);
                            }
                        }
                        continue block19;
                    }
                    case USER: {
                        P4JTracer.coarse("P4JRpcPacketDispatcher.dispatch recvd user function: " + funcNameStr);
                        throw new P4JProtocolError("Unexpected user function in dispatch: '" + funcNameStr + "'");
                    }
                    case SERVER: {
                        P4JTracer.coarse("P4JRpcPacketDispatcher.dispatch recvd server function: " + funcNameStr);
                        throw new P4JUnimplementedError("Unexpected server function '" + funcNameStr + "' encountered in RPC dispatch");
                    }
                    case PROTOCOL: {
                        P4JTracer.coarse("P4JRpcPacketDispatcher.dispatch recvd protocol function: " + funcNameStr);
                        switch (this.protocolDispatcher.dispatch(dispatchMode, func, cmdEnv, paramMap)) {
                            case CONTINUE: {
                                continue block19;
                            }
                            case CONTINUE_LOOP: {
                                dispatchMode = P4JRpcPacketDispatcherMode.LOOP;
                                continue block19;
                            }
                            case STOP_NORMAL: {
                                return resultsMapVec.toArray(new HashMap[resultsMapVec.size()]);
                            }
                        }
                        continue block19;
                    }
                }
                throw new P4JProtocolError("Unrecognized function string type in RPC packet: '" + funcNameStr + "'");
            }
            throw new P4JConnectionNotConnectedException("Perforce server disconnected at server end; unknown cause.");
        }
        catch (P4JConnectionNotConnectedException cnce) {
            throw cnce;
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JConnectionException(thr.getLocalizedMessage(), thr);
        }
    }

    public void shutdown(P4JRpcConnection rpcConnection) throws P4JConnectionException {
        P4JTracer.coarse("P4JRpcPacketDispatcher.shutdown: shutting down dispatcher");
        if (this.protocolDispatcher != null && rpcConnection != null) {
            try {
                this.protocolDispatcher.sendRelease2(rpcConnection);
            }
            catch (Exception exc) {
                P4JLog.warn("Unexpected exception in RPC packet dispatch shutdown: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
                P4JTracer.coarse("P4JRpcPacketDispatcher.shutdown: saw exception: " + exc.getLocalizedMessage());
            }
        }
    }

    public P4JRpcFlowControl getFlowController() {
        return this.flowController;
    }

    protected void setFlowController(P4JRpcFlowControl flowController) {
        this.flowController = flowController;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum P4JRpcPacketDispatcherMode {
        NONE,
        PRIMAL,
        CALLBACK,
        LOOP,
        DUPLEX,
        DUPLEXREV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum P4JRpcPacketDispatcherResult {
        NONE,
        CONTINUE,
        CONTINUE_LOOP,
        CONTINUE_DUPLEX,
        STOP_NORMAL,
        STOP_ERROR;

    }
}

