/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketField;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketPreamble;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcPacket {
    public static final int DEFAULT_RPC_PACKET_BUFFER_SIZE = 2048;
    public static final int RPC_LENGTH_FIELD_LENGTH = 4;
    public static final String TRACE_PREFIX = "P4JRpcPacket";
    private P4JRpcFunctionSpec funcName = null;
    private String funcNameString = null;
    private P4JRpcExternalEnv env = null;
    private String[] strArgs = null;
    private Map<String, Object> mapArgs = null;
    private Map<String, Object> resultsMap = null;
    private int packetLength = 0;

    public static byte[] encodeInt4(int i) {
        byte[] bytes = new byte[]{(byte)(i / 1 % 256), (byte)(i / 256 % 256), (byte)(i / 65536 % 256), (byte)(i / 0x1000000 % 256)};
        return bytes;
    }

    public static int decodeInt4(byte[] bytes) {
        if (bytes == null) {
            throw new P4JNullPointerError("Null bytes passed to P4JRpcTextPacket.decodeInt");
        }
        if (bytes.length != 4) {
            throw new P4JProtocolError("Bad byte array size in P4JRpcTextPacket.decodeInt: " + bytes.length);
        }
        return (bytes[0] & 0xFF) * 1 + (bytes[1] & 0xFF) * 256 + (bytes[2] & 0xFF) * 65536 + (bytes[3] & 0xFF) * 0x1000000;
    }

    public static P4JRpcPacket constructRpcPacket(P4JRpcFunctionSpec funcName, String[] args, P4JRpcExternalEnv env) {
        return new P4JRpcPacket(funcName, args, env);
    }

    public static P4JRpcPacket constructRpcPacket(P4JRpcFunctionSpec funcName, Map<String, Object> args, P4JRpcExternalEnv env) {
        return new P4JRpcPacket(funcName, args, env);
    }

    public static P4JRpcPacket constructRpcPacket(String funcName, Map<String, Object> args, P4JRpcExternalEnv env) {
        return new P4JRpcPacket(funcName, args, env);
    }

    public static P4JRpcPacket constructRpcPacket(P4JRpcPacketPreamble preamble, byte[] bytes, Charset charset) {
        return new P4JRpcPacket(preamble, bytes, charset);
    }

    private P4JRpcPacket(P4JRpcFunctionSpec funcName, String[] args, P4JRpcExternalEnv env) {
        if (funcName == null) {
            throw new P4JNullPointerError("Null function name passed to P4JRpcPacket constructor");
        }
        P4JTracer.fine("P4JRpcPacket.constructor: func name: " + funcName.getEncoding());
        this.funcName = funcName;
        this.funcNameString = funcName.getEncoding();
        this.strArgs = args;
        this.env = env;
    }

    private P4JRpcPacket(P4JRpcFunctionSpec funcName, Map<String, Object> args, P4JRpcExternalEnv env) {
        if (funcName == null) {
            throw new P4JNullPointerError("Null function name passed to P4JRpcPacket constructor");
        }
        P4JTracer.fine("P4JRpcPacket.constructor: func name: " + funcName.getEncoding());
        this.funcName = funcName;
        this.funcNameString = funcName.getEncoding();
        this.mapArgs = args;
        this.env = env;
    }

    private P4JRpcPacket(String funcName, Map<String, Object> args, P4JRpcExternalEnv env) {
        if (funcName == null) {
            throw new P4JNullPointerError("Null function name passed to P4JRpcPacket constructor");
        }
        P4JTracer.fine("P4JRpcPacket.constructor: func name: " + funcName);
        this.funcNameString = funcName;
        this.mapArgs = args;
        this.env = env;
    }

    private P4JRpcPacket(Map<String, Object> resultsMap, int packetLength) {
        this.resultsMap = resultsMap;
        this.packetLength = packetLength;
        if (resultsMap != null) {
            this.funcNameString = (String)resultsMap.get("func");
        }
    }

    private P4JRpcPacket(P4JRpcPacketPreamble preamble, byte[] payloadBytes, Charset charset) {
        if (preamble == null) {
            throw new P4JNullPointerError("null RPC preamble passed to P4JRpcPacket constructor");
        }
        if (!preamble.isValidChecksum()) {
            throw new P4JProtocolError("Bad checksum in RPC preamble passed to P4JRpcPacket constructor");
        }
        if (payloadBytes == null) {
            throw new P4JNullPointerError("null payload byte array passed to P4JRpcPacket constructor");
        }
        int payloadLength = preamble.getPayloadSize();
        if (payloadLength != payloadBytes.length) {
            throw new P4JError("bad byte array size in P4JRpcPacket constructor; byte array length: " + payloadBytes.length + "; from preamble: " + payloadLength);
        }
        try {
            this.resultsMap = new HashMap<String, Object>();
            ByteBuffer packetBuf = ByteBuffer.wrap(payloadBytes);
            int fieldCount = 0;
            while (packetBuf.position() < packetBuf.limit()) {
                Object[] fields = P4JRpcPacketField.retrievePacketField(packetBuf, charset);
                if (fields[0] == null) {
                    this.resultsMap.put(null, fields[1]);
                } else {
                    this.resultsMap.put((String)fields[0], fields[1]);
                }
                ++fieldCount;
            }
            P4JTracer.fine("P4JRpcPacket.retrieveRpcPacket got " + fieldCount + " fields");
            this.packetLength = payloadLength;
            if (this.resultsMap != null) {
                this.funcNameString = (String)this.resultsMap.get("func");
            }
        }
        catch (P4JProtocolError pe) {
            throw pe;
        }
        catch (Throwable thr) {
            P4JLog.error("Unexpected exception: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
            throw new P4JProtocolError(thr.getLocalizedMessage(), thr);
        }
    }

    public Map<String, Object> getResultsMap() {
        return this.resultsMap;
    }

    public void setResultsMap(Map<String, Object> resultsMap) {
        this.resultsMap = resultsMap;
    }

    public String getFuncNameString() {
        return this.funcNameString;
    }

    public void setFuncNameString(String funcNameString) {
        this.funcNameString = funcNameString;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public void setPacketLength(int packetLength) {
        this.packetLength = packetLength;
    }

    public String[] getStrArgs() {
        return this.strArgs;
    }

    public void setStrArgs(String[] strArgs) {
        this.strArgs = strArgs;
    }

    public Map<String, Object> getMapArgs() {
        return this.mapArgs;
    }

    public void setMapArgs(Map<String, Object> mapArgs) {
        this.mapArgs = mapArgs;
    }

    public P4JRpcExternalEnv getEnv() {
        return this.env;
    }

    public void setEnv(P4JRpcExternalEnv env) {
        this.env = env;
    }
}

