/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.proto;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcFlowControl {
    public static final String TRACE_PREFIX = "P4JRpcFlowCommands";
    public static final int FLUSH_CMD_LENGTH = 60;
    public static final int DEFAULT_LO_MARK = 700;
    public static final long DEFAULT_HI_MARK = 2000L;
    private long loMark = 700L;
    private long hiMark = 2000L;
    private long currentLoMark = 0L;
    private long currentHiMark = 0L;
    private P4JRpcPacketDispatcher mainDispatcher = null;
    private Properties props = null;

    public P4JRpcFlowControl(P4JRpcPacketDispatcher mainDispatcher, Properties props) {
        this.mainDispatcher = mainDispatcher;
        this.props = props;
    }

    public void processFlushCommandFromServer(P4JRpcConnection rpcConnection, P4JRpcFunctionSpec funcSpec, Map<String, Object> resultsMap) throws P4JConnectionException {
        if (rpcConnection == null) {
            throw new P4JNullPointerError("Null rpc connection passed to P4JRpcFlowControl.processFlushCommandFromServer()");
        }
        if (resultsMap == null) {
            throw new P4JNullPointerError("Null results map passed to P4JRpcFlowControl.processFlushCommandFromServer()");
        }
        if (funcSpec == null) {
            throw new P4JNullPointerError("Null function name passed to P4JRpcFlowControl.processFlushCommandFromServer()");
        }
        if (funcSpec == P4JRpcFunctionSpec.PROTOCOL_FLUSH1) {
            try {
                String seqNumStr = (String)resultsMap.get("fseq");
                String hwmStr = (String)resultsMap.get("himark");
                P4JTracer.superfine("P4JRpcFlowCommands.processFlushCommandFromServer: seqNum / hwm seen: " + seqNumStr + " " + hwmStr);
                long seqNum = new Long(seqNumStr);
                long hwm = new Long(hwmStr);
                this.sendFlush2(rpcConnection, seqNum, hwm);
            }
            catch (Exception exc) {
                P4JLog.exception(exc);
                throw new P4JProtocolError("Format error in P4JRpcFlowControl.processFlushCommandFromServer");
            }
        } else {
            if (funcSpec == P4JRpcFunctionSpec.PROTOCOL_FLUSH2) {
                throw new P4JUnimplementedError("Unimplemented flush2 handler!");
            }
            throw new P4JProtocolError("Unexpected flow command in processFlushCommandFromServer: '" + (Object)((Object)funcSpec) + "'");
        }
    }

    public void sendFlush1(P4JRpcConnection rpcConnection, long seqNum, long hwm) {
        if (rpcConnection == null) {
            throw new P4JNullPointerError("Null rpc connection passed to P4JRpcFlowCommands.sendFlush1()");
        }
        P4JTracer.coarse("P4JRpcFlowCommandssending flush1; seq: " + seqNum + "hwm: " + hwm);
        HashMap<String, Object> flushMap = new HashMap<String, Object>(2);
        flushMap.put("himark", "" + hwm);
        flushMap.put("fseq", "" + seqNum);
        P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_FLUSH1, flushMap, null);
    }

    public void sendFlush2(P4JRpcConnection rpcConnection, long seqNum, long hwm) throws P4JConnectionException {
        if (rpcConnection == null) {
            throw new P4JNullPointerError("Null rpc connection passed to P4JRpcFlowCommands.sendFlush2()");
        }
        P4JTracer.coarse("P4JRpcFlowCommandssending flush2; seq: " + seqNum + "hwm: " + hwm);
        HashMap<String, Object> flushMap = new HashMap<String, Object>(2);
        flushMap.put("himark", "" + hwm);
        flushMap.put("fseq", "" + seqNum);
        P4JRpcPacket flush2Packet = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_FLUSH2, flushMap, null);
        rpcConnection.putRpcPacket(flush2Packet);
    }

    public void incrementCurrentHiMark(int incr) {
        this.currentHiMark += (long)incr;
    }

    public void decrementCurrentHiMark(int decr) {
        this.currentHiMark -= (long)decr;
    }

    public long getLoMark() {
        return this.loMark;
    }

    public void setLoMark(long loMark) {
        this.loMark = loMark;
    }

    public long getHiMark() {
        return this.hiMark;
    }

    public void setHiMark(long hiMark) {
        this.hiMark = hiMark;
    }

    public long getCurrentLoMark() {
        return this.currentLoMark;
    }

    public void setCurrentLoMark(long currentLoMark) {
        this.currentLoMark = currentLoMark;
    }

    public long getCurrentHiMark() {
        return this.currentHiMark;
    }

    public void setCurrentHiMark(long currentHiMark) {
        this.currentHiMark = currentHiMark;
    }
}

