/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JCharsetConverter;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JClientError;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.P4JRpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.P4JRpcSysFileHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcClientSystemFileCommands {
    public static final String TRACE_PREFIX = "P4JRpcClientSystemFileCommands";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String PERMS_RW = "rw";
    protected static final String FILE_DELETE_ON_ERR_KEY = "deleteOnError";
    protected static final String FILE_OPEN_PATH_KEY = "openFilePath";
    protected static final String FILE_OPEN_TARGET_FILE_KEY = "targetFile";
    protected static final String FILE_OPEN_TMP_FILE_KEY = "tmpFile";
    protected static final String FILE_OPEN_TMP_STREAM_KEY = "tmpFileStream";
    protected static final String FILE_OPEN_TARGET_STREAM_KEY = "targetFileStream";
    protected static final String FILE_OPEN_ORIG_ARGS_KEY = "origArgs";
    protected static final String FILE_OPEN_MODTIME_KEY = "modTime";
    private Properties props = null;
    private String tmpDirName = null;
    private P4JSystemFileCommandsHelper fileCommands = P4JRpcSysFileHelper.getSysFileCommands();

    protected P4JRpcClientSystemFileCommands(Properties props) {
        this.props = props;
        this.tmpDirName = P4JRpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            P4JLog.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult chmodFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String path = (String)resultsMap.get("path");
        String perms = (String)resultsMap.get("perms");
        String fileTypeStr = (String)resultsMap.get("type");
        String time = (String)resultsMap.get("time");
        P4JTracer.fine("P4JRpcClientSystemFileCommands.chmodFile: path: " + path);
        try {
            cmdEnv.newHandler();
            P4JRpcPerforceFile targetFile = new P4JRpcPerforceFile(path, fileTypeStr);
            P4JRpcPerforceFileType fileType = null;
            if (targetFile.exists()) {
                if (time != null) {
                    P4JTracer.superfine("P4JRpcClientSystemFileCommands.chmodFile: new mod time: " + time);
                    targetFile.setLastModified(new Long(time));
                }
                if (perms != null) {
                    P4JTracer.superfine("P4JRpcClientSystemFileCommands.chmodFile: new perms: " + perms);
                    if (perms.equalsIgnoreCase(PERMS_RW)) {
                        this.fileCommands.setWritable(path, true);
                    } else {
                        this.fileCommands.setWritable(path, false);
                    }
                }
                if (fileTypeStr != null && (fileType = P4JRpcPerforceFileType.decodeFromServerString(fileTypeStr)) != null) {
                    switch (fileType) {
                        case FST_XTEXT: 
                        case FST_XBINARY: {
                            this.fileCommands.setExecutable(path, true, true);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new P4JProtocolError("Unexpected conversion error in P4JRpcClientSystemFileCommands.chmodFile: " + nfe.getLocalizedMessage());
        }
        catch (Exception exc) {
            P4JTracer.coarse("P4JRpcClientSystemFileCommands.chmodFile: saw exception: " + exc.getLocalizedMessage());
            P4JLog.exception(exc);
            throw new P4JConnectionException(exc.getLocalizedMessage(), exc);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult openFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String path = (String)resultsMap.get("path");
        String clientHandle = (String)resultsMap.get("handle");
        String modTime = (String)resultsMap.get("time");
        String noClobber = (String)resultsMap.get("noclobber");
        String perms = (String)resultsMap.get("perms");
        String fileType = (String)resultsMap.get("type");
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.openFile: " + path);
        try {
            String tmpFileName;
            P4JRpcPerforceFile targetFile = new P4JRpcPerforceFile(path, fileType);
            P4JRpcPerforceFile tmpFile = null;
            P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
                p4JRpcCommandEnv.getClass();
                handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler(clientHandle, false, targetFile);
                cmdEnv.addHandler(handler);
            } else {
                handler.getMap().remove(FILE_OPEN_TMP_FILE_KEY);
                handler.getMap().remove(FILE_OPEN_TMP_STREAM_KEY);
                handler.getMap().remove(FILE_OPEN_MODTIME_KEY);
            }
            handler.setError(false);
            handler.getMap().put(FILE_OPEN_ORIG_ARGS_KEY, resultsMap);
            handler.getMap().put(FILE_OPEN_MODTIME_KEY, modTime);
            if (targetFile.exists() && targetFile.isFile() && noClobber != null && targetFile.canWrite()) {
                cmdEnv.getHandler(clientHandle).setError(true);
                cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CLOBBER, 3, 34, new String[]{path}).toMap());
                return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (P4JRpcPerforceFileType.decodeFromServerString(fileType) == P4JRpcPerforceFileType.FST_SYMLINK) {
                cmdEnv.getHandler(clientHandle).setError(true);
                cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", path}).toMap());
                return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (targetFile.exists() && targetFile.isFile()) {
                tmpFileName = P4JRpcPerforceFile.createTempFileName(this.tmpDirName);
                tmpFile = new P4JRpcPerforceFile(tmpFileName, fileType);
                tmpFile.deleteOnExit();
                handler.getMap().put(FILE_OPEN_TMP_FILE_KEY, tmpFile);
                if (perms != null && perms.equalsIgnoreCase(PERMS_RW)) {
                    this.fileCommands.setWritable(tmpFileName, true);
                }
            } else if (!targetFile.exists()) {
                if (!this.mkdirs(targetFile)) {
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{path}).toMap());
                    return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                try {
                    if (!targetFile.createNewFile()) {
                        P4JTracer.coarse("P4JRpcClientSystemFileCommands.openFile: unable to create new target file");
                    }
                    if (!targetFile.canCopyAsIs()) {
                        tmpFileName = P4JRpcPerforceFile.createTempFileName(this.tmpDirName);
                        tmpFile = new P4JRpcPerforceFile(tmpFileName, fileType);
                        tmpFile.deleteOnExit();
                        handler.getMap().put(FILE_OPEN_TMP_FILE_KEY, tmpFile);
                    }
                }
                catch (IOException ioexc) {
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{path, ioexc.getLocalizedMessage()}).toMap());
                    return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
                }
            }
            handler.getMap().put(FILE_OPEN_TARGET_FILE_KEY, targetFile);
            if (perms != null && perms.equalsIgnoreCase(PERMS_RW)) {
                this.fileCommands.setWritable(path, true);
            }
            if (fileType != null && P4JRpcPerforceFileType.decodeFromServerString(fileType).isExecutable()) {
                this.fileCommands.setExecutable(path, true, true);
            }
            if (tmpFile != null) {
                P4JRpcOutputStream tmpStream = new P4JRpcOutputStream(tmpFile, rpcConnection.getClientCharset());
                handler.getMap().put(FILE_OPEN_TMP_STREAM_KEY, tmpStream);
            } else if (targetFile != null) {
                P4JRpcOutputStream targetStream = new P4JRpcOutputStream(targetFile, rpcConnection.getClientCharset());
                handler.getMap().put(FILE_OPEN_TARGET_STREAM_KEY, targetStream);
            }
        }
        catch (P4JError p4je) {
            throw p4je;
        }
        catch (Exception exc) {
            P4JLog.exception(exc);
            throw new P4JError("Unexpected exception in P4JRpcClientSystemFileCommands.openFile: " + exc.getLocalizedMessage() + exc, exc);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult writeFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.writeFile");
        String clientHandle = (String)resultsMap.get("handle");
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            throw new P4JNullPointerError("Null client handler in writeFile");
        }
        if (handler.isError()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new P4JNullPointerError("Null state map in P4JRpcClientSystemFileCommands.writeFile()");
        }
        P4JRpcOutputStream outStream = (P4JRpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        if (outStream == null) {
            outStream = (P4JRpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        }
        if (outStream == null) {
            throw new P4JError("No open file stream in P4JRpcClientSystemFileCommands.writeFile()");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                outStream.write(resultsMap);
            } else {
                P4JLog.error("output stream unexpectedly closed in writeFile");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            String path = (String)handler.getMap().get("path");
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path, ioexc.getLocalizedMessage()}).toMap());
            P4JLog.error("failed write for file " + (path == null ? "<unknown>" : path) + "; exception follows...");
            P4JLog.exception(ioexc);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void writeToStream(byte[] sourceBytes, int start, int length, OutputStream stream) throws IOException {
        if (P4JClientLineEnding.CONVERT_TEXT) {
            for (int i = start; i < length; ++i) {
                if (sourceBytes[i] == P4JClientLineEnding.FST_L_LF_BYTES[0]) {
                    stream.write(P4JClientLineEnding.FST_L_LOCAL_BYTES);
                    continue;
                }
                stream.write(sourceBytes[i]);
            }
        } else {
            stream.write(sourceBytes, start, length);
        }
    }

    private void translate(byte[] sourceBytes, P4JCharsetConverter converter, int length, OutputStream stream) throws IOException {
        int start = 0;
        if (P4JClientLineEnding.CONVERT_TEXT) {
            ByteArrayOutputStream converted = new ByteArrayOutputStream();
            this.writeToStream(sourceBytes, start, length, converted);
            sourceBytes = converted.toByteArray();
            start = 0;
            length = sourceBytes.length;
        }
        ByteBuffer from = ByteBuffer.wrap(sourceBytes);
        if (length > 0) {
            ByteBuffer converted = converter.convert(from);
            if (converted != null) {
                sourceBytes = converted.array();
                start = converted.position();
                length = converted.limit();
            }
        } else {
            byte[] underflow = converter.clearUnderflow();
            if (underflow != null) {
                ByteBuffer converted = converter.convert(ByteBuffer.wrap(underflow));
                if (converted != null) {
                    sourceBytes = converted.array();
                    start = converted.position();
                    length = converted.limit();
                }
                if (converter.clearUnderflow() != null) {
                    throw new P4JClientError("Translation of text output failed to charset " + converter.getToCharsetName());
                }
            }
        }
        if (length > 0) {
            stream.write(sourceBytes, start, length);
        }
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult writeText(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String trans = (String)resultsMap.get("trans");
        if (trans != null && !trans.equalsIgnoreCase("no")) {
            throw new P4JError("trans arg not 'no' or null in writeText: " + trans);
        }
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.writeText");
        String handlerName = "writeText";
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler("writeText");
        if (handler == null) {
            P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
            p4JRpcCommandEnv.getClass();
            handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler("writeText", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        P4JRpcOutputStream outStream = (P4JRpcOutputStream)stateMap.get("");
        if (outStream == null) {
            throw new P4JNullPointerError("Null output stream in writeText state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                byte[] sourceBytes = (byte[])resultsMap.get("data");
                int len = sourceBytes.length;
                int start = 0;
                if (trans == null) {
                    P4JCharsetConverter converter = (P4JCharsetConverter)stateMap.get("RPC_TMP_CONVERTER_KEY");
                    if (converter == null) {
                        Charset charset = rpcConnection.getClientCharset();
                        for (Map<String, Object> map : cmdEnv.getResultsMapVec()) {
                            String type;
                            if (!map.containsKey("type") || !"utf16".equals(type = map.get("type").toString())) continue;
                            charset = P4JCharset.UTF16;
                            break;
                        }
                        if (charset != P4JCharset.UTF8) {
                            converter = new P4JCharsetConverter(P4JCharset.UTF8, charset);
                            stateMap.put("RPC_TMP_CONVERTER_KEY", converter);
                        }
                    }
                    if (converter != null) {
                        this.translate(sourceBytes, converter, len, outStream);
                    } else {
                        this.writeToStream(sourceBytes, start, len, outStream);
                    }
                } else if (len > 0) {
                    this.writeToStream(sourceBytes, start, len, outStream);
                }
            } else {
                P4JLog.error("output stream unexpectedly closed in writeText");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult writeBinary(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.writeBinary");
        String handlerName = "writeBinary";
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler("writeBinary");
        if (handler == null) {
            P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
            p4JRpcCommandEnv.getClass();
            handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler("writeBinary", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        P4JRpcOutputStream outStream = (P4JRpcOutputStream)stateMap.get("");
        if (outStream == null) {
            throw new P4JNullPointerError("Null output stream in writeBinary state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                outStream.write(resultsMap);
            } else {
                P4JLog.error("output stream unexpectedly closed in writeBinary");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult closeFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.closeFile");
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        String commit = (String)resultsMap.get("commit");
        String clientHandle = (String)resultsMap.get("handle");
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            throw new P4JNullPointerError("Null client handler in writeFile");
        }
        if (handler.isError()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new P4JNullPointerError("Null state map in P4JRpcClientSystemFileCommands.writeFile()");
        }
        P4JRpcOutputStream tmpStream = (P4JRpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        P4JRpcOutputStream targetStream = (P4JRpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        P4JRpcPerforceFile tmpFile = (P4JRpcPerforceFile)handler.getMap().get(FILE_OPEN_TMP_FILE_KEY);
        P4JRpcPerforceFile targetFile = (P4JRpcPerforceFile)handler.getMap().get(FILE_OPEN_TARGET_FILE_KEY);
        if (targetFile == null) {
            throw new P4JNullPointerError("Null target file P4JRpcClientSystemFileCommands.closeFile() state map");
        }
        if (commit != null) {
            Map origArgs = (Map)handler.getMap().get(FILE_OPEN_ORIG_ARGS_KEY);
            if (origArgs == null) {
                throw new P4JNullPointerError("Null original argument map P4JRpcClientSystemFileCommands.closeFile() state map");
            }
            String perms = (String)origArgs.get("perms");
            String modTimeStr = null;
            if (handler.getMap().containsKey(FILE_OPEN_MODTIME_KEY)) {
                modTimeStr = (String)handler.getMap().get(FILE_OPEN_MODTIME_KEY);
            }
            try {
                if (tmpStream != null) {
                    try {
                        tmpStream.flush();
                    }
                    catch (IOException e) {
                        P4JLog.error("Flushing stream failed in closeFile(); tmp file: " + tmpFile.getName());
                    }
                    P4JTracer.fine("P4JRpcClientSystemFileCommands.closeFile: using tmp stream");
                    if (tmpFile == null) {
                        throw new P4JNullPointerError("Null tmp file P4JRpcClientSystemFileCommands.writeFile() state map");
                    }
                    if (!tmpFile.renameTo(targetFile)) {
                        P4JLog.error("Rename failed completely in closeFile(); tmp file: " + tmpFile.getName() + "; target file: " + targetFile.getName());
                    }
                } else {
                    P4JTracer.fine("P4JRpcClientSystemFileCommands.closeFile: using target stream");
                }
                if (modTimeStr != null) {
                    try {
                        long modTime = new Long(modTimeStr);
                        if (modTime > 0L) {
                            targetFile.setLastModified(modTime * 1000L);
                        }
                    }
                    catch (Exception exc) {
                        P4JLog.warn("Unable to set target file modification time: " + exc);
                    }
                }
                if (perms.equalsIgnoreCase(PERMS_RW)) {
                    this.fileCommands.setWritable(targetFile.getPath(), true);
                } else {
                    P4JTracer.fine("P4JRpcClientSystemFileCommands.closeFile: setting target read-only");
                    this.fileCommands.setWritable(targetFile.getPath(), false);
                }
                if (targetFile.getFileType().isExecutable()) {
                    this.fileCommands.setExecutable(targetFile.getPath(), true, true);
                }
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (tmpStream != null) {
                        tmpStream.close();
                    }
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
                catch (IOException ioexc) {
                    P4JLog.warn("file close error in closeFile(): " + ioexc.getLocalizedMessage());
                }
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    P4JLog.warn("Unable to delete tmp file: " + tmpFile.getPath() + " (unknown cause)");
                }
                throw throwable;
            }
            try {
                if (tmpStream != null) {
                    tmpStream.close();
                }
                if (targetStream != null) {
                    targetStream.close();
                }
            }
            catch (IOException ioexc) {
                P4JLog.warn("file close error in closeFile(): " + ioexc.getLocalizedMessage());
            }
            if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                P4JLog.warn("Unable to delete tmp file: " + tmpFile.getPath() + " (unknown cause)");
            }
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult moveFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        boolean caseSensitive;
        String clientPath = (String)resultsMap.get("path");
        String targetPath = (String)resultsMap.get("path2");
        String type = (String)resultsMap.get("type");
        String targetType = (String)resultsMap.get("type2");
        String clientHandle = (String)resultsMap.get("handle");
        String confirm = (String)resultsMap.get("confirm");
        String rmdir = (String)resultsMap.get("rmdir");
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.moveFile:");
        P4JTracer.fine("P4JRpcClientSystemFileCommands.moveFile: from: " + clientPath + "; to: " + targetPath);
        P4JRpcPerforceFile fromFile = new P4JRpcPerforceFile(clientPath, type);
        P4JRpcPerforceFile toFile = new P4JRpcPerforceFile(targetPath, targetType);
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
            p4JRpcCommandEnv.getClass();
            handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler(clientHandle, false, toFile);
            cmdEnv.addHandler(handler);
        }
        handler.setError(false);
        if (!fromFile.exists()) {
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean bl = caseSensitive = !cmdEnv.getServerProtocolSpecsMap().containsKey("nocase");
        if (!(!toFile.exists() || caseSensitive && clientPath.equalsIgnoreCase(targetPath))) {
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CLOBBER, 3, 34, new String[]{targetPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (!this.mkdirs(toFile)) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{targetPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (fromFile.renameTo(toFile, true)) {
            resultsMap.remove("func");
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.decode(confirm), resultsMap, null);
            rpcConnection.putRpcPacket(respPacket);
        } else {
            P4JLog.error("Rename failed completely in moveFile (cause unknown); source file: " + clientPath + "; target file: " + targetPath);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
        }
        if (rmdir != null) {
            File dir = fromFile.getParentFile();
            if (dir != null) {
                if (!dir.delete()) {
                    P4JLog.warn("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)");
                }
            } else {
                P4JLog.warn("Unable to open parent directory for delete for file '" + clientPath + "'; (no parent directory)");
            }
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult deleteFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String clientPath = (String)resultsMap.get("path");
        String noClobber = (String)resultsMap.get("noclobber");
        String rmDir = (String)resultsMap.get("rmdir");
        P4JTracer.coarse("P4JRpcClientSystemFileCommands.deleteFile:");
        P4JTracer.fine("P4JRpcClientSystemFileCommands.deleteFile path: " + clientPath);
        File file = new File(clientPath);
        if (!file.exists()) {
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (file.exists() && file.isFile() && noClobber != null && file.canWrite()) {
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CLOBBER, 3, 34, new String[]{clientPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean deleteFailed = false;
        if (!file.delete()) {
            deleteFailed = true;
            if (!file.canWrite() && this.fileCommands.setWritable(clientPath, true)) {
                boolean bl = deleteFailed = !file.delete();
            }
        }
        if (deleteFailed) {
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_DELETE_FILE, 3, 34, new String[]{clientPath}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (rmDir != null) {
            File dir = file.getParentFile();
            if (dir != null) {
                if (!dir.delete()) {
                    P4JLog.warn("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)");
                }
            } else {
                P4JLog.warn("Unable to open parent directory for delete for file '" + clientPath + "' (unknown cause)");
            }
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult checkFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        File file;
        String nType;
        P4JTracer.fine("P4JRpcClientSystemFileCommands.checkFile");
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String forceType = (String)resultsMap.get("forceType");
        String digest = (String)resultsMap.get("digest");
        String confirm = (String)resultsMap.get("confirm");
        P4JTracer.superfine("P4JRpcClientSystemFileCommands.checkFile: clientPath: " + clientPath);
        P4JTracer.superfine("P4JRpcClientSystemFileCommands.checkFile: confirm: " + confirm);
        String status = "exists";
        String string = nType = clientType == null ? "text" : clientType;
        if (clientType != null) {
            P4JTracer.superfine("P4JRpcClientSystemFileCommands.checkFile: clientType != null");
            file = new File(clientPath);
            if (!file.exists()) {
                status = "missing";
            } else if (digest != null) {
                P4JRpcMD5Digester digester = new P4JRpcMD5Digester();
                if (digester != null) {
                    Charset digestCharset = null;
                    boolean convertLineEndings = false;
                    P4JRpcPerforceFileType fileType = P4JRpcPerforceFileType.decodeFromServerString(clientType);
                    switch (fileType) {
                        case FST_UTF16: {
                            digestCharset = P4JCharset.UTF16;
                        }
                        case FST_UNICODE: {
                            if (digestCharset == null) {
                                digestCharset = rpcConnection.getClientCharset();
                            }
                        }
                        case FST_XTEXT: 
                        case FST_TEXT: {
                            convertLineEndings = true;
                        }
                    }
                    String digestStr = digester.digestFileAs32ByteHex(file, digestCharset, convertLineEndings);
                    if (digestStr != null && digestStr.equals(digest)) {
                        status = "same";
                    }
                } else {
                    P4JLog.warn("Unable to create MD5 digester for file '" + clientPath + "' in checkFile()");
                }
            }
        } else {
            P4JRpcPerforceFileType.P4JRpcServerTypeStringSpec spec;
            P4JTracer.superfine("P4JRpcClientSystemFileCommands.checkFile: clientType == null");
            file = new File(clientPath);
            if (!file.exists()) {
                status = "missing";
                cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_MISSING_ASSUMING_TYPE, 1, 34, new String[]{clientPath, nType}).toMap());
            }
            String serverXLevelStr = (String)cmdEnv.getServerProtocolSpecsMap().get("xfiles");
            int serverXLevel = 0;
            if (serverXLevelStr != null) {
                try {
                    serverXLevel = new Integer(serverXLevelStr);
                }
                catch (NumberFormatException nfe) {
                    throw new P4JProtocolError("Unexpected number conversion exception in P4JRpcClientSystemFileCommands.checkFile: " + nfe.getLocalizedMessage(), nfe);
                }
            }
            if ((spec = P4JRpcPerforceFileType.getServerFileTypeString(clientPath, P4JRpcPerforceFileType.inferFileType(file), forceType, serverXLevel)).getServerTypeString() == null) {
                cmdEnv.getResultsMapVec().add(spec.getMsg().toMap());
                return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (spec.getMsg() != null) {
                cmdEnv.getResultsMapVec().add(spec.getMsg().toMap());
            }
            nType = spec.getServerTypeString();
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", nType);
        respMap.put("status", status);
        for (String key : resultsMap.keySet()) {
            if (key == null || key.equalsIgnoreCase("func") || key.equalsIgnoreCase("type") || key.equalsIgnoreCase("status")) continue;
            respMap.put(key, resultsMap.get(key));
        }
        P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.decode(confirm), respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private boolean mkdirs(P4JRpcPerforceFile targetFile) {
        String parent = targetFile.getParent();
        if (parent != null) {
            P4JTracer.superfine("P4JRpcClientSystemFileCommands.mkdirs: creating parent directories for file " + targetFile.getPath());
            File parentDir = new File(parent);
            if (!parentDir.exists()) {
                return parentDir.mkdirs();
            }
        }
        return true;
    }
}

