/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JCharsetConverter;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JLookahead;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.P4JRpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcLineEndFilterInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.P4JRpcSysFileHelper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcClientSendFile {
    public static final String TRACE_PREFIX = "P4JRpcClientSendFile";
    public static final int DEFAULT_SENDBUF_SIZE = 1024;
    private Properties props = null;
    private P4JSystemFileCommandsHelper fileCommands = P4JRpcSysFileHelper.getSysFileCommands();

    protected P4JRpcClientSendFile(Properties props) {
        this.props = props;
    }

    private long sendRaw(InputStream stream, P4JRpcConnection connection, String handle, String write, P4JRpcMD5Digester digester) throws P4JConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = stream.read(bytes)) > 0) {
            byte[] readBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", readBytes);
            sendMap.put("handle", handle);
            P4JRpcPacket sendPacket = P4JRpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(readBytes);
        }
        return fileLength;
    }

    private P4JLookahead createLookahead(final InputStream stream, Charset charset) {
        P4JCharsetConverter newlineConverter = new P4JCharsetConverter(P4JCharset.DEFAULT, charset, true);
        ByteBuffer newlineBuffer = newlineConverter.convert(CharBuffer.wrap(new char[]{'\n'}));
        final int lookaheadLength = newlineBuffer.limit();
        P4JLookahead lookahead = new P4JLookahead(){

            public byte[] bytesToAdd(char lastDecodedChar) {
                byte[] add = null;
                if (lastDecodedChar == '\r') {
                    add = new byte[lookaheadLength];
                    try {
                        int read = stream.read(add);
                        if (read != add.length) {
                            byte[] realAdd = new byte[read];
                            System.arraycopy(add, 0, realAdd, 0, read);
                            add = realAdd;
                        }
                    }
                    catch (IOException e) {
                        add = null;
                    }
                }
                return add;
            }
        };
        return lookahead;
    }

    private long sendConverted(Charset charset, InputStream stream, P4JRpcConnection connection, String handle, String write, P4JRpcMD5Digester digester) throws P4JConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        P4JLookahead lookahead = null;
        if (P4JClientLineEnding.CONVERT_TEXT) {
            lookahead = this.createLookahead(stream, charset);
        }
        P4JCharsetConverter converter = new P4JCharsetConverter(charset, P4JCharset.UTF8);
        while ((bytesRead = stream.read(bytes)) > 0) {
            ByteBuffer inBuffer = ByteBuffer.wrap(bytes, 0, bytesRead);
            ByteBuffer converted = converter.convert(inBuffer, lookahead);
            byte[] sendBytes = converted.array();
            bytesRead = converted.limit();
            int start = converted.position();
            if (bytesRead <= 0) continue;
            if (P4JClientLineEnding.CONVERT_TEXT) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(sendBytes, 0, bytesRead);
                P4JRpcLineEndFilterInputStream lineEndStream = new P4JRpcLineEndFilterInputStream(byteStream, null);
                bytesRead = lineEndStream.read(sendBytes, 0, bytesRead);
            }
            byte[] dataBytes = new byte[bytesRead];
            System.arraycopy(sendBytes, start, dataBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", dataBytes);
            sendMap.put("handle", handle);
            P4JRpcPacket sendPacket = P4JRpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(dataBytes);
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult sendFile(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        block25: {
            cmdEnv.newHandler();
            P4JTracer.coarse("P4JRpcClientSendFile.sendFile");
            String clientPath = (String)resultsMap.get("path");
            String type = (String)resultsMap.get("type");
            String perms = (String)resultsMap.get("perms");
            String handle = (String)resultsMap.get("handle");
            String open = (String)resultsMap.get("open");
            String write = (String)resultsMap.get("write");
            String confirm = (String)resultsMap.get("confirm");
            String decline = (String)resultsMap.get("decline");
            String serverDigest = (String)resultsMap.get("serverDigest");
            String revertUnchanged = (String)resultsMap.get("revertUnchanged");
            String reopen = (String)resultsMap.get("reopen");
            P4JRpcPerforceFileType fileType = P4JRpcPerforceFileType.decodeFromServerString(type);
            P4JTracer.fine("P4JRpcClientSendFile.sendFile path:" + clientPath);
            P4JTracer.superfine("P4JRpcClientSendFile.sendFile map: " + resultsMap);
            P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(handle);
            if (handler == null) {
                P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
                p4JRpcCommandEnv.getClass();
                handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler(handle, false, null);
                cmdEnv.addHandler(handler);
            }
            handler.setError(false);
            P4JRpcPerforceFile file = null;
            InputStream inStream = null;
            P4JRpcMD5Digester digester = null;
            long fileLength = 0L;
            file = new P4JRpcPerforceFile(clientPath, fileType);
            if (!file.exists()) {
                P4JTracer.fine("P4JRpcClientSendFile.sendFile: file '" + clientPath + "' does not exist");
                handler.setError(true);
            }
            if (!handler.isError()) {
                HashMap<String, Object> respMap = new HashMap<String, Object>();
                for (String key : resultsMap.keySet()) {
                    if (key == null || key.equalsIgnoreCase("func")) continue;
                    respMap.put(key, resultsMap.get(key));
                }
                P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(open, respMap, null);
                rpcConnection.putRpcPacket(respPacket);
                P4JTracer.fine("P4JRpcClientSendFile.sendFile: writing file to server...");
                digester = new P4JRpcMD5Digester();
                Charset charset = null;
                if (P4JRpcPerforceFileType.FST_UTF16 == fileType) {
                    charset = P4JCharset.UTF16;
                } else if (P4JRpcPerforceFileType.FST_UNICODE == fileType) {
                    charset = rpcConnection.getClientCharset();
                }
                if (charset == null || charset.equals(P4JCharset.DEFAULT) || charset.equals(P4JCharset.UTF8)) {
                    inStream = new P4JRpcInputStream(file);
                    fileLength = this.sendRaw(inStream, rpcConnection, handle, write, digester);
                } else {
                    inStream = new FileInputStream(file);
                    fileLength = this.sendConverted(charset, inStream, rpcConnection, handle, write, digester);
                }
                if (!handler.isError() && perms != null && reopen == null) {
                    if (perms.equalsIgnoreCase("rw")) {
                        this.fileCommands.setWritable(clientPath, true);
                    } else {
                        this.fileCommands.setWritable(clientPath, false);
                    }
                }
            }
            String finalise = handler.isError() ? decline : confirm;
            HashMap<String, Object> finaliseMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                finaliseMap.put(key, resultsMap.get(key));
            }
            if (digester != null) {
                finaliseMap.put("digest", digester.digestAs32ByteHex());
                finaliseMap.put("fileSize", "" + fileLength);
            }
            P4JRpcPacket finalisePacket = P4JRpcPacket.constructRpcPacket(finalise, finaliseMap, null);
            rpcConnection.putRpcPacket(finalisePacket);
            Object var27_26 = null;
            try {
                if (inStream != null) {
                    inStream.close();
                }
                break block25;
            }
            catch (IOException exc2) {
                P4JTracer.coarse("Unexpected I/O exception on file close: " + exc2);
                P4JLog.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
            }
            break block25;
            {
                catch (Exception exc) {
                    P4JTracer.fine("P4JRpcClientSendFile.sendFile exception: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{clientPath, exc.getLocalizedMessage()}).toMap());
                    Object var27_27 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                        break block25;
                    }
                    catch (IOException exc2) {
                        P4JTracer.coarse("Unexpected I/O exception on file close: " + exc2);
                        P4JLog.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var27_28 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException exc2) {
                    P4JTracer.coarse("Unexpected I/O exception on file close: " + exc2);
                    P4JLog.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
                }
                throw throwable;
            }
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

