/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JNullPointerError;

public class P4JRpcClientMessage {
    private static P4JRpcClientMessage[] messages = new P4JRpcClientMessage[]{new P4JRpcClientMessage(P4JRpcClientMessageId.UNKNOWN, 0, "Unknown client error.", null), new P4JRpcClientMessage(P4JRpcClientMessageId.CONNECT_FAILED, 1, "Connect to server failed; check server URI host and port specs.", null), new P4JRpcClientMessage(P4JRpcClientMessageId.FATAL_CLIENT_ERROR, 2, "Fatal client error; disconnecting!", null), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_CLOBBER, 4, "Can't clobber writable file %file%", new String[]{"file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_CREATE_DIR, 5, "can't create directory for %file%", new String[]{"file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_EDIT_FILE_TYPE, 7, "%type% - can't edit this type of file!", new String[]{"type"}), new P4JRpcClientMessage(P4JRpcClientMessageId.OUT_OF_RESOURCES, 14, "Out of memory, network, or system resources", null), new P4JRpcClientMessage(P4JRpcClientMessageId.ASSUMING_FILE_TYPE, 30, "%file% - %type%, assuming %type2%.", new String[]{"file", "type", "type2"}), new P4JRpcClientMessage(P4JRpcClientMessageId.SUBSTITUTING_FILE_TYPE, 31, "%file% - using %type% instead of %type2%", new String[]{"file", "type", "type2"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_ADD_FILE_TYPE, 32, "%file% - %type% file can't be added.", new String[]{"file", "type"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_OVERWRITE_FILE, 34, "%file% - can't overwrite existing file.", new String[]{"file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.FILE_NONEXISTENT, 35, "%file% - file does not exist.", new String[]{"file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.FILE_SEND_ERROR, 0, "%file% - missing on client, assuming type %type%.", new String[]{"file", "type"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_DELETE_FILE, 0, "operating system will not allow deletion of file %file% on client.", new String[]{"file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_CREATE_FILE, 0, "operating system will not allow creation of file %file% on client: %reason%.", new String[]{"file", "reason"}), new P4JRpcClientMessage(P4JRpcClientMessageId.CANT_CREATE_FILE_TYPE, 0, "%type% file %file% can't be sync'd or created with this client program.", new String[]{"type", "file"}), new P4JRpcClientMessage(P4JRpcClientMessageId.FILE_WRITE_ERROR, 0, "file %file% operating system write error: %reason%.", new String[]{"file", "reason"}), new P4JRpcClientMessage(P4JRpcClientMessageId.FILE_SEND_ERROR, 0, "file send error for %file%: %reason%", new String[]{"file", "reason"}), new P4JRpcClientMessage(P4JRpcClientMessageId.FILE_MOVE_ERROR, 0, "file move error for %file%: %reason%", new String[]{"file", "reason"}), new P4JRpcClientMessage(P4JRpcClientMessageId.MERGE_MESSAGE3, 20, "Diff chunks: %yours% yours + %theirs% theirs + %both% both + %conflicting% conflicting", new String[]{"yours", "theirs", "both", "conflicting"})};
    private P4JRpcClientMessageId id = P4JRpcClientMessageId.UNKNOWN;
    private int code = 0;
    private String[] msgs = null;
    private String[] msgParamNames = null;

    public static P4JRpcClientMessage getClientMessage(P4JRpcClientMessageId id) {
        if (id == null) {
            throw new P4JNullPointerError("Null error ID spec passed to P4JRpcClientMessage.getClientMessage()");
        }
        for (P4JRpcClientMessage msg : messages) {
            if (msg.getId() != id) continue;
            return msg;
        }
        P4JLog.warn("Unmatched error ID spec in P4JRpcClientMessage.getClientMessage()");
        return messages[0];
    }

    private P4JRpcClientMessage(P4JRpcClientMessageId id, int code, String msg, String[] msgParamNames) {
        this.id = id;
        this.code = code;
        this.msgs = new String[]{msg};
        this.msgParamNames = msgParamNames;
    }

    public P4JRpcClientMessageId getId() {
        return this.id;
    }

    public void setId(P4JRpcClientMessageId id) {
        this.id = id;
    }

    public String[] getMsgs() {
        return this.msgs;
    }

    public void setMsgs(String[] msgs) {
        this.msgs = msgs;
    }

    public String[] getMsgParamNames() {
        return this.msgParamNames;
    }

    public void setMsgParamNames(String[] msgParamNames) {
        this.msgParamNames = msgParamNames;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum P4JRpcClientMessageId {
        UNKNOWN,
        CONNECT_FAILED,
        FATAL_CLIENT_ERROR,
        CANT_CLOBBER,
        CANT_CREATE_DIR,
        CANT_EDIT_FILE_TYPE,
        OUT_OF_RESOURCES,
        ASSUMING_FILE_TYPE,
        SUBSTITUTING_FILE_TYPE,
        CANT_ADD_FILE_TYPE,
        CANT_OVERWRITE_FILE,
        CANT_DELETE_FILE,
        CANT_CREATE_FILE,
        CANT_CREATE_FILE_TYPE,
        FILE_WRITE_ERROR,
        FILE_NONEXISTENT,
        FILE_MISSING_ASSUMING_TYPE,
        FILE_SEND_ERROR,
        FILE_MOVE_ERROR,
        MERGE_MESSAGE3;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum P4JRpcClientMessageType {
        UNKNOWN,
        USAGE,
        CONNECTION,
        CLIENT,
        SERVER;

    }
}

