/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMergeState;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.P4JRpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.P4JRpcSysFileHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcClientMerge {
    public static final String MARKER_ORIGINAL = ">>>> ORIGINAL ";
    public static final String MARKER_THEIRS = "==== THEIRS ";
    public static final String MARKER_YOURS = "==== YOURS ";
    public static final String MARKER_BOTH = "==== BOTH ";
    public static final String MARKER_END = "<<<<";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String TRACE_PREFIX = "P4JRpcClientMerge";
    protected static final String MERGE_STATE_KEY = "MergeState";
    protected static final String MERGE_BASE_TMP_FILE_KEY = "tmpFileBase";
    protected static final String MERGE_BASE_TMP_STREAM_KEY = "tmpFileBaseStream";
    protected static final String MERGE_THEIRS_TMP_FILE_KEY = "tmpFileTheirs";
    protected static final String MERGE_THEIRS_TMP_STREAM_KEY = "tmpFileTheirsStream";
    protected static final String MERGE_YOURS_TMP_FILE_KEY = "tmpFileYours";
    protected static final String MERGE_YOURS_TMP_STREAM_KEY = "tmpFileYoursStream";
    private Properties props = null;
    private String tmpDirName = null;
    private static final String COPY_MERGE = "copy";
    private static final String SAFE_MERGE = "safe";
    private static final String AUTO_MERGE = "auto";
    private static final String FORCE_MERGE = "force";
    private static final String MERGED_EDITED = "edit";
    private static final String MERGED_FORCE = "force";
    private static final String MERGED_YOURS = "yours";
    private static final String MERGED_THEIRS = "theirs";
    private static final String MERGED_MERGED = "merged";
    private static final String MERGE_UNFORCED = "no";
    private static final int SEL_BASE = 1;
    private static final int SEL_LEG1 = 2;
    private static final int SEL_LEG2 = 4;
    private static final int SEL_RSLT = 8;
    private static final int SEL_ALL = 15;
    private static final int SEL_CONF = 16;

    public P4JRpcClientMerge(Properties props) {
        this.props = props;
        this.tmpDirName = P4JRpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            P4JLog.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientOpenMerge3(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        P4JTracer.fine("P4JRpcClientMerge.clientOpenMerge3");
        String clientPath = (String)resultsMap.get("path");
        String handle = (String)resultsMap.get("handle");
        String resultTypeStr = (String)resultsMap.get("type2");
        String clientTypeStr = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String baseName = (String)resultsMap.get("baseName");
        String theirName = (String)resultsMap.get("theirName");
        String yourName = (String)resultsMap.get("yourName");
        String showAll = (String)resultsMap.get("showAll");
        if (resultTypeStr == null) {
            resultTypeStr = clientTypeStr;
        }
        P4JRpcClientMergeState mergeState = null;
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(handle);
        if (handler == null) {
            P4JRpcCommandEnv p4JRpcCommandEnv = cmdEnv;
            p4JRpcCommandEnv.getClass();
            handler = p4JRpcCommandEnv.new P4JRpcCommandEnv.P4JRpcHandler(handle, false, null);
            cmdEnv.addHandler(handler);
        } else {
            handler.getMap().remove(MERGE_STATE_KEY);
        }
        handler.setError(false);
        P4JRpcPerforceFileType clientType = P4JRpcPerforceFileType.decodeFromServerString(clientTypeStr);
        P4JRpcPerforceFileType resultType = P4JRpcPerforceFileType.decodeFromServerString(resultTypeStr);
        if (cmdEnv.getCmdSpec().getInMap() != null) {
            String tmpFileName = (String)cmdEnv.getCmdSpec().getInMap().get("P4JMergeTmpFile");
            mergeState = new P4JRpcClientMergeState(clientPath, true, clientType, resultType, this.tmpDirName, rpcConnection.getClientCharset());
            mergeState.setExternalTmpFilename(tmpFileName);
            mergeState.setShowAll(false);
            handler.getMap().put(MERGE_STATE_KEY, mergeState);
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        mergeState = new P4JRpcClientMergeState(clientPath, false, clientType, resultType, this.tmpDirName, rpcConnection.getClientCharset());
        handler.getMap().put(MERGE_STATE_KEY, mergeState);
        try {
            mergeState.setBaseName(baseName);
            mergeState.setTheirName(theirName);
            mergeState.setYourName(yourName);
            mergeState.openMergeFiles();
            mergeState.setShowAll(showAll != null);
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{clientPath, ioexc.getLocalizedMessage()}).toMap());
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientWriteMerge(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String handle = (String)resultsMap.get("handle");
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(handle);
        String bitsStr = (String)resultsMap.get("bits");
        byte[] data = (byte[])resultsMap.get("data");
        P4JRpcClientMergeState mergeState = null;
        int bits = 0;
        int markersInFile = 0;
        boolean needNewline = false;
        String marker = MARKER_ORIGINAL;
        if (handler == null) {
            throw new P4JNullPointerError("Null client handler in clientWriteMerge");
        }
        if (handler.isError()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        try {
            mergeState = (P4JRpcClientMergeState)handler.getMap().get(MERGE_STATE_KEY);
        }
        catch (ClassCastException cce) {
            P4JLog.error("Bad client handler class in clientWriteMerge: " + cce.getLocalizedMessage());
            P4JLog.exception(cce);
            throw new P4JNullPointerError("Bad client handler class in clientWriteMerge: " + cce.getLocalizedMessage());
        }
        if (mergeState == null) {
            throw new P4JNullPointerError("Null merge state in clientWriteMerge");
        }
        if (mergeState.isExternalStreamMerge()) {
            return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (bitsStr != null) {
            try {
                bits = new Integer(bitsStr);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in clientWriteMerge: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
                handler.setError(true);
            }
        }
        int oldBits = mergeState.getOldBits();
        try {
            if (oldBits != 0 && oldBits != bits) {
                switch (bits) {
                    case 17: {
                        mergeState.incrConflictChunks();
                    }
                    default: {
                        marker = MARKER_ORIGINAL + mergeState.getBaseName();
                        break;
                    }
                    case 10: {
                        mergeState.incrTheirChunks();
                    }
                    case 26: {
                        marker = MARKER_THEIRS + mergeState.getTheirName();
                        break;
                    }
                    case 12: {
                        mergeState.incrYourChunks();
                    }
                    case 28: {
                        marker = MARKER_YOURS + mergeState.getYourName();
                        break;
                    }
                    case 14: {
                        marker = MARKER_BOTH + mergeState.getTheirName() + " " + mergeState.getYourName();
                        mergeState.incrBothChunks();
                        break;
                    }
                    case 15: {
                        marker = MARKER_END;
                    }
                }
                if (mergeState.isShowAll() || (bits & 0x10) != 0 || bits == 15 && (oldBits & 0x10) != 0) {
                    mergeState.writeMarker(needNewline ? "\n" : "" + marker + "\n");
                    ++markersInFile;
                    if (needNewline) {
                        needNewline = false;
                    }
                }
            }
            mergeState.setOldBits(bits);
            if (data != null && data.length > 0) {
                if ((bits & 1) != 0) {
                    mergeState.writeBaseChunk(data);
                }
                if ((bits & 2) != 0) {
                    mergeState.writeTheirChunk(data);
                }
                if ((bits & 4) != 0) {
                    mergeState.writeYourChunk(data);
                }
                if ((bits & 8) != 0 || bits == 17) {
                    mergeState.writeResultChunk(data);
                }
                if (data[data.length - 1] == 10) {
                    needNewline = true;
                }
            }
        }
        catch (IOException ioexc) {
            P4JLog.error("I/O exception in clientWriteMerge: " + ioexc.getLocalizedMessage());
            P4JLog.exception(ioexc);
            handler.setError(true);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientCloseMerge(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String clientPath = (String)resultsMap.get("path");
        String handle = (String)resultsMap.get("handle");
        String mergeConfirm = (String)resultsMap.get("mergeConfirm");
        String mergeDecline = (String)resultsMap.get("mergeDecline");
        String mergePerms = (String)resultsMap.get("mergePerms");
        String mergeAuto = (String)resultsMap.get("mergeAuto");
        String mergeResponse = mergeConfirm;
        String mergeHow = null;
        String mergeForced = null;
        P4JRpcClientMergeState mergeState = null;
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(handle);
        String digest = null;
        if (handler == null) {
            throw new P4JNullPointerError("Null client handler in clientWriteMerge");
        }
        try {
            mergeState = (P4JRpcClientMergeState)handler.getMap().get(MERGE_STATE_KEY);
        }
        catch (ClassCastException cce) {
            P4JLog.error("Bad client handler class in clientCloseMerge: " + cce.getLocalizedMessage());
            P4JLog.exception(cce);
            throw new P4JNullPointerError("Bad client handler class in clientCloseMerge: " + cce.getLocalizedMessage());
        }
        if (mergeState == null) {
            throw new P4JNullPointerError("Null merge state in clientWriteMerge");
        }
        if (handler != null && handler.isError()) {
            mergeResponse = mergeDecline;
        } else {
            if (mergeState.isExternalStreamMerge()) {
                String tmpFileName = (String)cmdEnv.getCmdSpec().getInMap().get("P4JMergeTmpFile");
                if (clientPath != null && tmpFileName != null) {
                    P4JRpcPerforceFile tmpFile = new P4JRpcPerforceFile(tmpFileName, P4JRpcPerforceFileType.FST_TEXT);
                    if (!tmpFile.renameTo(new File(clientPath), true)) {
                        P4JLog.error("Rename failed completely in resolveFile (cause unknown); source file: " + clientPath + "; target file: " + tmpFileName);
                        cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
                        mergeResponse = mergeDecline;
                    } else {
                        if (mergePerms != null) {
                            P4JSystemFileCommandsHelper fileCommands = P4JRpcSysFileHelper.getSysFileCommands();
                            if (mergePerms.equalsIgnoreCase("rw")) {
                                fileCommands.setWritable(clientPath, true);
                            } else {
                                fileCommands.setWritable(clientPath, false);
                            }
                        }
                        digest = new P4JRpcMD5Digester().digestFileAs32ByteHex(tmpFile, rpcConnection.getClientCharset(), true);
                        mergeHow = MERGED_EDITED;
                    }
                }
            } else {
                P4JSystemFileCommandsHelper fileCommands;
                ResolveChoice autoChoice = this.autoResolve(mergeState, mergeAuto);
                if (mergePerms != null && !(fileCommands = P4JRpcSysFileHelper.getSysFileCommands()).setWritable(clientPath, true)) {
                    P4JLog.warn("Unable to set merge target '" + clientPath + "' permissions to writable; merge results should not be affected");
                }
                switch (autoChoice) {
                    case SKIP: {
                        mergeResponse = mergeDecline;
                        break;
                    }
                    case YOURS: {
                        mergeHow = MERGED_YOURS;
                        digest = mergeState.getYourDigestString();
                        break;
                    }
                    case THEIRS: {
                        mergeHow = MERGED_THEIRS;
                        mergeForced = MERGE_UNFORCED;
                        digest = mergeState.getTheirDigestString();
                        break;
                    }
                    case MERGED: {
                        mergeHow = MERGED_MERGED;
                        digest = mergeState.getMergeDigestString();
                        break;
                    }
                    case EDIT: {
                        mergeHow = MERGED_EDITED;
                        break;
                    }
                    default: {
                        mergeResponse = mergeDecline;
                    }
                }
                try {
                    if (!mergeState.finishMerge(autoChoice)) {
                        P4JLog.error("Rename failed completely in resolveFile (cause unknown); source file: " + clientPath + "; target file: " + clientPath);
                        cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
                        mergeResponse = mergeDecline;
                    } else {
                        cmdEnv.getResultsMapVec().add(new P4JRpcMessage(P4JRpcClientMessage.P4JRpcClientMessageId.MERGE_MESSAGE3, 1, 34, new String[]{"" + mergeState.getYourChunks(), "" + mergeState.getTheirChunks(), "" + mergeState.getBothChunks(), "" + mergeState.getConflictChunks()}).toMap());
                    }
                }
                catch (IOException exc) {
                    mergeResponse = mergeDecline;
                    P4JLog.error("Unexpected I/O exception in closeMerge: " + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                }
                if (mergePerms != null && !(fileCommands = P4JRpcSysFileHelper.getSysFileCommands()).setWritable(clientPath, mergePerms.equalsIgnoreCase("rw"))) {
                    P4JLog.warn("Unable to set merge target '" + clientPath + "' permissions back after merge; merge results should not be affected");
                }
            }
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            if (mergeHow != null) {
                respMap.put("mergeHow", mergeHow);
            }
            if (mergeForced != null) {
                respMap.put("force", mergeForced);
            }
            if (digest != null) {
                respMap.put("digest", digest);
            }
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func") || key.equalsIgnoreCase("type") || key.equalsIgnoreCase("status")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.decode(mergeResponse), respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private ResolveChoice autoResolve(P4JRpcClientMergeState mergeState, String mergeAuto) {
        int conflictChunks = mergeState.getConflictChunks();
        int theirChunks = mergeState.getTheirChunks();
        int yourChunks = mergeState.getYourChunks();
        boolean safeMerge = false;
        boolean autoMerge = false;
        boolean forceMerge = false;
        if (mergeAuto != null) {
            if (mergeAuto.equalsIgnoreCase(SAFE_MERGE)) {
                safeMerge = true;
            } else if (mergeAuto.equalsIgnoreCase("force")) {
                forceMerge = true;
            } else if (mergeAuto.equalsIgnoreCase(AUTO_MERGE)) {
                autoMerge = true;
            }
        }
        if (conflictChunks > 0) {
            if (forceMerge) {
                return ResolveChoice.EDIT;
            }
            return ResolveChoice.SKIP;
        }
        if (theirChunks == 0) {
            return ResolveChoice.YOURS;
        }
        if (yourChunks == 0) {
            return ResolveChoice.THEIRS;
        }
        if (safeMerge) {
            return ResolveChoice.SKIP;
        }
        if (forceMerge || autoMerge) {
            return ResolveChoice.MERGED;
        }
        return ResolveChoice.SKIP;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResolveChoice {
        SKIP,
        YOURS,
        THEIRS,
        EDIT,
        MERGED;

    }
}

