/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMerge;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientSendFile;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientSystemFileCommands;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientUserInteraction;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.server.callback.P4JProgressCallback;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcClientFunctionDispatcher {
    public static final String TRACE_PREFIX = "P4JRpcClientCommandDispatcher";
    private P4JRpcPacketDispatcher mainDispatcher = null;
    private P4JRpcClientUserInteraction userInteractor = null;
    private P4JRpcClientSystemFileCommands fileCommands = null;
    private P4JRpcClientSendFile fileSender = null;
    private P4JRpcClientMerge clientMerger = null;
    private Properties props = null;

    public P4JRpcClientFunctionDispatcher(P4JRpcPacketDispatcher mainDispatcher, Properties props, P4JRpcServerImpl server) {
        if (mainDispatcher == null) {
            throw new P4JNullPointerError("Null main dispatcher passed to P4JRpcClientCommandDispatcher constructor");
        }
        this.props = props;
        this.mainDispatcher = mainDispatcher;
        this.userInteractor = new P4JRpcClientUserInteraction(this.props, server);
        this.fileCommands = new P4JRpcClientSystemFileCommands(this.props);
        this.fileSender = new P4JRpcClientSendFile(this.props);
        this.clientMerger = new P4JRpcClientMerge(this.props);
    }

    public P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult dispatch(P4JRpcPacketDispatcher.P4JRpcPacketDispatcherMode dispatchMode, P4JRpcFunctionSpec funcSpec, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.NONE;
        P4JRpcConnection rpcConnection = cmdEnv.getRpcConnection();
        if (funcSpec == null) {
            throw new P4JNullPointerError("Null function spec passed to P4JRpcClientCommandDispatcher.dispatch()");
        }
        if (cmdEnv == null) {
            throw new P4JNullPointerError("Null command environment passed to P4JRpcClientCommandDispatcher.dispatch()");
        }
        P4JTracer.fine("P4JRpcClientCommandDispatcher.dispatch: function: " + funcSpec.toString().toLowerCase());
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        P4JProgressCallback progressCallback = cmdEnv.getProgressCallback();
        boolean keepGoing = cmdEnv.isUserCanceled();
        if (progressCallback != null && keepGoing) {
            keepGoing = this.reportClientProgress(progressCallback, cmdCallBackKey, funcSpec, cmdEnv, resultsMap);
        }
        if (!keepGoing) {
            cmdEnv.setUserCanceled(true);
        }
        switch (funcSpec) {
            case CLIENT_MESSAGE: 
            case CLIENT_FSTATINFO: {
                cmdEnv.getResultsMapVec().add(resultsMap);
                result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case CLIENT_PROMPT: {
                result = this.userInteractor.clientPrompt(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SETPASSWORD: {
                result = this.userInteractor.clientSetPassword(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CRYPTO: {
                result = this.userInteractor.clientCrypto(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHMODFILE: {
                result = this.fileCommands.chmodFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENFILE: {
                result = this.fileCommands.openFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHECKFILE: {
                result = this.fileCommands.checkFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_WRITEFILE: {
                result = this.fileCommands.writeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEFILE: {
                result = this.fileCommands.closeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_ACK: {
                result = this.userInteractor.clientAck(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_INPUTDATA: {
                result = this.userInteractor.clientInputData(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SENDFILE: {
                result = this.fileSender.sendFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_DELETEFILE: {
                result = this.fileCommands.deleteFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTBINARY: {
                result = this.fileCommands.writeBinary(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTTEXT: {
                result = this.fileCommands.writeText(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_MOVEFILE: {
                result = this.fileCommands.moveFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENMERGE3: {
                result = this.clientMerger.clientOpenMerge3(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_WRITEMERGE: {
                result = this.clientMerger.clientWriteMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEMERGE: {
                result = this.clientMerger.clientCloseMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SSO: {
                result = this.userInteractor.clientSingleSignon(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            default: {
                P4JLog.error("Unimplemented function spec in P4JRpcClientCommandDispatcher.dispatch(): '" + funcSpec.toString() + "'");
                throw new P4JError("Unimplemented function spec in P4JRpcClientCommandDispatcher.dispatch(): '" + funcSpec.toString() + "'");
            }
        }
        return result;
    }

    protected boolean reportClientProgress(P4JProgressCallback progressCallback, int cmdCallBackKey, P4JRpcFunctionSpec funcSpec, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) {
        String FSTAT_NAME = "fstat";
        String FILES_NAME = "files";
        String UNKNOWN_NAME = "unknown";
        String JOBS_NAME = "jobs";
        String CHANGES_NAME = "changes";
        if (resultsMap != null) {
            String tickMarker = this.getTickMarker(resultsMap);
            String cmdName = cmdEnv.getCmdSpec().getCmdName();
            if (cmdName == null) {
                cmdName = "unknown";
            }
            switch (funcSpec) {
                case CLIENT_FSTATINFO: {
                    if (!cmdName.equalsIgnoreCase("fstat") && !cmdName.equalsIgnoreCase("files") && !cmdName.equalsIgnoreCase("jobs") && !cmdName.equalsIgnoreCase("changes")) break;
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
                case CLIENT_OPENFILE: 
                case CLIENT_SENDFILE: 
                case CLIENT_OUTPUTBINARY: 
                case CLIENT_OUTPUTTEXT: {
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
            }
        }
        return true;
    }

    private String getTickMarker(Map<String, Object> resultsMap) {
        String CHANGE_PFX = "changelist ";
        String CHANGE_KEY = "change";
        String JOB_KEY = "Job";
        String tickMarker = null;
        if (resultsMap != null) {
            tickMarker = (String)resultsMap.get("path");
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("clientFile");
            }
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("depotFile");
            }
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("Job");
            }
            if (tickMarker == null) {
                tickMarker = "changelist " + (String)resultsMap.get("change");
            }
        }
        return tickMarker;
    }
}

