/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.connection;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnectionFlowControl;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;

public abstract class P4JRpcConnection {
    public static final String TRACE_PREFIX = "P4JRpcConnection";
    public static final Charset UNICODE_SERVER_CHARSET = P4JCharset.UTF8;
    public static final String UNICODE_SERVER_CHARSET_NAME = P4JCharset.UTF8_NAME;
    public static final Charset NON_UNICODE_SERVER_CHARSET = P4JCharset.DEFAULT;
    public static final String NON_UNICODE_SERVER_CHARSET_NAME = P4JCharset.DEFAULT_NAME;
    protected Properties props = null;
    protected P4JRpcConnectionFlowControl flowController = new P4JRpcConnectionFlowControl();
    protected P4JRpcServerStats stats = null;
    protected Charset clientCharset = null;
    protected String hostName = null;
    protected int hostPort = 0;
    protected boolean usingCompression = false;
    protected boolean isUnicodeServer = false;

    public P4JRpcConnection(String serverHost, int serverPort, Properties props, P4JRpcServerStats stats, Charset clientCharset) throws P4JConnectionException {
        this.hostName = serverHost;
        this.hostPort = serverPort;
        this.clientCharset = clientCharset == null ? P4JCharset.DEFAULT : clientCharset;
        this.stats = stats == null ? new P4JRpcServerStats() : stats;
        this.props = props == null ? new Properties() : props;
        stats.serverConnections.incrementAndGet();
        this.isUnicodeServer = clientCharset != null;
    }

    public abstract void disconnect() throws P4JConnectionException;

    public abstract long putRpcPacket(P4JRpcPacket var1) throws P4JConnectionException;

    public abstract long putRpcPackets(P4JRpcPacket[] var1) throws P4JConnectionException;

    public abstract P4JRpcPacket getRpcPacket() throws P4JConnectionException;

    public abstract int getSystemSendBufferSize();

    public abstract int getSystemRecvBufferSize();

    public byte[] marshalPacketField(String key, Object value) {
        byte[] retBytes = null;
        byte[] keyBytes = null;
        byte[] valBytes = null;
        byte[] valLengthBytes = null;
        if (key != null) {
            keyBytes = this.getNormalizedBytes(key);
        }
        valLengthBytes = P4JRpcPacket.encodeInt4((valBytes = this.marshalPacketValue(value)) == null ? 0 : valBytes.length);
        int fieldLength = 2 + (keyBytes == null ? 0 : keyBytes.length) + valLengthBytes.length + (valBytes == null ? 0 : valBytes.length);
        retBytes = new byte[fieldLength];
        int retBytesPos = 0;
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, retBytes, retBytesPos, keyBytes.length);
            retBytesPos += keyBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        System.arraycopy(valLengthBytes, 0, retBytes, retBytesPos, valLengthBytes.length);
        retBytesPos += valLengthBytes.length;
        if (valBytes != null) {
            System.arraycopy(valBytes, 0, retBytes, retBytesPos, valBytes.length);
            retBytesPos += valBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        return retBytes;
    }

    protected byte[] marshalPacketValue(Object value) {
        byte[] valBytes;
        block7: {
            valBytes = null;
            try {
                if (value == null) break block7;
                if (value.getClass() == String.class) {
                    valBytes = this.getNormalizedBytes((String)value);
                    break block7;
                }
                if (value instanceof byte[]) {
                    valBytes = (byte[])value;
                    break block7;
                }
                if (value instanceof StringBuffer) {
                    valBytes = this.getNormalizedBytes(((StringBuffer)value).toString());
                    break block7;
                }
                if (value instanceof ByteBuffer) {
                    int valLength = ((ByteBuffer)value).limit();
                    valBytes = new byte[valLength];
                    ((ByteBuffer)value).get(valBytes);
                    break block7;
                }
                throw new P4JError("Unmarshalable value in P4JRpcStreamConnection.marshal; type: " + value.getClass().getCanonicalName());
            }
            catch (P4JError p4jerr) {
                throw p4jerr;
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in P4JRpcStreamConnection.marshalValue: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
                throw new P4JError("Unexpected exception in P4JRpcStreamConnection.marshalValue: " + thr.getLocalizedMessage());
            }
        }
        return valBytes;
    }

    public void useConnectionCompression() throws P4JConnectionException {
        P4JTracer.fine("P4JRpcConnection: setting connection compression true");
        if (this.usingCompression) {
            throw new P4JProtocolError("attempted to set connection compression on when it's already on...");
        }
        this.usingCompression = true;
    }

    protected byte[] getNormalizedBytes(String str) {
        if (str == null) {
            throw new P4JNullPointerError("null string passed to P4JRpcConnection.getNormalizedBytes");
        }
        try {
            if (this.isUnicodeServer) {
                return str.getBytes(UNICODE_SERVER_CHARSET_NAME);
            }
            return str.getBytes(NON_UNICODE_SERVER_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            P4JLog.exception(e);
            return null;
        }
    }

    protected String getNormalizedString(byte[] bytes) {
        if (bytes == null) {
            throw new P4JNullPointerError("null bytes passed to P4JRpcConnection.getNormalizedString");
        }
        try {
            if (this.isUnicodeServer) {
                return new String(bytes, UNICODE_SERVER_CHARSET_NAME);
            }
            return new String(bytes, NON_UNICODE_SERVER_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            P4JLog.exception(e);
            return null;
        }
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    public P4JRpcConnectionFlowControl getFlowController() {
        return this.flowController;
    }

    public void setFlowController(P4JRpcConnectionFlowControl flowController) {
        this.flowController = flowController;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Charset getClientCharset() {
        return this.clientCharset;
    }

    public void setClientCharset(Charset charset) {
        this.clientCharset = charset;
        this.isUnicodeServer = this.clientCharset != null;
    }

    public P4JRpcServerStats getStats() {
        return this.stats;
    }

    public void setStats(P4JRpcServerStats stats) {
        this.stats = stats;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setUsingCompression(boolean usingCompression) {
        this.usingCompression = usingCompression;
    }

    public boolean isUnicodeServer() {
        return this.isUnicodeServer;
    }

    public void setUnicodeServer(boolean isUnicodeServer) {
        this.isUnicodeServer = isUnicodeServer;
    }
}

