/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JConnectionNotConnectedException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.generic.core.P4JTempFileInputStreamImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.P4JRpcProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JRpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServerStatus;
import com.perforce.p4java.server.callback.P4JLogCallback;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcOneShotServerImpl
extends P4JRpcServerImpl {
    public static final String SCREEN_NAME = "Native RPC";
    public static final String IMPL_COMMENTS = "Java-native RPC standalone P4Java implementation. Requires JDK 6 or later and full Java NIO support.";
    public static final String PROTOCOL_NAME = "p4jrpc";
    public static final boolean DEFAULT_STATUS = false;
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final String TRACE_PREFIX = "P4JRpcOneShotServerImpl";

    @Override
    public P4JServerStatus init(String host, int port, Properties props) throws P4JConfigException, P4JConnectionException {
        this.minumumSupportedServerVersion = 20052;
        return super.init(host, port, props);
    }

    @Override
    public void connect() throws P4JConnectionException, P4JAccessException, P4JRequestException, P4JConfigException {
        this.serverStats.clear();
        super.connect();
    }

    @Override
    public void disconnect() throws P4JConnectionException, P4JAccessException {
        super.disconnect();
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        Map<String, Object>[] mapArray;
        P4JRpcPacketDispatcher dispatcher = null;
        P4JRpcConnection rpcConnection = null;
        try {
            try {
                P4JTracer.coarse("P4JRpcOneShotServerImpl.connect: connecting to server: " + this.serverHost + ":" + this.serverPort);
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                dispatcher = new P4JRpcPacketDispatcher(this.props, this);
                rpcConnection = new P4JRpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset);
                P4JRpcProtocolCommand protocolSpecs = new P4JRpcProtocolCommand();
                if (inMap != null && P4JClientLineEnding.CONVERT_TEXT) {
                    P4JClientLineEnding.convertMap(inMap);
                }
                P4JRpcExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName, cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey);
                Map<String, Object>[] retMap = dispatcher.dispatch(new P4JRpcCommandEnv(new P4JRpcCmdSpec(cmdName, cmdArgs, this.authTicket, inMap, env), rpcConnection, protocolSpecs, new HashMap<String, Object>(), this.progressCallback, cmdCallBackKey));
                long endTime = System.currentTimeMillis();
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                mapArray = retMap;
                Object var17_16 = null;
            }
            catch (BufferOverflowException exc) {
                P4JLog.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
                throw new P4JError("RPC Buffer overflow: " + exc.getLocalizedMessage());
            }
            catch (P4JConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = P4JServerStatus.ERROR;
                throw cnce;
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            P4JTracer.coarse("P4JRpcOneShotServerImpl.disconnect: disconnecting from server");
            if (dispatcher != null) {
                dispatcher.shutdown(rpcConnection);
            }
            if (rpcConnection == null) throw throwable;
            rpcConnection.disconnect();
            throw throwable;
        }
        P4JTracer.coarse("P4JRpcOneShotServerImpl.disconnect: disconnecting from server");
        if (dispatcher != null) {
            dispatcher.shutdown(rpcConnection);
        }
        if (rpcConnection == null) return mapArray;
        rpcConnection.disconnect();
        return mapArray;
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        InputStream inputStream;
        P4JRpcConnection rpcConnection;
        P4JRpcPacketDispatcher dispatcher;
        block15: {
            P4JTempFileInputStreamImpl p4JTempFileInputStreamImpl;
            block14: {
                dispatcher = null;
                rpcConnection = null;
                try {
                    try {
                        int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                        long startTime = System.currentTimeMillis();
                        dispatcher = new P4JRpcPacketDispatcher(this.props, this);
                        rpcConnection = new P4JRpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset);
                        P4JRpcProtocolCommand protocolSpecs = new P4JRpcProtocolCommand();
                        P4JRpcExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName, cmdArgs, null, ignoreCallbacks, cmdCallBackKey);
                        String tmpFileName = null;
                        P4JRpcPerforceFile tmpFile = null;
                        P4JRpcOutputStream tmpOutStream = null;
                        try {
                            tmpFileName = P4JRpcPerforceFile.createTempFileName(P4JRpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                            tmpFile = new P4JRpcPerforceFile(tmpFileName, P4JRpcPerforceFileType.FST_BINARY);
                            tmpOutStream = new P4JRpcOutputStream(tmpFile);
                        }
                        catch (IOException ioexc) {
                            throw new P4JRequestException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
                        }
                        P4JRpcCommandEnv cmdEnv = new P4JRpcCommandEnv(new P4JRpcCmdSpec(cmdName, cmdArgs, this.authTicket, new HashMap<String, Object>(), env), rpcConnection, protocolSpecs, new HashMap<String, Object>(), this.progressCallback, cmdCallBackKey);
                        cmdEnv.getStateMap().put("", tmpOutStream);
                        Map<String, Object>[] retMap = dispatcher.dispatch(cmdEnv);
                        long endTime = System.currentTimeMillis();
                        if (!ignoreCallbacks && this.commandCallback != null) {
                            this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                        }
                        if (tmpOutStream != null) {
                            P4JTempFileInputStreamImpl inStream;
                            tmpOutStream.close();
                            p4JTempFileInputStreamImpl = inStream = new P4JTempFileInputStreamImpl(tmpFile);
                            Object var21_23 = null;
                            break block14;
                        }
                        inputStream = null;
                        break block15;
                    }
                    catch (BufferOverflowException exc) {
                        P4JLog.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                        P4JLog.exception(exc);
                        throw new P4JError("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    }
                    catch (P4JConnectionNotConnectedException cnce) {
                        this.connected = false;
                        this.status = P4JServerStatus.ERROR;
                        throw cnce;
                    }
                    catch (IOException ioexc) {
                        P4JLog.error("RPC I/O error: " + ioexc.getLocalizedMessage());
                        P4JLog.exception(ioexc);
                        throw new P4JRequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_25 = null;
                    P4JTracer.coarse("P4JRpcOneShotServerImpl.disconnect: disconnecting from server");
                    if (dispatcher != null) {
                        dispatcher.shutdown(rpcConnection);
                    }
                    if (rpcConnection == null) throw throwable;
                    rpcConnection.disconnect();
                    throw throwable;
                }
            }
            P4JTracer.coarse("P4JRpcOneShotServerImpl.disconnect: disconnecting from server");
            if (dispatcher != null) {
                dispatcher.shutdown(rpcConnection);
            }
            if (rpcConnection == null) return p4JTempFileInputStreamImpl;
            rpcConnection.disconnect();
            return p4JTempFileInputStreamImpl;
        }
        Object var21_24 = null;
        P4JTracer.coarse("P4JRpcOneShotServerImpl.disconnect: disconnecting from server");
        if (dispatcher != null) {
            dispatcher.shutdown(rpcConnection);
        }
        if (rpcConnection == null) return inputStream;
        rpcConnection.disconnect();
        return inputStream;
    }

    private P4JRpcExternalEnv setupCmd(P4JRpcPacketDispatcher dispatcher, P4JRpcConnection rpcConnection, P4JRpcProtocolCommand protocolSpecs, String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        if (rpcConnection == null) {
            throw new P4JNullPointerError("Null RPC connection in execMapCmd call");
        }
        if (dispatcher == null) {
            throw new P4JNullPointerError("Null RPC dispatcher in execMapCmd call");
        }
        if (protocolSpecs == null) {
            throw new P4JNullPointerError("Null RPC protocol specs in execMapCmd call");
        }
        if (!P4JCmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new P4JRequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        P4JRpcExternalEnv env = new P4JRpcExternalEnv(this.progName, this.progVersion, this.getClientNameForEnv(), this.getCwdForEnv(), this.getHostForEnv(), this.getLanguageForEnv(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        P4JTracer.coarse("P4JRpcOneShotServerImpl.setupCmd: processing " + cmdName + " cmd");
        P4JTracer.superfine("P4JRpcOneShotServerImpl.setupCmd environment: " + env);
        if (P4JTracer.isTracingAtLevel(P4JLogCallback.P4JLogTraceLevel.FINE) && cmdArgs != null) {
            String args = "";
            for (String arg : cmdArgs) {
                args = args + (arg == null ? "<null>" : arg);
            }
            P4JTracer.fine("P4JRpcOneShotServerImpl.setupCmd.args: " + args);
        }
        if (!ignoreCallbacks && this.commandCallback != null) {
            StringBuilder cmd = new StringBuilder(cmdName);
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd.append(" ");
                cmd.append(argStr);
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
        }
        P4JRpcPacket protPacket = null;
        protocolSpecs.setClientApiLevel(this.clientApiLevel);
        protocolSpecs.setClientCmpFile(false);
        protocolSpecs.setServerApiLevel(this.serverApiLevel);
        protocolSpecs.setSendBufSize(rpcConnection.getSystemSendBufferSize());
        protocolSpecs.setRecvBufSize(rpcConnection.getSystemRecvBufferSize());
        protocolSpecs.setUseTags(true);
        P4JTracer.superfine("P4JRpcOneShotServerImplSending protocol: " + protocolSpecs.asMap());
        protPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_PROTOCOL, protocolSpecs.asMap(), null);
        P4JRpcFunctionSpec name = P4JRpcFunctionSpec.decodeFromEndUserCmd(cmdName);
        P4JRpcPacket cmdPacket = P4JRpcPacket.constructRpcPacket(name, cmdArgs, env);
        if (protPacket == null) {
            P4JTracer.coarse("P4JRpcOneShotServerImpl.execMapCmd sending cmd: " + cmdName);
            rpcConnection.putRpcPacket(cmdPacket);
        } else {
            P4JTracer.coarse("P4JRpcOneShotServerImpl.execMapCmd sending protocol cmd + " + cmdName);
            rpcConnection.putRpcPackets(new P4JRpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }
}

