/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JConnectionNotConnectedException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.core.P4JTempFileInputStreamImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.P4JRpcProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.P4JRpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServerStatus;
import com.perforce.p4java.server.callback.P4JLogCallback;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcNtsServerImpl
extends P4JRpcServerImpl {
    public static final String SCREEN_NAME = "Native RPC (Experimental)";
    public static final String IMPL_COMMENTS = "Experimental Java-native RPC standalone P4Java implementation. Requires JDK 6 or later, full Java NIO support, and external thread synchronization. Not for the faint-hearted.";
    public static final String PROTOCOL_NAME = "p4jrpcnts";
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final boolean DEFAULT_STATUS = false;
    public static final String TRACE_PREFIX = "P4JRpcNtsServerImpl";
    private boolean haveSentProtocolSpecs = false;
    protected P4JRpcProtocolCommand protocolSpecs = null;
    protected P4JRpcPacketDispatcher dispatcher = null;
    protected P4JRpcConnection rpcConnection = null;

    @Override
    public P4JServerStatus init(String host, int port, Properties props) throws P4JConfigException, P4JConnectionException {
        this.minumumSupportedServerVersion = 20052;
        return super.init(host, port, props);
    }

    @Override
    public void connect() throws P4JConnectionException, P4JAccessException, P4JRequestException, P4JConfigException {
        P4JTracer.coarse("P4JRpcNtsServerImpl.connect: connecting to server: " + this.serverHost + ":" + this.serverPort);
        this.rpcConnection = new P4JRpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset);
        this.dispatcher = new P4JRpcPacketDispatcher(this.props, this);
        P4JLog.info("RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort + " established");
        super.connect();
    }

    @Override
    public void disconnect() throws P4JConnectionException, P4JAccessException {
        P4JTracer.coarse("P4JRpcNtsServerImpl.disconnect: disconnecting from server");
        P4JLog.info("Disconnected RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort);
        this.dispatcher.shutdown(this.rpcConnection);
        this.rpcConnection.disconnect();
        this.haveSentProtocolSpecs = false;
        this.protocolSpecs = null;
        super.disconnect();
    }

    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        boolean retVal = super.setCharsetName(charsetName);
        this.rpcConnection.setClientCharset(this.charset);
        return retVal;
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        try {
            int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
            long startTime = System.currentTimeMillis();
            P4JRpcExternalEnv env = this.setupCmd(cmdName, cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey);
            Map<String, Object>[] retMap = this.dispatcher.dispatch(new P4JRpcCommandEnv(new P4JRpcCmdSpec(cmdName, cmdArgs, this.authTicket, inMap, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey));
            long endTime = System.currentTimeMillis();
            if (!ignoreCallbacks && this.commandCallback != null) {
                this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
            }
            return retMap;
        }
        catch (BufferOverflowException exc) {
            P4JLog.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
            P4JLog.exception(exc);
            throw new P4JError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
        }
        catch (P4JConnectionNotConnectedException cnce) {
            this.connected = false;
            this.status = P4JServerStatus.ERROR;
            throw cnce;
        }
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        try {
            try {
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                P4JRpcExternalEnv env = this.setupCmd(cmdName, cmdArgs, null, ignoreCallbacks, cmdCallBackKey);
                String tmpFileName = null;
                P4JRpcPerforceFile tmpFile = null;
                P4JRpcOutputStream tmpOutStream = null;
                try {
                    tmpFileName = P4JRpcPerforceFile.createTempFileName(P4JRpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                    tmpFile = new P4JRpcPerforceFile(tmpFileName, P4JRpcPerforceFileType.FST_BINARY);
                    tmpOutStream = new P4JRpcOutputStream(tmpFile);
                }
                catch (IOException ioexc) {
                    P4JLog.error("tmp file creation error: " + ioexc.getLocalizedMessage());
                    P4JLog.exception(ioexc);
                    throw new P4JRequestException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
                }
                P4JRpcCommandEnv cmdEnv = new P4JRpcCommandEnv(new P4JRpcCmdSpec(cmdName, cmdArgs, this.authTicket, null, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey);
                cmdEnv.getStateMap().put("", tmpOutStream);
                Map<String, Object>[] retMap = this.dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                if (tmpOutStream == null) return null;
                tmpOutStream.close();
                P4JTempFileInputStreamImpl inStream = new P4JTempFileInputStreamImpl(tmpFile);
                return inStream;
            }
            catch (BufferOverflowException exc) {
                P4JLog.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
                throw new P4JError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
            }
            catch (P4JConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = P4JServerStatus.ERROR;
                throw cnce;
            }
            catch (IOException ioexc) {
                P4JLog.error("I/O error encountered in stream command: " + ioexc.getLocalizedMessage());
                P4JLog.exception(ioexc);
                throw new P4JRequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            throw throwable;
        }
    }

    protected P4JRpcExternalEnv setupCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        if (this.rpcConnection == null) {
            throw new P4JNullPointerError("Null RPC connection in execMapCmd call");
        }
        if (!this.connected) {
            throw new P4JConnectionNotConnectedException("Not currently connected to a Perforce server");
        }
        if (!P4JCmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new P4JRequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        P4JRpcExternalEnv env = new P4JRpcExternalEnv(this.progName, this.progVersion, this.getClientNameForEnv(), this.getCwdForEnv(), this.getHostForEnv(), this.getLanguageForEnv(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        P4JTracer.coarse("P4JRpcNtsServerImpl.setupCmd: processing " + cmdName + " cmd");
        P4JTracer.superfine("P4JRpcNtsServerImpl.setupCmd environment: " + env);
        if (P4JTracer.isTracingAtLevel(P4JLogCallback.P4JLogTraceLevel.FINE) && cmdArgs != null) {
            String args = "";
            for (String arg : cmdArgs) {
                args = args + (arg == null ? "<null>" : arg);
            }
            P4JTracer.fine("P4JRpcNtsServerImpl.setupCmd.args: " + args);
        }
        if (!ignoreCallbacks && this.commandCallback != null) {
            String cmd = cmdName;
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd = cmd + " " + argStr;
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd);
        }
        P4JRpcPacket protPacket = null;
        if (!this.haveSentProtocolSpecs) {
            this.protocolSpecs = new P4JRpcProtocolCommand(this.clientApiLevel, false, this.serverApiLevel, this.rpcConnection.getSystemSendBufferSize(), this.rpcConnection.getSystemRecvBufferSize(), true);
            this.protocolSpecs.setUseTags(true);
            P4JTracer.superfine("P4JRpcNtsServerImplSending protocol: " + this.protocolSpecs.asMap());
            protPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_PROTOCOL, this.protocolSpecs.asMap(), null);
            this.haveSentProtocolSpecs = true;
        }
        P4JRpcFunctionSpec name = P4JRpcFunctionSpec.decodeFromEndUserCmd(cmdName);
        P4JRpcPacket cmdPacket = null;
        if (name == P4JRpcFunctionSpec.USER_LOGIN) {
            String[] loginCmdArgs = new String[]{"-p"};
            cmdPacket = P4JRpcPacket.constructRpcPacket(name, loginCmdArgs, env);
        } else {
            cmdPacket = P4JRpcPacket.constructRpcPacket(name, cmdArgs, env);
        }
        if (protPacket == null) {
            P4JTracer.coarse("P4JRpcNtsServerImpl.execMapCmd sending cmd: " + cmdName);
            this.rpcConnection.putRpcPacket(cmdPacket);
        } else {
            P4JTracer.coarse("P4JRpcNtsServerImpl.execMapCmd sending protocol cmd + " + cmdName);
            this.rpcConnection.putRpcPackets(new P4JRpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }

    public P4JRpcConnection getRpcConnection() {
        return this.rpcConnection;
    }

    public void setRpcConnection(P4JRpcConnection rpcConnection) {
        this.rpcConnection = rpcConnection;
    }
}

