/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcMarshalable;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketField;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class P4JRpcExternalEnv
implements P4JRpcMarshalable {
    private static final String RPC_ARGNAME_ENV_PROGRAM = "prog";
    private static final String RPC_ARGNAME_ENV_VERSION = "version";
    private static final String RPC_ARGNAME_ENV_CLIENTNAME = "client";
    private static final String RPC_ARGNAME_ENV_CWD = "cwd";
    private static final String RPC_ARGNAME_ENV_HOSTNAME = "host";
    private static final String RPC_ARGNAME_ENV_LANGUAGE = "language";
    private static final String RPC_ARGNAME_ENV_OSNAME = "os";
    private static final String RPC_ARGNAME_ENV_USERNAME = "user";
    private static final String RPC_ARGNAME_ENV_UNICODE = "unicode";
    private String progName = null;
    private String version = null;
    private String client = null;
    private String cwd = null;
    private String host = null;
    private String language = null;
    private String os = null;
    private String user = null;
    private boolean unicode = false;
    private Charset currentCharset = P4JCharset.LOCAL;

    public P4JRpcExternalEnv(String progName, String version, String client, String cwd, String host, String language, String os, String user, boolean unicode, Charset currentCharset) {
        this.progName = progName;
        this.version = version;
        this.client = client;
        this.cwd = cwd;
        this.host = host;
        this.language = language;
        this.os = os;
        this.user = user;
        this.unicode = unicode;
        this.currentCharset = currentCharset;
    }

    public void marshal(ByteBuffer buf) throws BufferOverflowException {
        if (buf == null) {
            throw new P4JNullPointerError("Null ByteBuffer passed to P4JRpcEnv.marshal()");
        }
        try {
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_PROGRAM, this.progName.getBytes(P4JCharset.UTF8.name()));
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_VERSION, this.version.getBytes(P4JCharset.UTF8.name()));
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_CLIENTNAME, this.client.getBytes(P4JCharset.UTF8.name()));
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_CWD, this.cwd.getBytes(P4JCharset.UTF8.name()));
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_HOSTNAME, this.host.getBytes(P4JCharset.UTF8.name()));
            if (this.language != null) {
                P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_LANGUAGE, this.language.getBytes(P4JCharset.UTF8.name()));
            }
            if (this.unicode) {
                P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_UNICODE, "".getBytes(P4JCharset.UTF8.name()));
            }
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_OSNAME, this.os.getBytes(P4JCharset.UTF8.name()));
            P4JRpcPacketField.marshal(buf, RPC_ARGNAME_ENV_USERNAME, this.user.getBytes(P4JCharset.UTF8.name()));
        }
        catch (UnsupportedEncodingException exc) {
            P4JLog.exception(exc);
            throw new P4JProtocolError("rpc marshaling error: unsupported encoding: " + exc.getMessage());
        }
    }

    public byte[] marshal() {
        ByteBuffer byteBuf = ByteBuffer.allocate(10240);
        this.marshal(byteBuf);
        byteBuf.flip();
        int envLength = byteBuf.limit();
        byte[] envBytes = new byte[envLength];
        byteBuf.get(envBytes);
        return envBytes;
    }

    public String toString() {
        return "prog: " + P4JServerImpl.guardNull(this.progName) + "; " + RPC_ARGNAME_ENV_VERSION + ": " + P4JServerImpl.guardNull(this.version) + "; " + RPC_ARGNAME_ENV_CLIENTNAME + ": " + P4JServerImpl.guardNull(this.client) + "; " + RPC_ARGNAME_ENV_CWD + ": " + P4JServerImpl.guardNull(this.cwd) + "; " + RPC_ARGNAME_ENV_HOSTNAME + ": " + P4JServerImpl.guardNull(this.host) + "; " + RPC_ARGNAME_ENV_LANGUAGE + ": " + P4JServerImpl.guardNull(this.language) + "; " + RPC_ARGNAME_ENV_OSNAME + ": " + P4JServerImpl.guardNull(this.os) + "; " + RPC_ARGNAME_ENV_USERNAME + ": " + P4JServerImpl.guardNull(this.user);
    }

    public String getProgName() {
        return this.progName;
    }

    public void setProgName(String progName) {
        this.progName = progName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getCwd() {
        return this.cwd;
    }

    public void setCwd(String cwd) {
        this.cwd = cwd;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public Charset getCurrentCharset() {
        return this.currentCharset;
    }

    public void setCurrentCharset(Charset currentCharset) {
        this.currentCharset = currentCharset;
    }
}

