/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.p4cmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonMarshall {
    protected static byte[] writeDictionary(Map val, boolean utf8) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        buff.write(123);
        Set keys = val.keySet();
        for (String key : keys) {
            PythonMarshall.writeString(key, buff, utf8);
            PythonMarshall.writeString((String)val.get(key), buff, utf8);
        }
        buff.write(48);
        return buff.toByteArray();
    }

    protected static Map<String, Object>[] readDictionaries(InputStream input, boolean utf8) {
        Object obj;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((obj = PythonMarshall.readObject(input, utf8)) != null) {
            list.add(obj);
        }
        return list.toArray(new Map[list.size()]);
    }

    private static void writeInt(int val, ByteArrayOutputStream buff) {
        buff.write(val >>> 0);
        buff.write(val >>> 8);
        buff.write(val >>> 16);
        buff.write(val >>> 24);
    }

    private static void writeString(String val, ByteArrayOutputStream buff, boolean utf8) {
        try {
            byte[] enc = utf8 ? val.getBytes("utf-8") : val.getBytes();
            buff.write(115);
            PythonMarshall.writeInt(enc.length, buff);
            buff.write(enc, 0, enc.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private static void readBytes(InputStream input, byte[] bytes) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)input.read();
        }
    }

    private static String readString(InputStream input, boolean utf8) {
        try {
            Integer len = PythonMarshall.readInteger(input);
            if (len != null) {
                byte[] stringBytes = new byte[len.intValue()];
                PythonMarshall.readBytes(input, stringBytes);
                if (utf8) {
                    return new String(stringBytes, "utf-8");
                }
                return new String(stringBytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private static Integer readInteger(InputStream input) {
        byte[] buff = new byte[4];
        try {
            PythonMarshall.readBytes(input, buff);
            int intval = (PythonMarshall.unsignedByteToInt(buff[0]) << 0) + (PythonMarshall.unsignedByteToInt(buff[1]) << 8) + (PythonMarshall.unsignedByteToInt(buff[2]) << 16) + (PythonMarshall.unsignedByteToInt(buff[3]) << 24);
            return new Integer(intval);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map readDictionary(InputStream input, boolean utf8) {
        Object key;
        HashMap<Object, Object> dict = new HashMap<Object, Object>();
        while ((key = PythonMarshall.readObject(input, utf8)) != null) {
            dict.put(key, PythonMarshall.readObject(input, utf8));
        }
        return dict;
    }

    private static Object readObject(InputStream input, boolean utf8) {
        Object obj = null;
        try {
            int type = input.read();
            switch (type) {
                case 123: {
                    obj = PythonMarshall.readDictionary(input, utf8);
                    break;
                }
                case 115: {
                    obj = PythonMarshall.readString(input, utf8);
                    break;
                }
                case 105: {
                    obj = PythonMarshall.readInteger(input);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return obj;
    }
}

