/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.p4cmd;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JConnectionNotConnectedException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import com.perforce.p4java.impl.generic.core.P4JTempFileInputStreamImpl;
import com.perforce.p4java.impl.mapbased.p4cmd.PythonMarshall;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServerImplMetadata;
import com.perforce.p4java.server.P4JServerStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4CmdServerImpl
extends P4JServerImpl {
    public static final P4JServerImplMetadata.ImplType IMPL_TYPE = P4JServerImplMetadata.ImplType.P4C;
    public static final String SCREEN_NAME = "P4 command line";
    public static final String IMPL_COMMENTS = "Default P4Java implementation. Requires a working p4 command line application either in your execution path or specified explictly by the caller.";
    public static final String PROTOCOL_NAME = "p4jcmd";
    public static final String P4LOGINSSO = "P4LOGINSSO";
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final boolean DEFAULT_STATUS = true;
    public static final String P4CMD_EXEC_KEY = "com.perforce.p4j.p4cmd.executable";
    public static final String DEFAULT_P4CMD = "p4";
    private static final int BIG_CMD_LENGTH = 35;
    private static final String PORT_SPEC = "-p";
    private static final String PYTHON_SPEC = "-G";
    private static final String PROGNAME_SPEC = "-zprog=";
    private static final String PROGVERSION_SPEC = "-zversion=";
    private static final String APIVERSION_SPEC = "-Zapi=65";
    private static final String PASSWORD_SPEC = "-P";
    private static final String USER_SPEC = "-u";
    private static final String CLIENT_SPEC = "-c";
    private static final String TMP_FILE_SPEC = "-x";
    private static final String CHARSET_SPEC = "-C";
    private static final String CWD_SPEC = "-d";
    private static final String TMPFILE_PFX = "p4java";
    private static final String CONN_FAIL_STRING = "Connect to server failed";
    private String[] cmdPrefixArgs = null;
    private String[] accessErrMsgs = new String[]{"Perforce password (P4PASSWD)", "Access for user", "Your session has expired", "Your session was logged out"};
    protected int p4CmdLineAppVersion = 0;

    @Override
    public P4JServerStatus init(String host, int port, Properties props) throws P4JConfigException, P4JConnectionException {
        super.init(host, port, props);
        this.status = P4JServerStatus.ERROR;
        this.connected = true;
        Process process = null;
        try {
            P4JLog.info("P4Java server object constructed using p4 command binary: " + this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD));
            this.minumumSupportedServerVersion = 20052;
            process = Runtime.getRuntime().exec(this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD));
        }
        catch (IOException ioe) {
            throw new P4JConfigException("'" + this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD) + "': no such command line executable found", ioe);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        this.cmdPrefixArgs = new String[]{PORT_SPEC + this.serverHost + ":" + this.serverPort, PROGNAME_SPEC + this.progName, PROGVERSION_SPEC + this.progVersion, APIVERSION_SPEC};
        this.serverVersion = this.getServerVersion();
        this.status = P4JServerStatus.READY;
        String infoString = "Server version: " + this.serverVersion + " port: " + this.serverHost + ":" + this.serverPort + " api: " + APIVERSION_SPEC;
        P4JLog.info(infoString);
        this.p4CmdLineAppVersion = this.getClientAppVersion();
        P4JLog.info("using client app version: " + this.p4CmdLineAppVersion);
        return this.status;
    }

    @Override
    public String getErrorStr(Map<String, Object> map) {
        String code;
        if (map != null && (code = (String)map.get("code")) != null && code.equalsIgnoreCase("error")) {
            String errStr = (String)map.get("data");
            if (errStr == null) {
                return "";
            }
            return errStr;
        }
        return null;
    }

    @Override
    public String getErrorOrInfoStr(Map<String, Object> map) {
        String code;
        if (map != null && (code = (String)map.get("code")) != null && (code.equalsIgnoreCase("error") || code.equalsIgnoreCase("info"))) {
            String errStr = (String)map.get("data");
            if (errStr == null) {
                return "";
            }
            return errStr;
        }
        return null;
    }

    @Override
    public String getInfoStr(Map<String, Object> map) {
        String code;
        if (map != null && (code = (String)map.get("code")) != null && code.equalsIgnoreCase("info")) {
            String infoStr = (String)map.get("data");
            if (infoStr == null) {
                return "";
            }
            return infoStr;
        }
        return null;
    }

    @Override
    public boolean isInfoMessage(Map<String, Object> map) {
        String code;
        return map != null && (code = (String)map.get("code")) != null && code.equalsIgnoreCase("info");
    }

    @Override
    public int getSeverityCode(Map<String, Object> map) {
        int val = 0;
        if (map != null) {
            Object obj;
            String code;
            if (map.containsKey("code") && (code = (String)map.get("code")) != null) {
                if (code.equalsIgnoreCase("info")) {
                    return 1;
                }
                if (code.equalsIgnoreCase("error")) {
                    return 3;
                }
            }
            if ((obj = map.get("severity")) != null) {
                try {
                    val = (Integer)obj;
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerImpl.getSeverityCode: " + exc);
                    P4JLog.exception(exc);
                }
            }
        }
        return val;
    }

    @Override
    protected int getGenericCode(Map<String, Object> map) {
        int val = 0;
        if (map != null) {
            Object obj;
            if (map.containsKey("level")) {
                try {
                    int code = (Integer)map.get("level");
                    return code;
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerImpl.getGenericCode: " + exc);
                    P4JLog.exception(exc);
                }
            }
            if ((obj = map.get("generic")) != null) {
                try {
                    val = (Integer)obj;
                }
                catch (Exception exc) {
                    P4JLog.error("Unexpected exception in P4JServerImpl.getGenericCode: " + exc);
                    P4JLog.exception(exc);
                }
            }
        }
        return val;
    }

    @Override
    public boolean supportsSmartMove() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.serverVersion >= 20091 && this.p4CmdLineAppVersion >= 20091;
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    /*
     * Loose catch block
     */
    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws P4JConnectionException, P4JAccessException, P4JRequestException {
        Map<String, Object>[] resultsMap;
        block60: {
            boolean useTmpFile = false;
            File tmpFile = null;
            int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
            if (!this.connected) {
                throw new P4JConnectionNotConnectedException("Not currently connected to a Perforce server");
            }
            if (cmdArgs == null) {
                cmdArgs = new String[]{};
            }
            if (cmdName == null) {
                throw new P4JNullPointerError("Null command name in execMapCmd");
            }
            P4JCmdSpec spec = P4JCmdSpec.getValidP4JCmdSpec(cmdName);
            if (spec == null) {
                throw new P4JRequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
            }
            if (!ignoreCallbacks && this.commandCallback != null) {
                StringBuilder cmd = new StringBuilder(cmdName);
                for (String argStr : cmdArgs) {
                    if (argStr == null) continue;
                    cmd.append(' ');
                    cmd.append(argStr);
                }
                this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
            }
            if (cmdName.equalsIgnoreCase(P4JCmdSpec.LOGIN.toString())) {
                return this.rawLogin(inMap);
            }
            int nonOptArgCount = this.nonOptionCommandArgCount(cmdArgs);
            if (nonOptArgCount > 35 || nonOptArgCount > 0 && this.isUnicode()) {
                useTmpFile = true;
            }
            resultsMap = null;
            Vector<String> cmdVec = new Vector<String>();
            int nonFileCmdArgCount = 0;
            cmdVec.add(this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD));
            for (String str : this.cmdPrefixArgs) {
                cmdVec.add(str);
            }
            if (this.workingDirectoryPath != null) {
                cmdVec.add(CWD_SPEC + this.workingDirectoryPath);
            }
            if (useTmpFile) {
                try {
                    tmpFile = File.createTempFile(TMPFILE_PFX, null, new File(this.tmpDirName));
                    cmdVec.add(TMP_FILE_SPEC + tmpFile.getCanonicalPath());
                }
                catch (IOException exc) {
                    P4JLog.error("Unable to create temporary file for p4 command line arguments" + exc.getLocalizedMessage());
                    P4JLog.exception(exc);
                    throw new P4JConnectionException("Unable to create temporary file for p4 command line arguments" + exc.getLocalizedMessage());
                }
            }
            cmdVec.add(PYTHON_SPEC);
            this.addCommonArgs(spec, cmdVec);
            cmdVec.add(cmdName.toLowerCase());
            String[] cmdEnv = this.scrubEnv(System.getenv());
            if (useTmpFile) {
                PrintWriter tmpWriter = null;
                try {
                    for (String cmdArg : cmdArgs) {
                        if (cmdArg == null || !cmdArg.startsWith("-")) break;
                        cmdVec.add(isRunningOnWindows ? this.normaliseArgStringForWindows(cmdArg) : cmdArg);
                        ++nonFileCmdArgCount;
                    }
                    tmpWriter = this.charsetName != null ? new PrintWriter(tmpFile, "utf-8") : new PrintWriter(tmpFile);
                    for (int i = nonFileCmdArgCount; i < cmdArgs.length; ++i) {
                        if (cmdArgs[i] == null) continue;
                        tmpWriter.println(cmdArgs[i]);
                    }
                }
                catch (UnsupportedEncodingException use) {
                    if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                        P4JLog.warn("delete failed in P4JCmdServerImpl.execMapCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                    }
                    P4JLog.exception(use);
                    throw new P4JConnectionException("Unsupported character set: " + this.charsetName);
                }
                catch (Exception exc) {
                    if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                        P4JLog.warn("delete failed in P4JCmdServerImpl.execMapCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                    }
                    P4JLog.exception(exc);
                    throw new P4JConnectionException("Unable to write to temporary file for p4 command line arguments: " + exc.getLocalizedMessage());
                }
                finally {
                    if (tmpWriter != null) {
                        tmpWriter.flush();
                        tmpWriter.close();
                    }
                }
            } else {
                for (String cmdArg : cmdArgs) {
                    if (cmdArg == null) continue;
                    cmdVec.add(isRunningOnWindows ? this.normaliseArgStringForWindows(cmdArg) : cmdArg);
                }
            }
            Process proc = null;
            BufferedReader errReader = null;
            StringBuffer errBuf = new StringBuffer();
            OutputStream output = null;
            long startTime = System.currentTimeMillis();
            proc = Runtime.getRuntime().exec(cmdVec.toArray(new String[cmdVec.size()]), cmdEnv);
            errReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            if (inMap != null) {
                if (P4JClientLineEnding.CONVERT_TEXT) {
                    P4JClientLineEnding.convertMap(inMap);
                }
                byte[] bytes = PythonMarshall.writeDictionary(inMap, this.isUnicode());
                output = proc.getOutputStream();
                output.write(bytes);
                output.flush();
                output.close();
            }
            resultsMap = PythonMarshall.readDictionaries(proc.getInputStream(), this.isUnicode());
            String inLine = null;
            while ((inLine = errReader.readLine()) != null) {
                errBuf.append(inLine + "\n");
            }
            int exitCode = proc.waitFor();
            long endTime = System.currentTimeMillis();
            if (!ignoreCallbacks && this.commandCallback != null) {
                this.commandCallback.completedServerCommand(cmdCallBackKey, endTime - startTime);
                if (resultsMap != null) {
                    for (Map<String, Object> map : resultsMap) {
                        String str = this.getErrorOrInfoStr(map);
                        if (str != null) {
                            str = str.trim();
                        }
                        int generic = this.getGenericCode(map);
                        int severity = this.getSeverityCode(map);
                        if (severity != 0) {
                            this.commandCallback.receivedServerMessage(cmdCallBackKey, generic, severity, str);
                        }
                        if (severity == 1) {
                            this.commandCallback.receivedServerInfoLine(cmdCallBackKey, str);
                            continue;
                        }
                        if (severity < 3) continue;
                        this.commandCallback.receivedServerErrorLine(cmdCallBackKey, str);
                    }
                }
            }
            if (errBuf.length() > 0) {
                if (errBuf.indexOf(CONN_FAIL_STRING) >= 0) {
                    throw new P4JConnectionException(errBuf.toString());
                }
                throw new P4JConnectionException(errBuf.toString());
            }
            Object var32_45 = null;
            try {
                if (output != null) {
                    output.close();
                }
                if (errReader != null) {
                    errReader.close();
                }
                if (proc != null) {
                    if (proc.getInputStream() != null) {
                        proc.getInputStream().close();
                    }
                    if (proc.getOutputStream() != null) {
                        proc.getOutputStream().close();
                    }
                    if (proc.getErrorStream() != null) {
                        proc.getErrorStream().close();
                    }
                    proc.destroy();
                }
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    P4JLog.warn("delete failed in P4JCmdServerImpl.execMapCmd( ) for file: " + tmpFile.getPath() + "(unknown cause)");
                }
                break block60;
            }
            catch (IOException ioexc) {
                P4JLog.error("Unexpected exception in P4CmdServerImpl.execMapCmd: " + ioexc);
                P4JLog.exception(ioexc);
            }
            break block60;
            {
                catch (IOException ioexc) {
                    P4JLog.warn("Unexpected I/O exception: " + ioexc.getLocalizedMessage());
                    P4JLog.exception(ioexc);
                    throw new P4JConnectionException(ioexc.getLocalizedMessage());
                }
                catch (InterruptedException exc) {
                    throw new P4JConnectionException(exc.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Object var32_46 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                    if (errReader != null) {
                        errReader.close();
                    }
                    if (proc != null) {
                        if (proc.getInputStream() != null) {
                            proc.getInputStream().close();
                        }
                        if (proc.getOutputStream() != null) {
                            proc.getOutputStream().close();
                        }
                        if (proc.getErrorStream() != null) {
                            proc.getErrorStream().close();
                        }
                        proc.destroy();
                    }
                    if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                        P4JLog.warn("delete failed in P4JCmdServerImpl.execMapCmd( ) for file: " + tmpFile.getPath() + "(unknown cause)");
                    }
                }
                catch (IOException ioexc) {
                    P4JLog.error("Unexpected exception in P4CmdServerImpl.execMapCmd: " + ioexc);
                    P4JLog.exception(ioexc);
                }
                throw throwable;
            }
        }
        return resultsMap;
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    /*
     * Loose catch block
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JTempFileInputStreamImpl tmpReader;
        block51: {
            File inTmpFile;
            String[] cmdEnv;
            Vector<String> cmdVec;
            File tmpFile;
            block50: {
                int nonOptArgCount;
                boolean useTmpFile = false;
                tmpFile = null;
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                if (!this.connected) {
                    throw new P4JConnectionNotConnectedException("Not currently connected to a Perforce server");
                }
                if (cmdArgs == null) {
                    cmdArgs = new String[]{};
                }
                if (cmdName == null) {
                    throw new P4JNullPointerError("Null command name in execStreamCmd");
                }
                P4JCmdSpec spec = P4JCmdSpec.getValidP4JCmdSpec(cmdName);
                if (spec == null) {
                    throw new P4JRequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
                }
                if (!ignoreCallbacks && this.commandCallback != null) {
                    StringBuilder cmd = new StringBuilder(cmdName);
                    for (String argStr : cmdArgs) {
                        if (argStr == null) continue;
                        cmd.append(' ');
                        cmd.append(argStr);
                    }
                    this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
                }
                if ((nonOptArgCount = this.nonOptionCommandArgCount(cmdArgs)) > 35 || nonOptArgCount > 0 && this.isUnicode()) {
                    useTmpFile = true;
                }
                cmdVec = new Vector<String>();
                int nonFileCmdArgCount = 0;
                cmdVec.add(this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD));
                for (String str : this.cmdPrefixArgs) {
                    cmdVec.add(str);
                }
                if (this.workingDirectoryPath != null) {
                    cmdVec.add(CWD_SPEC + this.workingDirectoryPath);
                }
                if (useTmpFile) {
                    try {
                        tmpFile = File.createTempFile("p4javax", null, new File(this.tmpDirName));
                        cmdVec.add(TMP_FILE_SPEC + tmpFile.getCanonicalPath());
                    }
                    catch (IOException exc) {
                        P4JLog.warn("Unable to create temporary file for p4 command line arguments" + exc.getLocalizedMessage());
                        P4JLog.exception(exc);
                        throw new P4JConnectionException("Unable to create temporary file for p4 command line arguments" + exc.getLocalizedMessage());
                    }
                }
                this.addCommonArgs(spec, cmdVec);
                cmdVec.add(cmdName.toLowerCase());
                cmdEnv = this.scrubEnv(System.getenv());
                if (useTmpFile) {
                    PrintWriter tmpWriter = null;
                    try {
                        try {
                            for (String cmdArg : cmdArgs) {
                                if (cmdArg == null || !cmdArg.startsWith("-")) break;
                                cmdVec.add(isRunningOnWindows ? this.normaliseArgStringForWindows(cmdArg) : cmdArg);
                                ++nonFileCmdArgCount;
                            }
                            tmpWriter = this.charsetName != null ? new PrintWriter(tmpFile, "utf-8") : new PrintWriter(tmpFile);
                            for (int i = nonFileCmdArgCount; i < cmdArgs.length; ++i) {
                                if (cmdArgs[i] == null) continue;
                                tmpWriter.println(cmdArgs[i]);
                            }
                            Object var18_32 = null;
                            if (tmpWriter == null) break block50;
                            tmpWriter.flush();
                            tmpWriter.close();
                            break block50;
                        }
                        catch (UnsupportedEncodingException use) {
                            if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                                P4JLog.warn("delete failed in P4JCmdServerImpl.execStreamCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                            }
                            P4JLog.exception(use);
                            throw new P4JConnectionException("Unsupported character set: " + this.charsetName);
                        }
                        catch (Exception exc) {
                            if (!tmpFile.delete()) {
                                P4JLog.warn("delete failed in P4JCmdServerImpl.execStreamCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                            }
                            P4JLog.exception(exc);
                            throw new P4JConnectionException("Unable to write to temporary file for p4 command line arguments: " + exc.getLocalizedMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_33 = null;
                        if (tmpWriter != null) {
                            tmpWriter.flush();
                            tmpWriter.close();
                        }
                        throw throwable;
                    }
                }
                for (String cmdArg : cmdArgs) {
                    if (cmdArg == null) continue;
                    cmdVec.add(isRunningOnWindows ? this.normaliseArgStringForWindows(cmdArg) : cmdArg);
                }
            }
            Process proc = null;
            BufferedReader errReader = null;
            OutputStream outStream = null;
            tmpReader = null;
            proc = Runtime.getRuntime().exec(cmdVec.toArray(new String[cmdVec.size()]), cmdEnv);
            errReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            outStream = proc.getOutputStream();
            InputStream inStream = proc.getInputStream();
            if (inStream != null && (inTmpFile = File.createTempFile(TMPFILE_PFX, null, new File(this.tmpDirName))) != null) {
                int BUF_SIZE = 1024;
                byte[] buf = new byte[1024];
                FileOutputStream tmpStream = new FileOutputStream(inTmpFile);
                int bytesRead = 0;
                while ((bytesRead = inStream.read(buf)) > 0) {
                    tmpStream.write(buf, 0, bytesRead);
                }
                tmpStream.close();
                inStream.close();
                tmpReader = new P4JTempFileInputStreamImpl(inTmpFile);
            }
            String inLine = null;
            inLine = errReader.readLine();
            if (inLine != null) {
                if (this.isAuthFail(inLine)) {
                    throw new P4JAccessException(inLine);
                }
                throw new P4JRequestException(inLine);
            }
            int exitCode = proc.waitFor();
            Object var23_41 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (errReader != null) {
                    errReader.close();
                }
                if (proc != null) {
                    if (proc.getInputStream() != null) {
                        proc.getInputStream().close();
                    }
                    if (proc.getOutputStream() != null) {
                        proc.getOutputStream().close();
                    }
                    if (proc.getErrorStream() != null) {
                        proc.getErrorStream().close();
                    }
                    proc.destroy();
                }
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    P4JLog.warn("delete failed in P4JCmdServerImpl.execStreamCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                }
                break block51;
            }
            catch (IOException e) {
                P4JLog.error("Unexpected exception in P4CmdServerImpl.execStreamCmd: " + e);
                P4JLog.exception(e);
            }
            break block51;
            {
                catch (IOException ioexc) {
                    P4JLog.error("Unexpected I/O exception: " + ioexc.getLocalizedMessage());
                    P4JLog.exception(ioexc);
                    throw new P4JConnectionException(ioexc.getLocalizedMessage());
                }
                catch (InterruptedException exc) {
                    throw new P4JConnectionException(exc.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Object var23_42 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                    if (errReader != null) {
                        errReader.close();
                    }
                    if (proc != null) {
                        if (proc.getInputStream() != null) {
                            proc.getInputStream().close();
                        }
                        if (proc.getOutputStream() != null) {
                            proc.getOutputStream().close();
                        }
                        if (proc.getErrorStream() != null) {
                            proc.getErrorStream().close();
                        }
                        proc.destroy();
                    }
                    if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                        P4JLog.warn("delete failed in P4JCmdServerImpl.execStreamCmd for file: " + tmpFile.getPath() + "(unknown cause)");
                    }
                }
                catch (IOException e) {
                    P4JLog.error("Unexpected exception in P4CmdServerImpl.execStreamCmd: " + e);
                    P4JLog.exception(e);
                }
                throw throwable;
            }
        }
        return tmpReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object>[] rawLogin(Map<String, Object> inMap) throws P4JConnectionException, P4JAccessException {
        Map[] mapArray;
        int CMD_BUFSIZE = 1024;
        String LOGIN_NOT_NEEDED_MSG = "'login' not necessary";
        String pwd = null;
        if (inMap != null) {
            pwd = (String)inMap.get("password");
        }
        Process proc = null;
        int exitCode = 0;
        OutputStream outStream = null;
        InputStream inStream = null;
        BufferedReader errReader = null;
        StringBuffer errBuf = null;
        boolean useSSO = false;
        if (this.userName == null) {
            throw new P4JConnectionException("Perforce user name not set for Perforce server connection");
        }
        String[] args = null;
        args = this.charsetName != null ? new String[]{this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD), PORT_SPEC + this.serverHost + ":" + this.serverPort, USER_SPEC + this.userName, CHARSET_SPEC + this.charsetName, "login", PORT_SPEC} : new String[]{this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD), PORT_SPEC + this.serverHost + ":" + this.serverPort, USER_SPEC + this.userName, "login", PORT_SPEC};
        try {
            try {
                String last;
                String[] lines;
                String bufStr;
                String[] env = null;
                String ssoKey = this.getProperties().getProperty(P4LOGINSSO);
                if (ssoKey == null) {
                    ssoKey = System.getenv(P4LOGINSSO);
                }
                if (ssoKey != null) {
                    env = new String[]{"P4LOGINSSO=" + ssoKey};
                }
                proc = Runtime.getRuntime().exec(args, env);
                outStream = proc.getOutputStream();
                errReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                inStream = proc.getInputStream();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                byte[] buf = new byte[1024];
                int bytesRead = inStream.read(buf);
                if (bytesRead < 0) {
                    errBuf = this.getErrBuf(errReader);
                    if (errBuf.length() > 0) {
                        throw new P4JAccessException(errBuf.toString());
                    }
                } else {
                    useSSO = this.isAllHex(buf, bytesRead);
                }
                if (!useSSO && !(bufStr = new String(buf)).startsWith("'login' not necessary")) {
                    if (pwd == null) {
                        pwd = "\n";
                    }
                    byte[] pwdBytes = pwd.getBytes();
                    outStream.write(pwdBytes, 0, pwdBytes.length);
                    outStream.flush();
                    bytesRead = inStream.read(buf);
                }
                if ((exitCode = proc.waitFor()) != 0 && (errBuf = this.getErrBuf(errReader)).length() > 0) {
                    throw new P4JAccessException(errBuf.toString());
                }
                ArrayList list = new ArrayList();
                HashMap<String, String> map = new HashMap<String, String>(1);
                String ticket = null;
                String ticketString = null;
                if (bytesRead > 0 && (lines = (ticketString = new String(buf, 0, bytesRead)).split("\n")).length > 0 && (last = lines[lines.length - 1].trim()).matches("[A-Z0-9]{32}")) {
                    ticket = last;
                }
                ticketString = ticketString != null && ticketString.startsWith("'login' not necessary") ? null : ticket;
                map.put("authTicket", ticketString);
                list.add(map);
                mapArray = list.toArray(new Map[list.size()]);
                Object var24_26 = null;
            }
            catch (P4JAccessException aecx) {
                throw aecx;
            }
            catch (Exception exc) {
                throw new P4JConnectionException(exc);
            }
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (errReader != null) {
                    errReader.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                proc.destroy();
                throw throwable;
            }
            catch (Exception exc) {
                P4JLog.error("Unexpected exception in P4CmdServerImpl.rawLogin: " + exc);
                P4JLog.exception(exc);
                throw throwable;
            }
        }
        try {}
        catch (Exception exc) {
            P4JLog.error("Unexpected exception in P4CmdServerImpl.rawLogin: " + exc);
            P4JLog.exception(exc);
            return mapArray;
        }
        if (outStream != null) {
            outStream.close();
        }
        if (errReader != null) {
            errReader.close();
        }
        if (inStream != null) {
            inStream.close();
        }
        proc.destroy();
        return mapArray;
    }

    @Override
    public boolean isAuthFail(String errStr) {
        if (errStr != null) {
            for (String str : this.accessErrMsgs) {
                if (!errStr.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] scrubEnv(Map<String, String> systemEnv) {
        String[] cmdEnv = new String[systemEnv.size()];
        int i = 0;
        for (String key : systemEnv.keySet()) {
            if (!key.startsWith("P4") || key.equals(P4LOGINSSO)) {
                cmdEnv[i++] = key + "=" + systemEnv.get(key);
                continue;
            }
            cmdEnv[i++] = "P4JDummy=value" + i;
        }
        return cmdEnv;
    }

    private void addCommonArgs(Vector<String> cmdVec) {
        this.addCommonArgs(null, cmdVec);
    }

    private void addCommonArgs(P4JCmdSpec command, Vector<String> cmdVec) {
        if (cmdVec != null) {
            if (this.authTicket != null) {
                cmdVec.add(PASSWORD_SPEC + this.authTicket);
            }
            if (this.userName != null) {
                cmdVec.add(USER_SPEC + this.userName);
            }
            if (this.client != null) {
                cmdVec.add(CLIENT_SPEC + this.client.getName());
            } else {
                cmdVec.add(CLIENT_SPEC + this.clientUnsetName);
            }
            if (this.isUnicode()) {
                if (command == P4JCmdSpec.SYNC || command == P4JCmdSpec.PRINT || command == P4JCmdSpec.SUBMIT || command == P4JCmdSpec.REVERT || command == P4JCmdSpec.INTEG || command == P4JCmdSpec.MOVE || command == P4JCmdSpec.RESOLVE) {
                    cmdVec.add(CHARSET_SPEC + this.charsetName);
                } else {
                    cmdVec.add("-Cutf8");
                }
            }
        }
    }

    private StringBuffer getErrBuf(BufferedReader errReader) throws IOException {
        StringBuffer errBuf = new StringBuffer();
        String errLine = null;
        while ((errLine = errReader.readLine()) != null) {
            errBuf.append(errLine + "\n");
        }
        return errBuf;
    }

    private String normaliseArgStringForWindows(String str) {
        if (str != null && str.contains("*")) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private boolean isAllHex(byte[] bytes, int len) {
        int bytesToScan = Math.min(bytes.length, len);
        for (int i = 0; i < bytesToScan; ++i) {
            if (!Character.isLetterOrDigit(bytes[i]) || Character.digit(bytes[i], 16) >= 0) continue;
            return false;
        }
        return true;
    }

    private int nonOptionCommandArgCount(String[] args) {
        String MINUS_STR = "-";
        int i = 0;
        if (args != null) {
            for (String arg : args) {
                if (arg == null || arg.startsWith("-")) continue;
                ++i;
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getClientAppVersion() throws P4JConnectionException {
        Process proc = null;
        try {
            try {
                proc = Runtime.getRuntime().exec(new String[]{this.props.getProperty(P4CMD_EXEC_KEY, DEFAULT_P4CMD), "-V"});
                if (proc != null) {
                    InputStream inStream = proc.getInputStream();
                    proc.waitFor();
                    if (inStream != null) {
                        String[] inLines;
                        byte[] iBytes = new byte[1024];
                        int bytesRead = 0;
                        int pos = 0;
                        while ((bytesRead = inStream.read(iBytes, pos, 28)) > 0) {
                            pos += bytesRead;
                        }
                        String inString = new String(iBytes);
                        if (inString != null && (inLines = inString.split("\n")).length >= 3 && inLines[2].startsWith("Rev. ")) {
                            int clientVersion;
                            int n = clientVersion = this.parseVersionString(inLines[2].substring(5));
                            Object var11_11 = null;
                            if (proc == null) return n;
                            proc.destroy();
                            return n;
                        }
                    }
                }
                Object var11_12 = null;
                if (proc == null) return 0;
                proc.destroy();
                return 0;
            }
            catch (Exception exc) {
                P4JLog.warn("Unexpected exception in getClientAppVersion: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
                Object var11_13 = null;
                if (proc == null) return 0;
                proc.destroy();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (proc == null) throw throwable;
            proc.destroy();
            throw throwable;
        }
    }
}

