/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.client;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.client.P4JClient;
import com.perforce.p4java.client.P4JClientView;
import com.perforce.p4java.core.P4JChangeList;
import com.perforce.p4java.core.file.P4JFileSpec;
import com.perforce.p4java.core.file.P4JIntegrationFileSpec;
import com.perforce.p4java.core.file.P4JIntegrationOptions;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.generic.client.P4JClientSpecImpl;
import com.perforce.p4java.impl.generic.core.P4JInputMapper;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JClientImpl
extends P4JServerResourceImpl
implements P4JClient {
    public static final String MERGE_TMP_FILENAME_KEY = "P4JMergeTmpFile";
    private P4JServerImpl serverImpl = null;
    private P4JClientSpecImpl clientSpec = null;

    public P4JClientImpl() {
    }

    public P4JClientImpl(P4JServer serverImpl, P4JClientSpecImpl clientSpec, boolean fullImpl) {
        super(fullImpl, true, true, fullImpl, serverImpl);
        this.serverImpl = (P4JServerImpl)serverImpl;
        this.clientSpec = clientSpec;
    }

    @Override
    public P4JServer getServer() {
        return this.serverImpl;
    }

    private void updateFlags() {
        this.complete = this.clientSpec != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JClient refreshedClient;
        P4JServerImpl refreshServer = this.serverImpl;
        String refreshName = null;
        if (this.clientSpec != null) {
            refreshName = this.clientSpec.getName();
        }
        if (refreshServer != null && refreshName != null && (refreshedClient = refreshServer.getClient(refreshName)) != null) {
            P4JClientSpecImpl newSpec = new P4JClientSpecImpl();
            newSpec.setName(refreshName);
            newSpec.setAccessed(refreshedClient.getAccessed());
            newSpec.setUpdated(refreshedClient.getUpdated());
            newSpec.setAlternateRoots(refreshedClient.getAlternateRoots());
            newSpec.setClientView(refreshedClient.getClientView());
            newSpec.setDescription(refreshedClient.getDescription());
            newSpec.setHostName(refreshedClient.getHostName());
            newSpec.setLineEnd(refreshedClient.getLineEnd());
            newSpec.setOptions(refreshedClient.getOptions());
            newSpec.setOwnerName(refreshedClient.getOwnerName());
            newSpec.setRoot(refreshedClient.getRoot());
            newSpec.setSubmitOptions(refreshedClient.getSubmitOptions());
            newSpec.setUpdated(refreshedClient.getUpdated());
            this.clientSpec = newSpec;
        }
        this.updateFlags();
    }

    @Override
    public void update() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (!this.updateable) {
            throw new P4JUnimplementedError("attempted to update unupdateable client");
        }
        this.serverImpl.updateClient(this);
    }

    @Override
    public Date getAccessed() {
        if (this.clientSpec != null) {
            return this.clientSpec.getAccessed();
        }
        return null;
    }

    @Override
    public List<String> getAlternateRoots() {
        if (this.clientSpec != null) {
            return this.clientSpec.getAlternateRoots();
        }
        return null;
    }

    @Override
    public P4JClientView getClientView() {
        if (this.clientSpec != null) {
            return this.clientSpec.getClientView();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.clientSpec != null) {
            return this.clientSpec.getDescription();
        }
        return null;
    }

    @Override
    public String getHostName() {
        if (this.clientSpec != null) {
            return this.clientSpec.getHostName();
        }
        return null;
    }

    @Override
    public P4JClient.P4JClientLineEnd getLineEnd() {
        if (this.clientSpec != null) {
            return this.clientSpec.getLineEnd();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.clientSpec != null) {
            return this.clientSpec.getName();
        }
        return null;
    }

    @Override
    public P4JClient.P4JClientOptions getOptions() {
        if (this.clientSpec != null) {
            return this.clientSpec.getOptions();
        }
        return null;
    }

    @Override
    public String getOwnerName() {
        if (this.clientSpec != null) {
            return this.clientSpec.getOwnerName();
        }
        return null;
    }

    @Override
    public String getRoot() {
        if (this.clientSpec != null) {
            return this.clientSpec.getRoot();
        }
        return null;
    }

    @Override
    public P4JClient.P4JClientSubmitOptions getSubmitOptions() {
        if (this.clientSpec != null) {
            return this.clientSpec.getSubmitOptions();
        }
        return null;
    }

    @Override
    public Date getUpdated() {
        if (this.clientSpec != null) {
            return this.clientSpec.getUpdated();
        }
        return null;
    }

    public void setServer(P4JServer server) {
        this.serverImpl = (P4JServerImpl)server;
    }

    @Override
    public List<P4JFileSpec> sync(List<P4JFileSpec> fileSpecs, boolean forceUpdate, boolean noUpdate, boolean clientBypass, boolean serverBypass) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        Map<String, Object>[] syncMap;
        int argSize = 0;
        ArrayList<P4JFileSpec> specList = new ArrayList<P4JFileSpec>();
        if (forceUpdate) {
            ++argSize;
        }
        if (noUpdate) {
            ++argSize;
        }
        if (clientBypass) {
            ++argSize;
        }
        if (serverBypass) {
            ++argSize;
        }
        String[] args = new String[argSize];
        int i = 0;
        if (forceUpdate) {
            args[i++] = "-f";
        }
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (clientBypass) {
            args[i++] = "-k";
        }
        if (serverBypass) {
            args[i++] = "-p";
        }
        if ((syncMap = this.serverImpl.execMapCmd(P4JCmdSpec.SYNC, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : syncMap) {
                specList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return specList;
    }

    @Override
    public List<P4JFileSpec> labelSync(List<P4JFileSpec> fileSpecs, String labelName, boolean noUpdate, boolean addFiles, boolean deleteFiles) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (labelName == null) {
            throw new P4JNullPointerError("null label name passed to P4JClientImpl.labelSync()");
        }
        String[] args = null;
        int argNum = 1;
        if (noUpdate) {
            ++argNum;
        }
        if (addFiles) {
            ++argNum;
        }
        if (deleteFiles) {
            ++argNum;
        }
        if (fileSpecs != null) {
            argNum += fileSpecs.size();
        }
        args = new String[argNum];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (addFiles) {
            args[i++] = "-a";
        }
        if (deleteFiles) {
            args[i++] = "-d";
        }
        args[i++] = "-l" + labelName;
        ArrayList<P4JFileSpec> specList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] syncMap = this.serverImpl.execMapCmd(P4JCmdSpec.LABELSYNC, P4JServerImpl.populatePathArray(args, i, fileSpecs), null);
        if (syncMap != null) {
            for (Map<String, Object> map : syncMap) {
                specList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return specList;
    }

    @Override
    public P4JChangeList newChangeList(P4JChangeList newChangeList) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.clientSpec == null) {
            throw new P4JNullPointerError("Null client spec in newChangeList method call");
        }
        if (this.getName() == null) {
            throw new P4JNullPointerError("Null client name in newChangeList method call");
        }
        if (newChangeList == null) {
            throw new P4JNullPointerError("Null new change list specification in newChangeList method call");
        }
        if (newChangeList.getId() != -1) {
            throw new P4JRequestException("New changelist ID must be set to P4JChangeList.UNKNOWN");
        }
        Map<String, Object>[] changeMap = this.serverImpl.execMapCmd(P4JCmdSpec.CHANGE, new String[]{"-i"}, P4JInputMapper.map(newChangeList));
        if (changeMap != null) {
            int id = -1;
            for (Map<String, Object> map : changeMap) {
                if (!this.serverImpl.handleErrorStr(map)) {
                    if (map.containsKey("change")) {
                        int i;
                        String changeStr = (String)map.get("change");
                        if (changeStr != null && (i = changeStr.indexOf(" ")) > 0 && i < changeStr.length()) {
                            try {
                                id = new Integer(changeStr.substring(i + 1));
                            }
                            catch (Exception exc) {
                                P4JLog.error("Unexpected exception in P4JClientImpl.newChangeList: " + exc.getLocalizedMessage());
                                P4JLog.exception(exc);
                            }
                        }
                    } else {
                        String[] strs;
                        String infoStr = this.serverImpl.getInfoStr(map);
                        if (infoStr != null && infoStr.contains("Change ") && infoStr.contains(" created") && (strs = infoStr.split(" ")).length >= 3 && strs[1] != null) {
                            id = -1;
                            try {
                                id = new Integer(strs[1]);
                            }
                            catch (Exception exc) {
                                P4JLog.error("Unexpected exception in P4JClientImpl.newChangeList: " + exc.getLocalizedMessage());
                                P4JLog.exception(exc);
                            }
                        }
                    }
                }
                if (id == -1) continue;
                return this.serverImpl.getChangeList(id);
            }
        }
        return null;
    }

    @Override
    public List<P4JFileSpec> addFiles(List<P4JFileSpec> fileSpecs, boolean noUpdate, int changeListId, String fileType, boolean useWildcards) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] addMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        if (useWildcards) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if (useWildcards) {
            args[i++] = "-f";
        }
        if ((addMap = this.serverImpl.execMapCmd(P4JCmdSpec.ADD, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : addMap) {
                resultList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> deleteFiles(List<P4JFileSpec> fileSpecs, int changeListId, boolean noUpdate) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] deleteMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if ((deleteMap = this.serverImpl.execMapCmd(P4JCmdSpec.DELETE, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : deleteMap) {
                resultList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> editFiles(List<P4JFileSpec> fileSpecs, boolean noUpdate, int changeListId, String fileType) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] editMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if ((editMap = this.serverImpl.execMapCmd(P4JCmdSpec.EDIT, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : editMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> revertFiles(List<P4JFileSpec> fileSpecs, boolean noUpdate, int changeListId, boolean revertOnlyUnchanged, boolean noRefresh) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] revertMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (revertOnlyUnchanged) {
            ++argCount;
        }
        if (noRefresh) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId == 0) {
            args[i++] = "-cdefault";
        } else if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (revertOnlyUnchanged) {
            args[i++] = "-a";
        }
        if (noRefresh) {
            args[i++] = "-k";
        }
        if ((revertMap = this.serverImpl.execMapCmd(P4JCmdSpec.REVERT, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : revertMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> haveList(List<P4JFileSpec> fileSpecs) throws P4JConnectionException, P4JAccessException {
        ArrayList<P4JFileSpec> haveList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] haveMap = this.serverImpl.execMapCmd(P4JCmdSpec.HAVE, P4JServerImpl.getPreferredPathArray(null, fileSpecs), null);
        if (haveMap != null) {
            for (Map<String, Object> result : haveMap) {
                haveList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return haveList;
    }

    @Override
    public List<P4JFileSpec> reopenFiles(List<P4JFileSpec> fileSpecs, int changeListId, String fileType) throws P4JConnectionException, P4JAccessException {
        Map<String, Object>[] resultsMap;
        int argCount = 0;
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        String[] args = new String[argCount];
        int i = 0;
        if (changeListId == 0) {
            args[i++] = "-cdefault";
        } else if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if ((resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.REOPEN, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : resultsMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> where(List<P4JFileSpec> fileSpecs) throws P4JConnectionException, P4JAccessException {
        ArrayList<P4JFileSpec> resultList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] whereMap = this.serverImpl.execMapCmd(P4JCmdSpec.WHERE, P4JServerImpl.getPreferredPathArray(null, fileSpecs), null);
        if (whereMap != null) {
            for (Map<String, Object> result : whereMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<P4JFileSpec> openedFiles(List<P4JFileSpec> fileSpecs, int maxFiles, int changeListId) throws P4JConnectionException, P4JAccessException {
        return this.serverImpl.openedFiles(fileSpecs, false, this.getName(), maxFiles, changeListId);
    }

    @Override
    public List<P4JFileSpec> openedStatus(List<P4JFileSpec> fileSpecs) throws P4JConnectionException, P4JAccessException {
        throw new P4JUnimplementedError("Unimplemented method");
    }

    @Override
    public List<P4JIntegrationFileSpec> integrateFiles(int changeListId, boolean showActionsOnly, P4JIntegrationOptions integOpts, String branchSpec, P4JFileSpec fromFile, P4JFileSpec toFile) throws P4JConnectionException, P4JAccessException {
        if (integOpts == null) {
            integOpts = new P4JIntegrationOptions();
        }
        int argSize = 0;
        if (fromFile != null) {
            ++argSize;
        }
        if (toFile != null) {
            ++argSize;
        }
        if (changeListId != 0 && changeListId != -1) {
            ++argSize;
        }
        if (showActionsOnly) {
            ++argSize;
        }
        if (branchSpec != null) {
            ++argSize;
        }
        if (integOpts.isUseHaveRev()) {
            ++argSize;
        }
        if (integOpts.isBaselessMerge()) {
            ++argSize;
        }
        if (integOpts.isDisplayBaseDetails()) {
            ++argSize;
        }
        if (integOpts.isPropagateType()) {
            ++argSize;
        }
        if (integOpts.isDontCopyToClient()) {
            ++argSize;
        }
        if (integOpts.isForce()) {
            ++argSize;
        }
        if (integOpts.getDeletedOptions() != null) {
            argSize += integOpts.getDeletedOptions().length;
        }
        if (integOpts.isBidirectionalInteg()) {
            ++argSize;
        }
        if (integOpts.isReverseMapping()) {
            ++argSize;
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId != 0 && changeListId != -1) {
            args[i++] = "-c" + changeListId;
        }
        if (showActionsOnly) {
            args[i++] = "-n";
        }
        if (integOpts.isUseHaveRev()) {
            args[i++] = "-h";
        }
        if (integOpts.isBaselessMerge()) {
            args[i++] = "-i";
        }
        if (integOpts.isDisplayBaseDetails()) {
            args[i++] = "-o";
        }
        if (integOpts.isPropagateType()) {
            args[i++] = "-t";
        }
        if (integOpts.isDontCopyToClient()) {
            args[i++] = "-v";
        }
        if (integOpts.isForce()) {
            args[i++] = "-f";
        }
        if (integOpts.getDeletedOptions() != null) {
            for (String str : integOpts.getDeletedOptions()) {
                if (str == null) {
                    throw new P4JNullPointerError("Null entry in integrateFiles delete option array");
                }
                args[i++] = "-" + str;
            }
        }
        if (integOpts.isReverseMapping()) {
            args[i++] = "-r";
        }
        if (branchSpec != null) {
            args[i++] = "-b" + branchSpec;
        }
        if (integOpts.isBidirectionalInteg()) {
            args[i++] = "-s";
        }
        if (fromFile != null) {
            args[i++] = fromFile.getPreferredPath();
        }
        if (toFile != null) {
            args[i++] = toFile.getPreferredPath();
        }
        ArrayList<P4JIntegrationFileSpec> integList = new ArrayList<P4JIntegrationFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.INTEG, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                integList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return integList;
    }

    @Override
    public List<P4JIntegrationFileSpec> resolveFilesAuto(List<P4JFileSpec> fileSpecs, boolean safeMerge, boolean acceptTheirs, boolean acceptYours, boolean showActionsOnly, boolean forceResolve) throws P4JConnectionException, P4JAccessException {
        int argSize = 0;
        if (safeMerge) {
            ++argSize;
        }
        if (showActionsOnly) {
            ++argSize;
        }
        if (acceptTheirs) {
            ++argSize;
        }
        if (acceptYours) {
            ++argSize;
        }
        if (!(forceResolve || acceptYours || acceptTheirs || safeMerge)) {
            ++argSize;
        }
        if (forceResolve) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (!(forceResolve || acceptTheirs || acceptYours || safeMerge)) {
            args[i++] = "-am";
        }
        if (safeMerge) {
            args[i++] = "-as";
        }
        if (acceptYours) {
            args[i++] = "-ay";
        }
        if (acceptTheirs) {
            args[i++] = "-at";
        }
        if (showActionsOnly) {
            args[i++] = "-n";
        }
        if (forceResolve) {
            args[i++] = "-af";
        }
        ArrayList<P4JIntegrationFileSpec> resolveList = new ArrayList<P4JIntegrationFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.RESOLVE, P4JServerImpl.populatePathArray(args, i, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resolveList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return resolveList;
    }

    @Override
    public P4JIntegrationFileSpec resolveFile(P4JFileSpec targetFile, InputStream sourceStream) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (targetFile == null) {
            throw new P4JNullPointerError("Null target file spec passed to P4JClient.resolveFile");
        }
        if (sourceStream == null) {
            throw new P4JNullPointerError("Null source stream passed to P4JClient.resolveFile");
        }
        if (!(this.serverImpl instanceof P4JRpcServerImpl)) {
            throw new P4JRequestException("Request not supported by the current P4Java implementation; use an RPC-based pure Java implementation if possible");
        }
        HashMap<String, Object> resolveMap = new HashMap<String, Object>();
        P4JIntegrationFileSpec fileSpec = null;
        if (this.serverImpl != null) {
            File tmpFile = null;
            try {
                Map<String, Object>[] resultMaps;
                File tmpDir = new File(this.serverImpl.getProperties().getProperty("com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                tmpFile = File.createTempFile("p4java", ".tmp", tmpDir);
                if (tmpFile != null) {
                    FileOutputStream outStream = new FileOutputStream(tmpFile);
                    byte[] bytes = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = sourceStream.read(bytes)) > 0) {
                        outStream.write(bytes, 0, bytesRead);
                    }
                    outStream.close();
                    resolveMap.put(MERGE_TMP_FILENAME_KEY, tmpFile.getPath());
                }
                if ((resultMaps = this.serverImpl.execMapCmd(P4JCmdSpec.RESOLVE, new String[]{targetFile.getPreferredPath()}, resolveMap)) != null) {
                    P4JIntegrationFileSpec p4JIntegrationFileSpec;
                    if (resultMaps.length > 1) {
                        p4JIntegrationFileSpec = this.serverImpl.handleIntegrationFileReturn(resultMaps[1], true);
                        return p4JIntegrationFileSpec;
                    }
                    p4JIntegrationFileSpec = this.serverImpl.handleIntegrationFileReturn(resultMaps[0], false);
                    return p4JIntegrationFileSpec;
                }
            }
            catch (IOException exc) {
                P4JLog.error("local file I/O error on resolve: " + exc.getMessage());
                P4JLog.exception(exc);
                throw new P4JError("local file I/O error on resolve: " + exc.getMessage());
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return fileSpec;
    }

    @Override
    public List<P4JIntegrationFileSpec> resolvedFiles(List<P4JFileSpec> fileSpecs, boolean showBaseRevision) throws P4JConnectionException, P4JAccessException {
        int argSize = 0;
        if (showBaseRevision) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (showBaseRevision) {
            args[i++] = "-o";
        }
        ArrayList<P4JIntegrationFileSpec> resolvedList = new ArrayList<P4JIntegrationFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.RESOLVED, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resolvedList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return resolvedList;
    }

    @Override
    public List<P4JFileSpec> lockFiles(List<P4JFileSpec> fileSpecs, int changeListId) throws P4JConnectionException, P4JAccessException {
        int argSize = 0;
        if (changeListId == 0 || changeListId > 0) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId == 0 || changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        ArrayList<P4JFileSpec> lockedList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.LOCK, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                lockedList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return lockedList;
    }

    @Override
    public List<P4JFileSpec> unlockFiles(List<P4JFileSpec> fileSpecs, int changeListId, boolean force) throws P4JConnectionException, P4JAccessException {
        int argSize = 0;
        if (changeListId == 0 || changeListId > 0) {
            ++argSize;
        }
        if (force) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId == 0 || changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        if (force) {
            args[i++] = "-f";
        }
        ArrayList<P4JFileSpec> unlockedList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.UNLOCK, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                unlockedList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return unlockedList;
    }

    @Override
    public List<P4JFileSpec> getDiffFileList(List<P4JFileSpec> fileSpecs, int maxFiles, boolean diffNonTextFiles, boolean openedDifferentMissing, boolean openedForIntegrate, boolean unopenedMissing, boolean unopenedDifferent, boolean unopenedWithStatus, boolean openedSame) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int argSize = 0;
        boolean sFlag = false;
        if (maxFiles > 0) {
            ++argSize;
        }
        if (diffNonTextFiles) {
            ++argSize;
            sFlag = true;
        }
        if (openedDifferentMissing) {
            ++argSize;
            sFlag = true;
        }
        if (openedForIntegrate) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedMissing) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedDifferent) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedWithStatus) {
            ++argSize;
            sFlag = true;
        }
        if (openedSame) {
            ++argSize;
            sFlag = true;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        if (!sFlag) {
            throw new P4JRequestException("No 's' option set for P4JClient.getDiffFileList method");
        }
        String[] args = new String[argSize];
        int i = 0;
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (diffNonTextFiles) {
            args[i++] = "-t";
        }
        if (openedDifferentMissing) {
            args[i++] = "-sa";
        }
        if (openedForIntegrate) {
            args[i++] = "-sb";
        }
        if (unopenedMissing) {
            args[i++] = "-sd";
        }
        if (unopenedDifferent) {
            args[i++] = "-se";
        }
        if (unopenedWithStatus) {
            args[i++] = "-sl";
        }
        if (openedSame) {
            args[i++] = "-sr";
        }
        ArrayList<P4JFileSpec> diffList = new ArrayList<P4JFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(P4JCmdSpec.DIFF, P4JServerImpl.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                diffList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return diffList;
    }
}

