/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.client.P4JClient;
import com.perforce.p4java.core.file.P4JFileAction;
import com.perforce.p4java.core.file.P4JFileRevisionData;
import com.perforce.p4java.core.file.P4JFileSpec;
import com.perforce.p4java.core.file.P4JFileSpecBuilder;
import com.perforce.p4java.core.file.P4JFileSpecOpStatus;
import com.perforce.p4java.core.file.P4JIntegrationFileSpec;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.server.P4JServer;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JFileSpecImpl
extends P4JServerResourceImpl
implements P4JFileSpec,
P4JIntegrationFileSpec {
    protected static final String REV_PFX = "#";
    protected static final String REV_SEP = ",#";
    protected static final String NONREV_PFX = "@";
    protected P4JFileSpecOpStatus opStatus = P4JFileSpecOpStatus.VALID;
    protected String statusMessage = null;
    protected int genericCode = 0;
    protected int severityCode = 0;
    protected String path = null;
    protected String depotPath = null;
    protected String clientPath = null;
    protected String localPath = null;
    protected String fileType = null;
    protected int startRevision = -1;
    protected int endRevision = -1;
    protected int changeListId = -1;
    protected String label = null;
    protected Date date = null;
    protected P4JFileAction action = null;
    protected String userName = null;
    protected String clientName = null;
    protected boolean unmap = false;
    private String fromFile = null;
    private int endFromRev = -1;
    private int startFromRev = -1;
    private String toFile = null;
    private int endToRev = -1;
    private int startToRev = -1;
    private int workRev = -1;
    private String howResolved = null;
    private P4JFileAction otherAction = null;
    private boolean locked = false;
    private String diffStatus = null;
    protected P4JServer server = null;
    protected P4JClient client = null;

    public P4JFileSpecImpl() {
        super(true, false, false, false);
    }

    public P4JFileSpecImpl(String pathStr) {
        super(true, false, false, false);
        this.path = P4JFileSpecImpl.parsePathString(pathStr, this);
    }

    public P4JFileSpecImpl(P4JFileSpecOpStatus status, String errStr) {
        super(true, false, false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
    }

    public P4JFileSpecImpl(P4JFileSpecOpStatus status, String errStr, int genericCode, int severityCode) {
        super(true, false, false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
        this.genericCode = genericCode;
        this.severityCode = severityCode;
    }

    public P4JFileSpecImpl(P4JFileSpecImpl impl) {
        super(true, false, false, false);
        if (impl == null) {
            throw new P4JNullPointerError("null impl passed to P4JFileSpecImpl constructor");
        }
        this.opStatus = impl.opStatus;
        this.statusMessage = impl.statusMessage;
        this.genericCode = impl.genericCode;
        this.severityCode = impl.severityCode;
        this.path = impl.path;
        this.depotPath = impl.depotPath;
        this.clientPath = impl.clientPath;
        this.localPath = impl.localPath;
        this.fileType = impl.fileType;
        this.startRevision = impl.startRevision;
        this.endRevision = impl.endRevision;
        this.changeListId = impl.changeListId;
        this.label = impl.label;
        this.date = impl.date;
        this.action = impl.action;
        this.userName = impl.userName;
        this.clientName = impl.clientName;
        this.unmap = impl.unmap;
        this.fromFile = impl.fromFile;
        this.endFromRev = impl.endFromRev;
        this.startFromRev = impl.startFromRev;
        this.toFile = impl.toFile;
        this.endToRev = impl.endToRev;
        this.startToRev = impl.startToRev;
        this.workRev = impl.workRev;
        this.howResolved = impl.howResolved;
        this.otherAction = impl.otherAction;
        this.locked = impl.locked;
        this.diffStatus = impl.diffStatus;
        this.server = impl.server;
        this.client = impl.client;
    }

    public P4JFileSpecImpl(Map<String, Object> map, P4JServer server, int index) {
        super(true, false, false, false);
        if (map != null) {
            this.setOpStatus(P4JFileSpecOpStatus.VALID);
            String indexStr = "";
            if (index >= 0) {
                indexStr = indexStr + index;
            }
            this.setServer(server);
            this.setDepotPath((String)map.get("depotFile" + indexStr));
            this.setClientPath((String)map.get("clientFile" + indexStr));
            this.setLocalPath((String)map.get("path" + indexStr));
            this.setFileType((String)map.get("type" + indexStr));
            this.setAction(P4JFileAction.fromString((String)map.get("action" + indexStr)));
            this.setUserName((String)map.get("user" + indexStr));
            this.setClientName((String)map.get("client" + indexStr));
            String cid = (String)map.get("change" + indexStr);
            String revStr = (String)map.get("rev" + indexStr);
            if (revStr == null) {
                revStr = (String)map.get("haveRev" + indexStr);
            }
            this.setLocked(map.get("ourLock") != null);
            this.setEndRevision(P4JFileSpecImpl.getRevFromString(revStr));
            if (cid == null) {
                this.setChangeListId(-1);
            } else if (cid.equalsIgnoreCase("default") || cid.equalsIgnoreCase("default change")) {
                this.setChangeListId(0);
            } else {
                int i = cid.indexOf(" ");
                if (i < 0) {
                    this.setChangeListId(new Integer(cid));
                } else {
                    this.setChangeListId(new Integer(cid.substring(i + 1)));
                }
            }
            this.setEndFromRev(P4JFileSpecImpl.getRevFromString((String)map.get("endFromRev" + indexStr)));
            this.setStartFromRev(P4JFileSpecImpl.getRevFromString((String)map.get("startFromRev" + indexStr)));
            this.setWorkRev(P4JFileSpecImpl.getRevFromString((String)map.get("workRev" + indexStr)));
            this.setHowResolved((String)map.get("how"));
            this.setFromFile((String)map.get("fromFile" + indexStr));
            this.setEndToRev(P4JFileSpecImpl.getRevFromString((String)map.get("endToRev" + indexStr)));
            this.setStartToRev(P4JFileSpecImpl.getRevFromString((String)map.get("startToRev" + indexStr)));
            this.setToFile((String)map.get("toFile" + indexStr));
            this.setOtherAction(P4JFileAction.fromString((String)map.get("otherAction" + indexStr)));
            this.setDiffStatus((String)map.get("status"));
            if ((String)map.get("unmap" + indexStr) != null) {
                this.unmap = true;
            }
            this.setUnmap((String)map.get("unmap" + indexStr) != null);
        }
    }

    @Override
    public P4JFileAction getAction() {
        return this.action;
    }

    @Override
    public int getChangeListId() {
        return this.changeListId;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getClientPath() {
        return this.clientPath;
    }

    @Override
    public InputStream getContents(boolean noHeaderLine) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        ArrayList<P4JFileSpec> fList = new ArrayList<P4JFileSpec>();
        fList.add(this);
        return this.server.getFileContents(fList, false, noHeaderLine);
    }

    @Override
    public String getDepotPath() {
        return this.depotPath;
    }

    @Override
    public String getDisplayPath(String path) {
        if (path != null) {
            if (this.startRevision != -1 || this.endRevision != -1) {
                return path + REV_PFX + (this.startRevision == -1 ? "" : this.startRevision + REV_SEP) + (this.endRevision == -1 ? "" : (this.endRevision == -17 ? "head" : Integer.valueOf(this.endRevision)));
            }
            if (this.changeListId != -1) {
                return path + NONREV_PFX + this.changeListId;
            }
            if (this.label != null) {
                return path + NONREV_PFX + this.label;
            }
            if (this.date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss");
                StringBuffer sBuf = new StringBuffer();
                sdf.format(this.date, sBuf, new FieldPosition(0));
                return path + NONREV_PFX + sBuf.toString();
            }
        }
        return path;
    }

    @Override
    public String getDisplayPath() {
        return this.getDisplayPath(this.getPreferredPath());
    }

    @Override
    public int getEndRevision() {
        return this.endRevision;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public P4JFileSpecOpStatus getOpStatus() {
        return this.opStatus;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPreferredPath(boolean annotate) {
        String pathStr = null;
        if (this.path != null) {
            pathStr = this.path;
        } else if (this.depotPath != null) {
            pathStr = this.depotPath;
        } else if (this.clientPath != null) {
            pathStr = this.clientPath;
        } else if (this.localPath != null) {
            pathStr = this.localPath;
        }
        if (pathStr != null && annotate) {
            return this.getDisplayPath(pathStr);
        }
        return pathStr;
    }

    @Override
    public String getPreferredPath() {
        return this.getPreferredPath(true);
    }

    @Override
    public Map<P4JFileSpec, List<P4JFileRevisionData>> getRevisionHistory(int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.server == null) {
            throw new P4JError("File specification is not associated with any server");
        }
        return this.server.revisionHistory(P4JFileSpecBuilder.makeFileSpecList(new String[]{this.depotPath}), maxRevs, contentHistory, includeInherited, longOutput, truncatedLongOutput);
    }

    @Override
    public List<P4JFileSpec> move(int changelistId, boolean listOnly, String fileType, P4JFileSpec toFile) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.server == null) {
            throw new P4JError("File specification is not associated with any server");
        }
        return this.server.moveFile(changelistId, listOnly, fileType, this, toFile);
    }

    @Override
    public int getStartRevision() {
        return this.startRevision;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public int getSeverityCode() {
        return this.severityCode;
    }

    @Override
    public int getGenericCode() {
        return this.genericCode;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public String getDiffStatus() {
        return this.diffStatus;
    }

    public void setOpStatus(P4JFileSpecOpStatus opStatus) {
        this.opStatus = opStatus;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDepotPath(String depotPath) {
        this.depotPath = depotPath;
    }

    public void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setStartRevision(int startRevision) {
        this.startRevision = startRevision;
    }

    public void setEndRevision(int endRevision) {
        this.endRevision = endRevision;
    }

    public void setChangeListId(int changeListId) {
        this.changeListId = changeListId;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAction(P4JFileAction action) {
        this.action = action;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setServer(P4JServer server) {
        this.server = server;
    }

    public void setClient(P4JClient client) {
        this.client = client;
    }

    public static String getSimplePath(String pathStr) {
        if (pathStr != null) {
            int i = 0;
            i = pathStr.lastIndexOf(REV_PFX);
            if (i >= 0) {
                return pathStr.substring(0, i);
            }
            i = pathStr.lastIndexOf(NONREV_PFX);
            if (i >= 0) {
                return pathStr.substring(0, i);
            }
            return pathStr;
        }
        return null;
    }

    public static String parsePathString(String pathStr, P4JFileSpecImpl impl) {
        if (pathStr != null && impl != null) {
            if (pathStr.contains(REV_PFX)) {
                return P4JFileSpecImpl.extractRevisions(pathStr, impl);
            }
            if (pathStr.contains(NONREV_PFX)) {
                return P4JFileSpecImpl.extractNonRevData(pathStr, impl);
            }
        }
        return pathStr;
    }

    public static String getNonRevStringFromPath(String labelStr) {
        int i;
        if (labelStr != null && (i = labelStr.lastIndexOf(NONREV_PFX)) > 0 && i < labelStr.length()) {
            return labelStr.substring(i + 1);
        }
        return null;
    }

    @Override
    public int getEndFromRev() {
        return this.endFromRev;
    }

    @Override
    public int getEndToRev() {
        return this.endToRev;
    }

    @Override
    public String getFromFile() {
        return this.fromFile;
    }

    @Override
    public String getHowResolved() {
        return this.howResolved;
    }

    @Override
    public P4JFileAction getOtherAction() {
        return this.otherAction;
    }

    @Override
    public int getStartFromRev() {
        return this.startFromRev;
    }

    @Override
    public int getStartToRev() {
        return this.startToRev;
    }

    @Override
    public String getToFile() {
        return this.toFile;
    }

    @Override
    public int getWorkRev() {
        return this.workRev;
    }

    @Override
    public boolean isUnmap() {
        return this.unmap;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFromFile(String fromFile) {
        this.fromFile = fromFile;
    }

    public void setEndFromRev(int endFromRev) {
        this.endFromRev = endFromRev;
    }

    public void setStartFromRev(int startFromRev) {
        this.startFromRev = startFromRev;
    }

    public void setToFile(String toFile) {
        this.toFile = toFile;
    }

    public void setEndToRev(int endToRev) {
        this.endToRev = endToRev;
    }

    public void setStartToRev(int startToRev) {
        this.startToRev = startToRev;
    }

    public void setWorkRev(int workRev) {
        this.workRev = workRev;
    }

    public void setHowResolved(String howResolved) {
        this.howResolved = howResolved;
    }

    public void setOtherAction(P4JFileAction otherAction) {
        this.otherAction = otherAction;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setDiffStatus(String diffStatus) {
        this.diffStatus = diffStatus;
    }

    public void setUnmap(boolean unmap) {
        this.unmap = unmap;
    }

    public static int getRevFromString(String str) {
        int rev = -1;
        if (str != null) {
            if (str.contains("head")) {
                return -17;
            }
            if (str.contains("none")) {
                return -1;
            }
            try {
                if (str.startsWith(REV_PFX) && str.length() > 1) {
                    rev = new Integer(str.substring(1));
                } else if (str.length() > 0) {
                    rev = new Integer(str);
                }
            }
            catch (Exception exc) {
                P4JLog.error("Conversion error in P4JFileSpecImpl.getRevFromString: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
            }
        }
        return rev;
    }

    protected static String extractRevisions(String pathStr, P4JFileSpecImpl impl) {
        if (pathStr != null && impl != null) {
            Matcher mat = Pattern.compile("(#)(\\d+),#(\\d+)$").matcher(pathStr);
            if (mat.find()) {
                impl.startRevision = new Integer(mat.group(2));
                impl.endRevision = new Integer(mat.group(3));
                return pathStr.substring(0, mat.start(1));
            }
            mat = Pattern.compile("^.+(#)(\\d+),#head$").matcher(pathStr);
            if (mat.find()) {
                impl.startRevision = new Integer(mat.group(2));
                impl.endRevision = -17;
                return pathStr.substring(0, mat.start(1));
            }
            mat = Pattern.compile("^.+(#)(\\d+)$").matcher(pathStr);
            if (mat.find()) {
                impl.startRevision = -1;
                impl.endRevision = new Integer(mat.group(2));
                return pathStr.substring(0, mat.start(1));
            }
            mat = Pattern.compile("^.+(#head)$").matcher(pathStr);
            if (mat.find()) {
                impl.startRevision = -1;
                impl.endRevision = -17;
                return pathStr.substring(0, mat.start(1));
            }
        }
        return pathStr;
    }

    protected static String extractNonRevData(String pathStr, P4JFileSpecImpl impl) {
        if (pathStr != null && impl != null) {
            try {
                Matcher mat = Pattern.compile("^.+(@)(\\d+)$").matcher(pathStr);
                if (mat.find()) {
                    impl.changeListId = new Integer(mat.group(2));
                    return pathStr.substring(0, mat.start(1));
                }
                mat = Pattern.compile("^.+(@)(\\w+\\d*)$").matcher(pathStr);
                if (mat.find()) {
                    impl.label = mat.group(2);
                    return pathStr.substring(0, mat.start(1));
                }
                mat = Pattern.compile("^.+(@)(\\d+\\/\\d+\\/\\d+)$").matcher(pathStr);
                if (mat.find()) {
                    impl.date = new SimpleDateFormat("yyyy/MM/dd").parse(mat.group(2));
                    return pathStr.substring(0, mat.start(1));
                }
                mat = Pattern.compile("^.+(@)(\\d+\\/\\d+\\/\\d+:\\d+:\\d+:\\d+)$").matcher(pathStr);
                if (mat.find()) {
                    impl.date = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss").parse(mat.group(2));
                    return pathStr.substring(0, mat.start(1));
                }
            }
            catch (Exception exc) {
                P4JLog.error("Unexpected parse exception in extractNonRevData: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
            }
        }
        return pathStr;
    }
}

