/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.core.file.P4JFileAction;
import com.perforce.p4java.core.file.P4JFileRevisionData;
import com.perforce.p4java.core.file.P4JRevisionIntegrationData;
import com.perforce.p4java.impl.generic.core.file.P4JFileSpecImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JFileRevisionDataImpl
implements P4JFileRevisionData {
    private int revision = 0;
    private int changeListId = -1;
    private P4JFileAction action = null;
    private Date date = null;
    private String userName = null;
    private String fileType = null;
    private String description = null;
    private String depotFileName = null;
    private String clientName = null;
    private List<P4JRevisionIntegrationData> revisionIntegrationData = null;

    public P4JFileRevisionDataImpl() {
    }

    public P4JFileRevisionDataImpl(int revision, int changeListId, P4JFileAction action, Date date, String userName, String fileType, String description, String depotFileName, String clientName) {
        this.revision = revision;
        this.changeListId = changeListId;
        this.action = action;
        this.date = date;
        this.userName = userName;
        this.fileType = fileType;
        this.description = description;
        this.depotFileName = depotFileName;
        this.clientName = clientName;
    }

    public P4JFileRevisionDataImpl(Map<String, Object> map, int revNo) {
        if (map != null) {
            String revStr = "";
            if (map != null) {
                if (revNo >= 0) {
                    revStr = revStr + revNo;
                }
                this.setRevision(new Integer((String)map.get("rev" + revNo)));
                this.setChangeListId(new Integer((String)map.get("change" + revStr)));
                this.setAction(P4JFileAction.fromString((String)map.get("action" + revStr)));
                this.setDate(new Date(Long.parseLong((String)map.get("time" + revStr)) * 1000L));
                this.setUserName((String)map.get("user" + revStr));
                this.setFileType((String)map.get("type" + revStr));
                this.setDescription((String)map.get("desc" + revStr));
                this.setDepotFileName((String)map.get("depotFile"));
                this.setClientName((String)map.get("client" + revStr));
                int revRev = 0;
                String fromFile = (String)map.get("file" + revNo + "," + revRev);
                while (fromFile != null) {
                    if (this.revisionIntegrationData == null) {
                        this.revisionIntegrationData = new ArrayList<P4JRevisionIntegrationData>();
                    }
                    this.revisionIntegrationData.add(new P4JRevisionIntegrationDataImpl((String)map.get("srev" + revNo + "," + revRev), (String)map.get("erev" + revNo + "," + revRev), fromFile, (String)map.get("how" + revNo + "," + revRev)));
                    fromFile = (String)map.get("file" + revNo + "," + ++revRev);
                }
            }
        }
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getChangeListId() {
        return this.changeListId;
    }

    public void setChangeListId(int changeListId) {
        this.changeListId = changeListId;
    }

    @Override
    public P4JFileAction getAction() {
        return this.action;
    }

    public void setAction(P4JFileAction action) {
        this.action = action;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDepotFileName() {
        return this.depotFileName;
    }

    public void setDepotFileName(String depotFileName) {
        this.depotFileName = depotFileName;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public List<P4JRevisionIntegrationData> getRevisionIntegrationData() {
        return this.revisionIntegrationData;
    }

    public class P4JRevisionIntegrationDataImpl
    implements P4JRevisionIntegrationData {
        private int startFromRev = 0;
        private int endFromRev = 0;
        private String fromFile = null;
        private String howFrom = null;

        public P4JRevisionIntegrationDataImpl(String startFromRev, String endFromRev, String fromFile, String howFrom) {
            this.startFromRev = P4JFileSpecImpl.getRevFromString(startFromRev);
            this.endFromRev = P4JFileSpecImpl.getRevFromString(endFromRev);
            this.fromFile = fromFile;
            this.howFrom = howFrom;
        }

        public int getEndFromRev() {
            return this.endFromRev;
        }

        public String getFromFile() {
            return this.fromFile;
        }

        public String getHowFrom() {
            return this.howFrom;
        }

        public int getStartFromRev() {
            return this.startFromRev;
        }
    }
}

