/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.client.P4JClientView;
import com.perforce.p4java.core.P4JLabel;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.client.P4JClientViewImpl;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.server.P4JServer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JLabelImpl
extends P4JServerResourceImpl
implements P4JLabel {
    private static final String LOCKED_VALUE = "locked";
    private static final String UNLOCKED_VALUE = "unlocked";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private String name;
    private String ownerName;
    private Date lastAccess;
    private Date lastUpdate;
    private String description;
    private String revisionSpec;
    private boolean locked;
    private List<P4JClientView.P4JClientViewMapping> viewMapping;

    public P4JLabelImpl() {
        super(false, false, false, false);
        this.name = null;
        this.ownerName = null;
        this.lastAccess = null;
        this.lastUpdate = null;
        this.description = null;
        this.revisionSpec = null;
        this.locked = false;
        this.viewMapping = null;
    }

    public P4JLabelImpl(String name, String ownerName, Date lastAccess, Date lastUpdate, String description, String revisionSpec, boolean locked, List<P4JClientView.P4JClientViewMapping> viewMapping) {
        this.name = null;
        this.ownerName = null;
        this.lastAccess = null;
        this.lastUpdate = null;
        this.description = null;
        this.revisionSpec = null;
        this.locked = false;
        this.viewMapping = null;
        this.name = name;
        this.ownerName = ownerName;
        this.lastAccess = lastAccess;
        this.lastUpdate = lastUpdate;
        this.description = description;
        this.revisionSpec = revisionSpec;
        this.locked = locked;
        this.viewMapping = viewMapping;
    }

    public P4JLabelImpl(Map<String, Object> map, boolean fromList, P4JServer server) {
        block19: {
            super(!fromList, true, true, false);
            this.name = null;
            this.ownerName = null;
            this.lastAccess = null;
            this.lastUpdate = null;
            this.description = null;
            this.revisionSpec = null;
            this.locked = false;
            this.viewMapping = null;
            if (map == null) {
                throw new P4JNullPointerError("Null map passed to map-based P4JLabelImpl constructor");
            }
            this.server = server;
            if (fromList) {
                try {
                    this.name = (String)map.get("label");
                    this.description = (String)map.get("Description");
                    this.ownerName = (String)map.get("Owner");
                    this.lastUpdate = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                    this.lastAccess = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                    this.revisionSpec = (String)map.get("Revision");
                    String optStr = (String)map.get("Options");
                    if (optStr == null) break block19;
                    if (optStr.equalsIgnoreCase(LOCKED_VALUE)) {
                        this.locked = true;
                    } else if (optStr.equalsIgnoreCase(UNLOCKED_VALUE)) {
                        this.locked = false;
                    }
                }
                catch (Throwable thr) {
                    P4JLog.error("Unexpected exception in P4JLabelImpl constructor: " + thr.getLocalizedMessage());
                    P4JLog.exception(thr);
                }
            } else {
                this.complete = true;
                try {
                    String mappingStr;
                    this.name = (String)map.get("Label");
                    this.description = (String)map.get("Description");
                    this.ownerName = (String)map.get("Owner");
                    this.revisionSpec = (String)map.get("Revision");
                    try {
                        if (map.containsKey("Update")) {
                            this.lastUpdate = new SimpleDateFormat(DATE_FORMAT).parse((String)map.get("Update"));
                        }
                        if (map.containsKey("Access")) {
                            this.lastAccess = new SimpleDateFormat(DATE_FORMAT).parse((String)map.get("Access"));
                        }
                    }
                    catch (ParseException pe) {
                        P4JLog.error("Date parse error in P4JLabelImpl constructor: " + pe.getLocalizedMessage());
                        P4JLog.exception(pe);
                    }
                    String optStr = (String)map.get("Options");
                    if (optStr != null) {
                        if (optStr.equalsIgnoreCase(LOCKED_VALUE)) {
                            this.locked = true;
                        } else if (optStr.equalsIgnoreCase(UNLOCKED_VALUE)) {
                            this.locked = false;
                        }
                    }
                    this.viewMapping = new ArrayList<P4JClientView.P4JClientViewMapping>();
                    int i = 0;
                    while ((mappingStr = (String)map.get("View" + i)) != null) {
                        String[] parts = mappingStr.split(" ");
                        this.viewMapping.add(new P4JClientViewImpl.P4JClientViewMappingImpl(i, parts[0], null));
                        ++i;
                    }
                }
                catch (Throwable thr) {
                    P4JLog.error("Unexpected exception in P4JLabelImpl constructor: " + thr.getLocalizedMessage());
                    P4JLog.exception(thr);
                }
            }
        }
    }

    private void updateFlags() {
        this.complete = this.description != null && this.ownerName != null && this.viewMapping != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JLabel refreshedLabel;
        P4JServer refreshServer = this.server;
        String refreshName = this.name;
        if (refreshServer != null && refreshName != null && (refreshedLabel = refreshServer.getLabel(refreshName)) != null) {
            this.description = refreshedLabel.getDescription();
            this.ownerName = refreshedLabel.getOwnerName();
            this.revisionSpec = refreshedLabel.getRevisionSpec();
            this.lastUpdate = refreshedLabel.getLastUpdate();
            this.lastAccess = refreshedLabel.getLastAccess();
            this.locked = refreshedLabel.isLocked();
            this.viewMapping = refreshedLabel.getViewMapping();
        }
        this.updateFlags();
    }

    @Override
    public String updateOnServer() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.server == null) {
            throw new P4JRequestException("label not associated with any Perforce server");
        }
        return this.server.updateLabel(this);
    }

    @Override
    public void update() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.server.updateLabel(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public List<P4JClientView.P4JClientViewMapping> getViewMapping() {
        if (this.viewMapping == null) {
            return new ArrayList<P4JClientView.P4JClientViewMapping>();
        }
        return this.viewMapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public String getRevisionSpec() {
        return this.revisionSpec;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRevisionSpec(String revisionSpec) {
        this.revisionSpec = revisionSpec;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setViewMapping(List<P4JClientView.P4JClientViewMapping> viewMapping) {
        this.viewMapping = viewMapping;
    }

    public P4JServer getServer() {
        return this.server;
    }

    public void setServer(P4JServer server) {
        this.server = server;
    }
}

