/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.core.P4JJobSpec;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.server.P4JServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JJobSpecImpl
extends P4JServerResourceImpl
implements P4JJobSpec {
    private String comments = null;
    private List<P4JJobSpec.P4JJobSpecField> fields = new ArrayList<P4JJobSpec.P4JJobSpecField>();
    private Map<String, String> presets = new HashMap<String, String>();
    private Map<String, List<String>> values = new HashMap<String, List<String>>();

    public P4JJobSpecImpl() {
    }

    public P4JJobSpecImpl(Map<String, Object> map, P4JServer server) {
        super(false, true, true, false);
        this.server = server;
        if (map != null) {
            try {
                this.comments = (String)map.get("Comments");
                String fieldStr = null;
                int i = 0;
                while ((fieldStr = (String)map.get("Fields" + i)) != null) {
                    this.fields.add(new P4JobSpecFieldImpl(fieldStr));
                    ++i;
                }
                String valueStr = null;
                int i2 = 0;
                while ((valueStr = (String)map.get("Values" + i2)) != null) {
                    String[] values = valueStr.trim().split(" ");
                    if (values != null && values.length == 2 && values[0] != null) {
                        String[] vStrs;
                        ArrayList<String> valList = new ArrayList<String>();
                        if (values[1] != null && (vStrs = values[1].trim().split("/")) != null) {
                            for (String str : vStrs) {
                                if (str == null) continue;
                                valList.add(str);
                            }
                        }
                        this.values.put(values[0], valList);
                    }
                    ++i2;
                }
                String presetStr = null;
                int i3 = 0;
                while ((presetStr = (String)map.get("Presets" + i3)) != null) {
                    int firstSpace = presetStr.indexOf(" ");
                    if (firstSpace > 0 && firstSpace < presetStr.length() + 1) {
                        String key = presetStr.substring(0, firstSpace);
                        String value = presetStr.substring(firstSpace + 1);
                        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
                            value = value.substring(1, value.length() - 2);
                        }
                        this.presets.put(key, value);
                    }
                    ++i3;
                }
                this.complete = true;
            }
            catch (Exception exc) {
                P4JLog.error("Unexpected exception: " + exc.getLocalizedMessage());
                P4JLog.exception(exc);
                throw new P4JError("Unexpected conversion exception in P4JJobSpecImpl constructor: " + exc.getLocalizedMessage());
            }
        }
    }

    private void updateFlags() {
        this.complete = this.comments != null && this.fields != null && this.presets != null && this.values != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JJobSpec refreshedJobSpec;
        P4JServer refreshServer = this.server;
        if (refreshServer != null && (refreshedJobSpec = refreshServer.getJobSpec()) != null) {
            this.comments = refreshedJobSpec.getComments();
            this.fields = refreshedJobSpec.getFields();
            this.presets = refreshedJobSpec.getPresets();
            this.values = refreshedJobSpec.getValues();
        }
        this.updateFlags();
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public List<P4JJobSpec.P4JJobSpecField> getFields() {
        return this.fields;
    }

    @Override
    public Map<String, String> getPresets() {
        return this.presets;
    }

    @Override
    public Map<String, List<String>> getValues() {
        return this.values;
    }

    @Override
    public List<String> getFieldValues(String fieldName) {
        return this.values.get(fieldName);
    }

    @Override
    public String getFieldPreset(String fieldName) {
        return this.presets.get(fieldName);
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setFields(List<P4JJobSpec.P4JJobSpecField> fields) {
        this.fields = fields;
    }

    public void setPresets(Map<String, String> presets) {
        this.presets = presets;
    }

    public void setValues(Map<String, List<String>> values) {
        this.values = values;
    }

    protected class P4JobSpecFieldImpl
    implements P4JJobSpec.P4JJobSpecField {
        private int code = 0;
        private String dataType = null;
        private String fieldType = null;
        private int length = 0;
        private String name = null;

        protected P4JobSpecFieldImpl() {
        }

        protected P4JobSpecFieldImpl(String fieldStr) {
            if (fieldStr != null) {
                try {
                    String[] fields = fieldStr.split(" ");
                    if (fields == null || fields.length != 5) {
                        throw new P4JError("Field conversion or format error in P4JobSpecFieldImpl constructor");
                    }
                    if (fields[0] != null) {
                        this.code = new Integer(fields[0].trim());
                    }
                    if (fields[1] != null) {
                        this.name = fields[1].trim();
                    }
                    if (fields[2] != null) {
                        this.dataType = fields[2].trim();
                    }
                    if (fields[3] != null) {
                        this.length = new Integer(fields[3].trim());
                    }
                    if (fields[4] != null) {
                        this.fieldType = fields[4].trim();
                    }
                }
                catch (Exception exc) {
                    P4JLog.exception(exc);
                    throw new P4JError("Field conversion or format error in P4JobSpecFieldImpl constructor: " + exc.getLocalizedMessage());
                }
            }
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

