/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.client.P4JClient;
import com.perforce.p4java.client.P4JClientView;
import com.perforce.p4java.core.P4JChangeList;
import com.perforce.p4java.core.P4JLabel;
import com.perforce.p4java.core.file.P4JFileSpec;
import com.perforce.p4java.exception.P4JException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JInputMapper {
    public static Map<String, Object> map(P4JChangeList change) {
        HashMap<String, Object> changeMap = new HashMap<String, Object>();
        if (change != null) {
            if (change.getId() == -1) {
                changeMap.put("Change", "new");
            } else {
                changeMap.put("Change", "" + change.getId());
            }
            changeMap.put("Description", change.getDescription());
            if (change.getClientId() != null) {
                changeMap.put("Client", change.getClientId());
            }
            if (change.getUsername() != null) {
                changeMap.put("User", change.getUsername());
            }
            try {
                List<String> jobIdList;
                if (change.getId() != -1 && change.getFiles(false) != null) {
                    int i = 0;
                    for (P4JFileSpec spec : change.getFiles(false)) {
                        changeMap.put("Files" + i++, spec.getDepotPath());
                    }
                }
                if ((jobIdList = change.getJobIdList()) != null && jobIdList.size() > 0) {
                    int i = 0;
                    for (String jobId : jobIdList) {
                        changeMap.put("Jobs" + i++, jobId);
                    }
                }
            }
            catch (P4JException exc) {
                P4JLog.error("Unexpected exception in P4JInputMapper.map(P4JChangeList change): " + exc.getLocalizedMessage());
            }
        }
        return changeMap;
    }

    public static Map<String, Object> map(P4JClient client) {
        HashMap<String, Object> clientMap = new HashMap<String, Object>();
        if (client != null) {
            clientMap.put("Client", client.getName());
            clientMap.put("Owner", client.getOwnerName());
            clientMap.put("Description", client.getDescription());
            if (client.getHostName() != null) {
                clientMap.put("Host", client.getHostName());
            }
            clientMap.put("Root", client.getRoot());
            if (client.getAlternateRoots() != null) {
                int i = 0;
                for (String altRoot : client.getAlternateRoots()) {
                    if (altRoot == null) continue;
                    clientMap.put("AltRoots" + i++, altRoot);
                }
            }
            if (client.getLineEnd() != null) {
                clientMap.put("LineEnd", client.getLineEnd().toString().toLowerCase());
            }
            P4JClient.P4JClientOptions opts = client.getOptions();
            P4JClient.P4JClientSubmitOptions subOpts = client.getSubmitOptions();
            P4JClientView view = client.getClientView();
            if (opts != null) {
                String optStr = "" + (opts.isAllWrite() ? "allwrite " : "noallwrite ") + (opts.isClobber() ? "clobber " : "noclobber ") + (opts.isCompress() ? "compress " : "nocompress ") + (opts.isLocked() ? "locked " : "unlocked ") + (opts.isModtime() ? "modtime " : "nomodtime ") + (opts.isRmdir() ? "rmdir" : "normdir");
                clientMap.put("Options", optStr);
            }
            if (subOpts != null) {
                String subOptsStr = "";
                if (subOpts.isSubmitunchanged()) {
                    subOptsStr = "submitunchanged";
                } else if (subOpts.isSubmitunchangedReopen()) {
                    subOptsStr = "submitunchanged+reopen";
                } else if (subOpts.isLeaveunchanged()) {
                    subOptsStr = "leaveunchanged";
                } else if (subOpts.isLeaveunchangedReopen()) {
                    subOptsStr = "leaveunchanged+reopen";
                } else if (subOpts.isRevertunchanged()) {
                    subOptsStr = "revertunchanged";
                } else if (subOpts.isRevertunchangedReopen()) {
                    subOptsStr = "revertunchanged+reopen";
                }
                clientMap.put("SubmitOptions", subOptsStr);
            }
            if (view != null && view.getMapping() != null) {
                List<P4JClientView.P4JClientViewMapping> viewMapping = view.getMapping();
                for (P4JClientView.P4JClientViewMapping mapping : viewMapping) {
                    clientMap.put("View" + mapping.getOrder(), mapping.getDepotSpec() + " " + mapping.getClientSpec());
                }
            }
        }
        return clientMap;
    }

    public static Map<String, Object> map(P4JLabel label) {
        String LOCKED = "locked";
        String UNLOCKED = "unlocked";
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        if (label != null) {
            List<P4JClientView.P4JClientViewMapping> viewMaps;
            labelMap.put("Label", label.getName());
            labelMap.put("Owner", label.getOwnerName());
            labelMap.put("Description", label.getDescription());
            labelMap.put("Options", label.isLocked() ? "locked" : "unlocked");
            if (label.getRevisionSpec() != null) {
                labelMap.put("Revision", label.getRevisionSpec());
            }
            if (label.getLastUpdate() != null) {
                labelMap.put("Update", label.getLastUpdate().toString());
            }
            if (label.getLastAccess() != null) {
                labelMap.put("Access", label.getLastAccess().toString());
            }
            if ((viewMaps = label.getViewMapping()) != null) {
                int i = 0;
                for (P4JClientView.P4JClientViewMapping mapping : viewMaps) {
                    labelMap.put("View" + i, mapping.getDepotSpec());
                    ++i;
                }
            }
        }
        return labelMap;
    }
}

